;;; -*- Mode: Common-Lisp -*-

;;;--------------------------------------------------------------------------------
;;Below is how you can have a spinning cursor, for visually telling your user that
;;your command is busy working in your CLIM application!
;;This was done in Franz's ACL4.1/CLIM1.1 on a SPARC!
;;Read the comments as you go for explanations!
;;;--------------------------------------------------------------------------------

(defvar *Your-Application* nil "Bind to the application instance, eventually")

;;;Within your application definition form add these five slots to it!!!!

(define-application-frame Your-Application (application-frame)
   ((X-Window :initform nil :reader X-Window) ;x-window for cursor stuff
    (Accept-On-P :initform nil :accessor Accept-On-P) ;flag to indicate to spinning-process that user has to input within a command
    (Spin-Cursor-P :initform nil :accessor Spin-Cursor-P) ;flag to indicate that the cursor is in a spin state
    (Cursor-List :initform nil :accessor Cursor-List) ;list of various cursor pixmaps
    (Time-Cursor-On :initform t :accessor Time-Cursor-On)) ;flag to turn on/off the spinning-cursor capability
   ...)   ;the rest of your application stuff panes, layout, etc.


;;;You need to add an after initialize-instance method, if you don't already have one!

(defmethod Initialize-Instance :after ((SELF Your-Application) &key)
  ;These two forms below are needed
  (setf *Your-Application* SELF (X-Window SELF) (clim::clx-stream-window (frame-top-level-window SELF)))
  (Build-Spinning-Cursor))

;;;This is to spawn the spinning-cursor process if desired during the command's execution!

(defmethod execute-frame-command :around ((SELF Your-Application) command)
    (with-slots (Spin-Cursor-P X-Window Time-Cursor-On Accept-On-P) SELF
      (unwind-protect
	  (progn
	    (when (setf Accept-On-P nil Spin-Cursor-P Time-Cursor-On)
;;;Now if you do separate accepts or accept-values within the commands you need to preceed them with a (setf Accept-On-P t) and
;;;follow their form by a (setf Accept-On-P nil) after, else your cursor process will keep spinning even during the accept (heap bad).
;;;Of course you could always build a macro to automatically do that for you!
	      (mp:process-run-function (list :name "Spinning Cursor Process" :priority 180
					;spawn the spinning-cursor process with almost a 2x priority over the application process!!!!
					     :initial-bindings `((*package* . ,*package*) . ,excl:*cl-default-special-bindings*))
				       'Cycle-Spinner))
	    (call-next-method SELF command))
	(setf Spin-Cursor-P nil))))

;;;Command to turn on/off the spinning cursor during application operation

(define-command (com-Spinning-Cursor :command-table your-command-table :name t)
    ((On '(completion (Yes No)) :default (cond ((null (Time-Cursor-On *Your-Application*)) 'No) (t 'Yes))
	 :provide-default t :display-default t))
  (declare (special *Your-Application*))
  (setf (Time-Cursor-On *Your-Application*) (eq On 'Yes))
  nil)

;;;I always bring up my application as a separate process to keep my LISP free!
(defun Bring-Up-Application ()
  (declare (special *Your-Application*))
  (setf (get '*Your-Application* 'process)
    (mp:process-run-function (list :name "Your-Application" :priority 100 ;NOTE - the priority is about 1/2 the spinning-cursor's
				   :initial-bindings `((*package* . ,*package*) . ,excl:*cl-default-special-bindings*))
			     'run-frame-top-level *Your-Application*)))

;;Below is two functions that I munged a bit from the change-mouse-cursor stuff from the CLIM-1 portion of the library

(defun Build-Spinning-Cursor ()
  (declare (special *Your-Application*))
  (let* ((pixmap (xlib:create-pixmap :width 30 :height 30 :depth 1 :drawable (X-Window *Your-Application*)))
	 (mask-pixmap (xlib:create-pixmap :width 30 :height 30 :depth 1 :drawable (X-Window *Your-Application*)))
	 (pgc (xlib:create-gcontext :drawable pixmap :arc-mode :pie-slice :foreground 1 :background 0))
	 foreground-red foreground-green foreground-blue background-red background-green background-blue foreground background)
    ;; Cursor foreground is all 1's
    (setf (Cursor-List *Your-Application*) (list 0))
    (xlib:draw-rectangle pixmap pgc 0 0 30 30 t)
    (SETMV (foreground-red foreground-green foreground-blue) (color-rgb (medium-foreground (Display-Frame *Your-Application*))))
    (SETMV (background-red background-green background-blue) (color-rgb (medium-background (Display-Frame *Your-Application*))))
    (setq foreground (xlib:make-color :red foreground-red :green foreground-green :blue foreground-blue)
	  background  (xlib:make-color :red background-red :green background-green :blue background-blue))
    ;; Clear the pixmap, because it doesn't have a 'background' and may inherit some garbage
    (xlib:with-gcontext (pgc :foreground 0) (xlib:draw-rectangle mask-pixmap pgc 0 0 30 30 t))
    ;; Cursor mask is a circle, so the cursor is a "see-through" circle
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 0 (* pi 2) nil)
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 0  (* 0.25 pi) t)
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 pi (* 0.25 pi) t)
    ;;now make the cursor. octants 1 & 5
    (push (xlib:create-cursor :source pixmap :mask mask-pixmap :x 15 :y 15 :foreground foreground :background background)
	  (cdr (Cursor-List *Your-Application*)))
    (setq mask-pixmap (xlib:create-pixmap :width 30 :height 30 :depth 1 :drawable (X-Window *Your-Application*)))
    (xlib:with-gcontext (pgc :foreground 0) (xlib:draw-rectangle mask-pixmap pgc 0 0 30 30 t))
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 0 (* pi 2) nil)
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 (* 0.25 pi) (* 0.25 pi) t)
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 (* 1.25 pi) (* 0.25 pi) t)
    ;;now make the cursor. octants 2 & 6
    (push (xlib:create-cursor :source pixmap :mask mask-pixmap :x 15 :y 15 :foreground foreground :background background)
	  (cdr (Cursor-List *Your-Application*)))
    (setq mask-pixmap (xlib:create-pixmap :width 30 :height 30 :depth 1 :drawable (X-Window *Your-Application*)))
    (xlib:with-gcontext (pgc :foreground 0) (xlib:draw-rectangle mask-pixmap pgc 0 0 30 30 t))
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 0 (* pi 2) nil)
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 (* 0.5 pi) (* 0.25 pi) t)
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 (* 1.5 pi) (* 0.25 pi) t)
    ;;now make the cursor. octants 3 & 7
    (push (xlib:create-cursor :source pixmap :mask mask-pixmap :x 15 :y 15 :foreground foreground :background background)
	  (cdr (Cursor-List *Your-Application*)))
    (setq mask-pixmap (xlib:create-pixmap :width 30 :height 30 :depth 1 :drawable (X-Window *Your-Application*)))
    (xlib:with-gcontext (pgc :foreground 0) (xlib:draw-rectangle mask-pixmap pgc 0 0 30 30 t))
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 0 (* pi 2) nil)
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 (* 0.75 pi) (* 0.25 pi) t)
    (xlib:draw-arc mask-pixmap pgc 2 2 26 26 (* 1.75 pi) (* 0.25 pi) t)
    ;;now make the cursor. octants 4 & 8
    (push (xlib:create-cursor :source pixmap :mask mask-pixmap :x 15 :y 15 :foreground foreground :background background)
	  (cdr (Cursor-List *Your-Application*)))
    (setf (cdr (Cursor-List *Your-Application*)) (reverse (cdr (Cursor-List *Your-Application*))))))

;;Here, we are creating a function for executing as an independent process if the application sets spin-cursor-p t!
;;You might have to tweak the delta time of 20 in the process-wait form that I use for your machine!
(defun cycle-spinner (&aux (old-time (get-internal-run-time)))
  (declare (special *Your-Application*))
  ;After loop is done, return the cursor back to the arrow form!
  (loop while (Spin-Cursor-P *Your-Application*) finally (setf (xlib:window-cursor (X-Window *Your-Application*)) :None) do
	;Oh gee, better suspend process when there is no accepting or every so often otherwise the cursor will become hypnotic!
	(mp:process-wait "" #'(lambda (o-time)
				(cond ((Accept-On-P *Your-Application*) nil)
				      ((> (abs (- (get-internal-run-time) o-time)) 20) (setq old-time (get-internal-run-time)))) old-time))
	;Lets, change the cursor a bit here!
	(excl:without-interrupts
	    (setf (xlib:window-cursor (X-Window *Your-Application*))
	      (nth (car (Cursor-List *Your-Application*)) (cdr (Cursor-List *Your-Application*))))    ;; Install the cursor;
	  (xlib:display-force-output (xlib:drawable-display (X-Window *Your-Application*)))        ;; Make the change take effect.
	  (setf (car (Cursor-List *Your-Application*)) (mod (incf (car (Cursor-List *Your-Application*))) 4)))) ;;rotate for next time.
  ;;This cond may not be necessary, but I wanted to insure that my application gets the next quantum of machine time, if its
  ;;up and running!!
  (xlib:display-force-output (xlib:drawable-display (Apgen-X-Window *Apgen*)))
  (cond ((get '*Your-Application* 'process) (mp:process-allow-schedule (get '*Your-Application* 'process)))
	(t (mp:process-allow-schedule))))
