;;; -*- mode: common-lisp; package: cl-user; base:10. -*-

;;;****************************************************************
;;;****************************************************************

;;;some sample code for creating and using picture buttons. this works pretty well.

;;;to use, substitute your command-table name, and your define-...-command name

;;;Written by Clint Hyde, October 1992. Works with CLIM 1.1.

;;;****************************************************************
;;;****************************************************************

;;;first, the defclass. NAME could probably be punted.
;;;PICTURE is of course the icon/bitmap. X and Y are the position in the window.
;;;FORM is a s-expression which gets EVAL'd when the button is clicked.

;;;****************************************************************
;;;****************************************************************

(defclass picture-button ()
	  ((picture :initform () :initarg :picture :accessor picture)
	   (name :initform (INTERN (STRING (GENSYM "PICTURE-BUTTON-"))
				   *package*)
		 :initarg :name :accessor name)
	   (highlighted :initform () :initarg :highlighted :accessor highlighted)
	   (form :initform () :initarg :form :accessor form)
	   (x :initform () :initarg :x :accessor x)
	   (y :initform () :initarg :y :accessor y))
  )

;;;****************************************************************

(clim:define-presentation-method clim:present
				 (myself (p-type picture-button) stream (view ev-view)
					 &key acceptably context-type)
  (declare (ignore acceptably context-type))
  (clim:with-output-as-presentation (:object myself :stream stream :single-box t)
    (clim:draw-icon* stream (picture myself) (x myself) (y myself)))
  )

;;;****************************************************************

;;;this may or may not be a good idea. it probably would get confused with being clicked.

(clim:define-presentation-method clim:highlight-presentation ((type picture-button) record stream state)
  (declare (ignore state))	;we'll just use XOR
  (multiple-value-bind (xoff yoff)
      (clim:convert-from-relative-to-absolute-coordinates
       stream (clim:output-record-parent record))
    (clim:with-bounding-rectangle* (left top right bottom) record
	   (clim:draw-rectangle* stream
				 ;;draw the box half-full. was (+ top yoff).
				 (+ left xoff)  (+ top yoff)
				 (+ right xoff) (+ bottom yoff)
				 :ink clim:+flipping-ink+ :filled t)
	   )
    )
  )

;;;****************************************************************
;;;****************************************************************

;;;a macro, for pretty usage.

(defmacro with-button-blinked (myself stream &body body)
  `(progn
     (setf (highlighted myself) t)
     (clim:present ,myself 'ok-button :stream stream :single-box t)
     (clim:stream-force-output stream)
     (unwind-protect
	 (progn ,@body)
       (sleep 0.5)
       (setf (highlighted myself) ())
       (clim:present ,myself 'ok-button :stream stream :single-box t)
       (clim:stream-force-output stream)
       )
     )
  )

;;;****************************************************************
;;;****************************************************************

(define-...-command (com-click-button :menu nil) ((myself 'picture-button) (stream t))
  (declare (special stream))
  (if (form myself)
      (with-button-blinked (myself stream)
	(eval (form myself)))
    )
  )

;;;****************************************************************

(clim:define-presentation-to-command-translator pic-button (picture-button com-click-button 
									   <your-command-table>
									   :gesture :select
									   :pointer-documentation
									   "Click this button"
									   :menu nil)
  (object window)				;arglist ;(presentation context-type frame event x y)
  (list object window)
  )

;;;****************************************************************
;;;****************************************************************
;;;****************************************************************

;;;an incremental display function. actually not incremental, but used that way by the frame.
;;;the buttons know where to draw themselves.

(defun vert-scroll (frame pane)
  (declare (ignore frame))
  (clim:window-clear pane)
  (clim:present up-button 'picture-button :stream pane :view +event-view+)
  (clim:present dn-button 'picture-button :stream pane :view +event-view+)
  ())

;;;****************************************************************
;;;****************************************************************
;;;****************************************************************

;;;and now the actual buttons. this is an up-arrow, for scrolling.

(defparameter up-button (make-instance 'picture-button
			  :picture (clim:make-pattern #2a((0 0 0 0 0 0 1 0 0 0 0 0 0)
							  (0 0 0 0 0 1 0 1 0 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 1 0 0 0 0 0 1 0 0 0)
							  (0 0 1 0 0 0 0 0 0 0 1 0 0)
							  (0 1 0 0 0 0 0 0 0 0 0 1 0)
							  (1 0 0 0 0 0 0 0 0 0 0 0 1)
							  (1 1 1 1 1 1 1 1 1 1 1 1 1)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 1 1 1 1 0 0 0 0)
							  )
						      (list clim:+background+ clim:+foreground+))
			  :form '(multiple-value-bind (x y)
				  (clim:window-viewport-position* stream)
				  (clim:window-set-viewport-position* x (+ y 17)))
			  :x 15
			  :y 5)
  )

;;;****************************************************************

;;;this is a down-arrow, also for scrolling.

(defparameter dn-button (make-instance 'picture-button
			  :picture (clim:make-pattern #2a((0 0 0 0 1 1 1 1 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (1 1 1 1 1 1 1 1 1 1 1 1 1)
							  (1 0 0 0 0 0 0 0 0 0 0 0 1)
							  (0 1 0 0 0 0 0 0 0 0 0 1 0)
							  (0 0 1 0 0 0 0 0 0 0 1 0 0)
							  (0 0 0 1 0 0 0 0 0 1 0 0 0)
							  (0 0 0 0 1 0 0 0 1 0 0 0 0)
							  (0 0 0 0 0 1 0 1 0 0 0 0 0)
							  (0 0 0 0 0 0 1 0 0 0 0 0 0)
							  )
						      (list clim:+background+ clim:+foreground+))
			  :form '(multiple-value-bind (x y)
				  (clim:window-viewport-position* stream)
				  (clim:window-set-viewport-position* x (- y 17)))
			  :x 15
			  :y 35)
  )

;;;****************************************************************
;;;****************************************************************
;;;****************************************************************
;;;
;;; end of file
;;;
;;;****************************************************************
;;;****************************************************************
;;;****************************************************************
