Below are both the original mail message written by Erik Eilerts and 4 replies showing examples of how to use draw-icon.

Vincent

Keunen Vincent                  Network Research Belgium
R&D, Software Engineer          Parc Industriel des Hauts-Sarts
keunen@nrb.be                   2e Avenue, 65
tel: +32 41 407282              B-4040 Herstal
fax: +32 41 481170              BELGIUM

----------------------------------
From: eilerts@cs.utexas.edu
To: clim@BBN.COM

	  I'm looking for a working example of draw-icon* that uses make-pattern
    to make the bitmap.  If anyone has this, could they send it to me?

	  Thanks,

	     Erik Eilerts
	     University of Texas at Austin
	     eilerts@cs.utexas.edu

----------------------------------
Date: Fri, 23 Oct 1992 20:57+0200
From: Scott McKay <SWM@stony-brook.scrc.symbolics.com>
Subject: draw-icon
To: eilerts@cs.utexas.edu, clim@BBN.COM
In-Reply-To: <9210231739.AA07625@sage.cs.utexas.edu>

    Date: Fri, 23 Oct 1992 13:39 EDT
    From: Erik Eilerts <eilerts@cs.utexas.edu>

	  I'm looking for a working example of draw-icon* that uses make-pattern
    to make the bitmap.  If anyone has this, could they send it to me?

(defvar *prompt-arrow* 
	(make-pattern #2A((0 0 0 0 0 0 0 0 0 0 0 0)
			  (0 0 0 0 0 1 0 0 0 0 0 0)
			  (0 0 0 0 0 1 1 0 0 0 0 0)
			  (0 1 1 1 1 1 1 1 0 0 0 0)
			  (0 1 1 1 1 1 1 1 1 0 0 0)
			  (0 0 0 0 0 0 0 1 1 1 0 0)
			  (0 0 0 0 0 0 0 0 1 1 1 0)
			  (0 0 0 0 0 0 0 1 1 1 0 0)
			  (0 1 1 1 1 1 1 1 1 0 0 0)
			  (0 1 1 1 1 1 1 1 0 0 0 0)
			  (0 0 0 0 0 1 1 0 0 0 0 0)
			  (0 0 0 0 0 1 0 0 0 0 0 0))
		      (list +background-ink+ +foreground-ink+)))

Calling DRAW-ICON* (called DRAW-PATTERN* in CLIM 2.0, by the way) should
do what you expect.

BTW, MAKE-PATTERN doesn't make a bitmap.  It makes a pattern.  I know
this sounds like quibbling, but a pattern is a fully device-independent
object, whereas a bitmap (or a pixmap) is device-dependent.
----------------------------------
Date: Fri, 23 Oct 1992 20:49+0200
From: Clinton Hyde <chyde@chesapeake.ads.com>
To: eilerts@cs.utexas.edu
cc: clim@BBN.COM
In-Reply-To: Erik Eilerts's message of Fri, 23 Oct 1992 12:39:18 -0500 <9210231739.AA07625@sage.cs.utexas.edu>
Subject: Re: draw-icon


here's a complete working version.

 -- clint


;;;****************************************************************
;;;****************************************************************
;;;****************************************************************

(defclass picture-button ()
	  ((picture :initform () :initarg :picture :accessor picture)
	   (name :initform (INTERN (STRING (GENSYM "PICTURE-BUTTON-"))
				   *package*)
		 :initarg :name :accessor name)
	   (highlighted :initform () :initarg :highlighted :accessor highlighted)
	   (form :initform () :initarg :form :accessor form)
	   (x :initform () :initarg :x :accessor x)
	   (y :initform () :initarg :y :accessor y))
  )

(clim:define-presentation-method clim:present
				 (myself (p-type picture-button) stream view
					 &key acceptably context-type)
  (declare (ignore acceptably context-type))
  (clim:with-output-as-presentation (:object myself :stream stream :single-box t)
    (clim:draw-icon* stream (picture myself) (x myself) (y myself)))
  )

(defparameter up-button (make-instance 'picture-button
		    :picture (clim:make-pattern #2a((0 0 0 0 0 0 1 0 0 0 0 0 0)
						    (0 0 0 0 0 1 0 1 0 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 1 0 0 0 0 0 1 0 0 0)
						    (0 0 1 0 0 0 0 0 0 0 1 0 0)
						    (0 1 0 0 0 0 0 0 0 0 0 1 0)
						    (1 0 0 0 0 0 0 0 0 0 0 0 1)
						    (1 1 1 1 1 1 1 1 1 1 1 1 1)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 1 1 1 1 0 0 0 0)
						    )
						(list clim:+background+ clim:+foreground+))
		    :x 15
		    :y 5)
  )

(clim:define-presentation-to-command-translator pic-button (picture-button com-click-button 
									   timeline-command-table
									   :gesture :select
									   :pointer-documentation "Click this button"
									   :menu nil)
  (object)				;arglist ;(presentation context-type frame event window x y)
  (list object)
  )

(define-cdp-command (com-click-button :menu nil) ((myself 'picture-button))

  (if (form myself)
      (eval (form myself))
    )
  )

;;;****************************************************************

(clim:define-presentation-method clim:highlight-presentation ((type picture-button) record stream state)
  (declare (ignore state))	;we'll just use XOR
  (multiple-value-bind (xoff yoff)
      (clim:convert-from-relative-to-absolute-coordinates
       stream (clim:output-record-parent record))
    (clim:with-bounding-rectangle* (left top right bottom) record
	   (clim:draw-rectangle* stream
				 ;;draw the box half-full. was (+ top yoff).
				 (+ left xoff)  (+ top yoff)
				 (+ right xoff) (+ bottom yoff)
				 :ink clim:+flipping-ink+ :filled t)
	   )
    ))


(defparameter dn-button (make-instance 'picture-button
		    :picture (clim:make-pattern #2a((0 0 0 0 1 1 1 1 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (1 1 1 1 1 1 1 1 1 1 1 1 1)
						    (1 0 0 0 0 0 0 0 0 0 0 0 1)
						    (0 1 0 0 0 0 0 0 0 0 0 1 0)
						    (0 0 1 0 0 0 0 0 0 0 1 0 0)
						    (0 0 0 1 0 0 0 0 0 1 0 0 0)
						    (0 0 0 0 1 0 0 0 1 0 0 0 0)
						    (0 0 0 0 0 1 0 1 0 0 0 0 0)
						    (0 0 0 0 0 0 1 0 0 0 0 0 0)
						    )
						(list clim:+background+ clim:+foreground+))
		    :x 15
		    :y 35)
  )


(defun vert-scroll (frame pane)
  (declare (ignore frame))
  (clim:window-clear pane)
  (clim:present up-button 'picture-button :stream pane)
  (clim:present dn-button 'picture-button :stream pane)
  )

;;;(vert-scroll () (clim:get-frame-pane (slot-value *cdp-frame* 'timeline-window) 'up-scroll))

;;;****************************************************************
;;;****************************************************************
;;;****************************************************************
;;;
;;; end of file
;;;
;;;****************************************************************
;;;****************************************************************
;;;****************************************************************
----------------------------------
Date: Fri, 23 Oct 1992 19:48+0200
From: Jeff Close <jclose@potomac.ads.com>
To: eilerts@cs.utexas.edu
cc: clim@bbn.com
In-Reply-To: Erik Eilerts's message of Fri, 23 Oct 1992 12:39:18 -0500 <9210231739.AA07625@sage.cs.utexas.edu>
Subject: Re: draw-icon
Reply-To: jclose@ads.com


Erik,

Yes, I've got exactly that.  I'll send you some snippets to show what
I'm doing.

jeffrey
----------------------------------
Date: Fri, 23 Oct 1992 19:29+0200
From: James Lawton <lawton@ai.rl.af.mil>
Subject: draw-icon
To: eilerts@cs.utexas.edu, clim@BBN.COM
In-Reply-To: <9210231739.AA07625@sage.cs.utexas.edu>

	  I'm looking for a working example of draw-icon* that uses make-pattern
    to make the bitmap.  If anyone has this, could they send it to me?

	  Thanks,

	     Erik Eilerts
	     University of Texas at Austin
	     eilerts@cs.utexas.edu


Here you go.
James Lawton
Rome Laboratory

;;///////////////////////////  cut here \\\\\\\\\\\\\\\\\\\\\\\\\\\
;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER; Base: 10 -*-

;; Below is a short segment of code that
;; draws an airplane glyph somewhere on the on a display pane.
;; To try it, load it into either Genera or Allegro CL (with CLIM loaded, 
;; of course).  For Allegro, run "(start)".  For Genera, type <select>-<circle>.


(clim::define-application-frame test-frame ()
    ()
  (:panes ((display :application)
	   (interactor :interactor)))
  (:layout ((main (:column :rest
		   (display 0.80)
		   (interactor :rest))))
	   ))

#+allegro
(defvar *main-screen* (clim::open-root-window :clx))
#+allegro
(defvar *test-frame* (clim::make-application-frame 'test-frame
						   :parent *main-screen*
		  				   :top 100
						   :left 100
						   :width 800
						   :height 600))
#+allegro
(defun start ()
  (clim::run-frame-top-level *test-frame*))

#+symbolics
(clim:define-genera-application test-frame :select-key #\square)


(defun stream-of (pane-name)
  (clim::get-frame-pane clim::*application-frame* pane-name))



(define-test-frame-command (com-erase :name "Erase") ()
  (clim::window-clear (stream-of 'display)))



(defvar AIRFONT-glyph-0 (clim::make-pattern
			 #2A((0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0)
			     (1 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0)
			     (1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0)
			     (1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
			     (1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0)
			     (1 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0)
			     (1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0)
			     (1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     (0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
			     )
			 (list clim::+background+ clim::+foreground+)))


(define-test-frame-command (draw-glyph :name "Draw Glyph")
    ((x '(integer 0 800))
     (y '(integer 0 600)))
  (clim::draw-icon* (stream-of 'display) AIRFONT-glyph-0 x y))


(define-test-frame-command (com-exit :menu t :name "exit") ()
  (clim::frame-exit clim::*application-frame*))

----------------------------------
