; -*- mode:     CL -*- ----------------------------------------------------- ;
; File:         pc1-printers.l
; Description:  
; Author:       Joachim H. Laubsch
; Created:      13-Apr-92
; Modified:     Tue Apr 27 09:54:57 1993 (Joachim H. Laubsch)
; Language:     CL
; Package:      CL-USER
; Status:       Experimental (Do Not Distribute) 
; RCS $Header: $
;
; (c) Copyright 1992, Hewlett-Packard Company
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Revisions:
; RCS $Log: $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(in-package "CL-USER")

(defun PRINT-PROPOSITIONAL-VARIABLE (ITEM STREAM LEVEL)
  (DECLARE (IGNORE LEVEL))
  (format STREAM
	  "~S"
	  (PROPOSITIONAL-VARIABLE--name ITEM)))

(defun PRINT-BOOLEAN-OR (ITEM STREAM LEVEL)
  (DECLARE (IGNORE LEVEL))
  (format STREAM
	  "~S or ~S"
	  (BOOLEAN-EXPR--RAND1 ITEM)
	  (BOOLEAN-EXPR--RAND2 ITEM)))

(defun PRINT-BOOLEAN-AND (ITEM STREAM LEVEL)
  (DECLARE (IGNORE LEVEL))
  (format STREAM
	  "~S and ~S"
	  (BOOLEAN-EXPR--RAND1 ITEM)
	  (BOOLEAN-EXPR--RAND2 ITEM)))

(defun print-atomic-wff (item stream level)
  (declare (ignore level))
  (format stream
	  "~a(~a)"
	  (atomic-wff--predicate item)
	  (atomic-wff--role-argument-pairs item)))

(defun print-rap-list (item stream level)
  (declare (ignore level))
  (if (rap-empty-list-p (rap-list--rest item))
      (format stream "~a" (rap-list--first item))
    (format stream
	    "~a ~a"
	    (rap-list--first item)
	    (rap-list--rest item))))

(defun print-role-argument-pair (item stream level)
  (declare (ignore level))
  (format stream
	  "~a: ~a"
	  (role-argument-pair--role item)
	  (role-argument-pair--argument item)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                            end of pc1-printers.l
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
