';; -*- Mode:LISP; Package:BOXER; Base:10.;fonts:cptfont; -*-
;;
;; Copyright 1984 Massachusetts Institute of Technology
;;
;; Permission to use, copy, modify, distribute, and sell this software
;; and its documentation for any purpose is hereby granted without fee,
;; provided that the above copyright notice appear in all copies and that
;; both that copyright notice and this permission notice appear in
;; supporting documentation, and that the name of M.I.T. not be used in
;; advertising or publicity pertaining to distribution of the software
;; without specific, written prior permission.  M.I.T. makes no
;; representations about the suitability of this software for any
;; purpose.  It is provided "as is" without express or implied warranty.
;;
;;
;;                          +-Data--+
;; This file is part of the | BOXER | system
;;                          +-------+
;;
;; This file contains all of the boxer functions which use the graphics subsystem

;;; Graphics functions for graphics boxes




(defboxer-function bu:wrap ()
  (tell (graphics-box-near (box-being-told))
	:set-draw-mode :wrap)
  :noprint)

; fence should be fixed before this command is implemented.
;(defboxer-function bu:fence ()
;  (tell (graphics-box-near (box-being-told))
;	:set-draw-mode :fence)
;  :noprint)

(defboxer-function bu:window ()
  (tell (graphics-box-near (box-being-told))
	:set-draw-mode :window)
  :noprint)

;;; Graphics functions for Objects (especially turtles)

;;; This next subst directs a message to the appropriate turtle
;;;It replaces the magic-naming stuff in the old implementation

(defsubst tell-named-sprite (message &rest args)
  (let* ((sprite-box (sprite-box-near (box-being-told)))
	 (turtle (tell-check-nil sprite-box :associated-turtle)))
    (cond ((null turtle) (ferror "Use TELL to execute turtle commands outside a sprite box"))
	  ((null (tell turtle :assoc-graphics-box))
	   (ferror "Sprite is not in a Graphics Box"))
	  (t (lexpr-send turtle message args)))))


(defboxer-function bu:cs ()
  (let ((graphics-box (graphics-box-near (box-being-told))))
    (tell-check-nil graphics-box :clearscreen)))

(DEFBOXER-FUNCTION BU:CLEARSCREEN ()
  (let ((graphics-box (graphics-box-near (box-being-told))))
    (tell-check-nil graphics-box :clearscreen)))

(DEFBOXER-FUNCTION BU:FD ((NUMBERIZE STEPS))
 (TELL-named-sprite :FORWARD STEPS))

(DEFBOXER-FUNCTION BU:FORWARD ((NUMBERIZE STEPS))
  (TELL-named-sprite :FORWARD STEPS))

(DEFBOXER-FUNCTION BU:BK ((NUMBERIZE STEPS))
  (TELL-named-sprite :FORWARD (- STEPS)))

(DEFBOXER-FUNCTION BU:BACK ((NUMBERIZE STEPS))
  (TELL-named-sprite :FORWARD (- STEPS)))

(DEFBOXER-FUNCTION BU:RT ((NUMBERIZE TURNS))
  (tell-named-sprite :right TURNS))

(DEFBOXER-FUNCTION BU:RIGHT ((NUMBERIZE TURNS))
  (tell-named-sprite :right turns))

(DEFBOXER-FUNCTION BU:LT ((NUMBERIZE TURNS))
  (tell-named-sprite :right (- TURNS)))

(DEFBOXER-FUNCTION BU:LEFT ((NUMBERIZE TURNS))
  (tell-named-sprite :right (- TURNS)))

(DEFBOXER-FUNCTION BU:PU ()
  (TELL-named-sprite :set-pen 'up) ':NOPRINT)

(DEFBOXER-FUNCTION SETXY ((NUMBERIZE X) (NUMBERIZE Y))
  (tell-named-sprite :MOVE-TO X Y))

;;; home 
(defboxer-function bu:go-home ()
  (tell-named-sprite :go-home))

(defboxer-function bu:home ()
  (tell-named-sprite :go-home))

(DEFBOXER-FUNCTION BU:PENUP ()
  (TELL-NAMED-SPRITE :set-pen 'up) ':NOPRINT)

(DEFBOXER-FUNCTION BU:PD ()
  (TELL-NAMED-SPRITE :set-pen 'down) ':NOPRINT)

(DEFBOXER-FUNCTION BU:PENDOWN ()
  (TELL-NAMED-SPRITE :set-pen 'down) ':noprint)

(DEFBOXER-FUNCTION BU:PE ()
  (TELL-NAMED-SPRITE :set-pen 'erase) ':noprint)

(DEFBOXER-FUNCTION BU:PENERASE ()
  (TELL-NAMED-SPRITE :set-pen 'erase) ':noprint)

(DEFBOXER-FUNCTION BU:PENXOR ()
  (TELL-NAMED-SPRITE :set-pen 'xor) ':noprint)

(DEFBOXER-FUNCTION BU:PENREVERSE ()
  (TELL-NAMED-SPRITE :set-pen 'xor) ':noprint) 

(DEFBOXER-FUNCTION BU:PX ()
  (TELL-NAMED-SPRITE :set-pen 'xor) ':noprint)
 
(DEFBOXER-FUNCTION BU:HIDE ()
  (TELL-NAMED-SPRITE :HIDE-TURTLE) ':NOPRINT)

(DEFBOXER-FUNCTION BU:HIDETURTLE ()
  (TELL-NAMED-SPRITE :HIDE-TURTLE) ':NOPRINT)

(DEFBOXER-FUNCTION BU:HT ()
  (TELL-NAMED-SPRITE :HIDE-TURTLE) ':NOPRINT)

(DEFBOXER-FUNCTION BU:SHOW ()
  (TELL-NAMED-SPRITE :SHOW-TURTLE) ':NOPRINT)

(DEFBOXER-FUNCTION BU:SHOWTURTLE ()
  (TELL-NAMED-SPRITE :SHOW-TURTLE) ':NOPRINT)

(DEFBOXER-FUNCTION BU:ST ()
  (TELL-NAMED-SPRITE :SHOW-TURTLE) ':NOPRINT)

(DEFBOXER-FUNCTION BU:TOWARDS ((NUMBERIZE X) (NUMBERIZE Y))
  (TELL-NAMED-SPRITE :TOWARDS X Y))

(DEFBOXER-FUNCTION BU:SET-SCRUNCH ((NUMBERIZE NEW-SCRUNCH))
  (SETQ *SCRUNCH-FACTOR* NEW-SCRUNCH)
  :noprint)

(defboxer-function bu:flash-name ()
  (tell-named-sprite :flash-name)
  ':NOPRINT)

(defboxer-function bu:type ((PORTIFY BOX))
  (tell-named-sprite
	:type-box (GET-PORT-TARGET box))
  ':noprint)

(defboxer-function bu:follow-mouse ()
  (tell-named-sprite :usurp-mouse))

(defboxer-function bu:stamp ()
  (tell-named-sprite :stamp))

(defboxer-function bu:copy-self ()
  (copy-box (sprite-box-near (box-being-told)) nil))

(defboxer-function bu:rotate (angle)
  (tell-named-sprite :rotate (numberize angle))
  ':noprint)

(defboxer-function bu:ss ()
  (tell-named-sprite :set-shown-p :subsprites)
  :noprint)

(defboxer-function bu:sn ()
  (tell-named-sprite :set-shown-p :no-subsprites)
  :noprint)

(defboxer-function bu:touching? (sprite-b)
  (when (port-box? sprite-b) (setq sprite-b (tell sprite-b :ports)))
  (boxify
    (if 
      (tell-named-sprite :touching? (tell sprite-b :associated-turtle))
      'bu:true
      'bu:false)))

(defboxer-function bu:single-touching-sprite ()
  (let ((turtle (tell-named-sprite :sprite-under)))
    (if (turtle? turtle)
	(boxify (port-to-internal (tell turtle :sprite-box)))
	(make-box nil))))

(defboxer-function bu:all-touching-sprites ()
  (let ((turtles (tell-named-sprite :all-sprites-in-contact))
	 sprites)
    (dolist (turtle turtles)
      (setq sprites (cons (port-to-internal (tell turtle :sprite-box))
			  sprites)))
    (make-box (list sprites))))

(defboxer-function bu:enclosing-rectangle ()
  (multiple-value-bind (Left top right bottom)
	    (tell-named-sprite :enclosing-rectangle)
    (make-box (list (list left top) (list right bottom)))))

(defboxer-function bu:change-xy (xpos ypos)
  (tell-named-sprite :move-to (numberize xpos) (numberize ypos)))

;;; included for compatibility because I changed the name
(defboxer-function bu:single-touched-sprite ()
  (let ((turtle (tell-named-sprite :sprite-under)))
    (if (turtle? turtle)
	(boxify (port-to-internal (tell turtle :sprite-box)))
	(make-box nil))))

(defboxer-function bu:all-touched-sprites ()
  (let ((turtles (tell-named-sprite :all-sprites-in-contact))
	 sprites)
    (dolist (turtle turtles)
      (setq sprites (cons (port-to-internal (tell turtle :sprite-box))
			  sprites)))
    (make-box (list sprites))))

;(DEFBOXER-FUNCTION BU:COMPLEMENT (GRAPHICS-BOX)
;  (WHEN (GRAPHICS-BOX? GRAPHICS-BOX)
;    (TELL GRAPHICS-BOX :COMPLEMENT)
;    (REDISPLAY-BOX GRAPHICS-BOX)))
;
;(DEFBOXER-FUNCTION BU:COPY-CONTENTS (FROM-GBOX TO-GBOX)
;  (TELL TO-GBOX :FILL-FROM-GRAPHICS-BOX FROM-GBOX)
;  (REDISPLAY-BOX TO-GBOX))
;
;(DEFBOXER-FUNCTION BU:PLACE-CONTENTS-AT (FROM-GBOX TO-GBOX X Y)
;  (TELL TO-GBOX :PLACE-STAMP-WITH-CLIPPING FROM-GBOX X Y)
;  (REDISPLAY-BOX TO-GBOX))

;(DEFBOXER-FUNCTION BU:DESCRIBE (GRAPHICS-OBJECT)
;  (MAKE-BOX (TELL GRAPHICS-OBJECT :DESCRIPTION-LIST)))

