;;; -*- Mode:Common-Lisp; Package:ZWEI; Base:10; Fonts:(CPTFONT HL12B HL12I MEDFNB) -*-


(defun 4ARTICLE-HELP* ()
    
  (format t "~:|Article-Mode Commands:

<number>             Go to the numbered article.
<meta-b>             List summary buffer.
b                    Back up one page.
c                    Catch up in this newsgroup; i.e., mark all articles as read.
d                    Display half a page more.
f                    Forward a message through mail.
h,<help>             Help.
j                    Mark the article as read.  
k                    Mark as read all articles with the same subject as the current article.
m                    Mark the current article as still unread.
n,<space>,<return>   Scan forward for the next unread article.
N                    Go to the next article.
^n                   Scan forward for the next article with the same subject, and make ^n default.
o                    Other buffer (summary of unread articles, same as =)
c-o                  Other buffer (summary of read articles, same as _)
p, P                 Same as n, N only scan backwards.
<meta-p>             Post a message to a newsgroup.
q,<end>              Quit newsgroup.
r                    Reply through mail.
s, c-x c-s           Save to a file.
S                    Save to a ZMACS buffer.
u                    Unsubscribe to this newsgroup.
v                    Toggle article verbose mode. 
X                    Restart the current article, and decrypt as a rot13 message.
/pattern             Scan forward for article containing pattern in the subject.
/pattern/h           Scan forward for article containing pattern in the header.
/pattern/r           Scan read articles also.  /pattern/rh will scan all headers of all articles.
#                    Display the newsgroup and current article number.
-                    Go to the previously displayed article.
^                    Go to the first article.
$                    Go to the last article (actually, one past the last article).
=                    List subjects of unread articles.
_                    List subjects of all articles.
<mouse-r>            News menu.


<Press any key to continue>")
  )


(eval-when (load)
  (setq *article-comtab* (set-comtab 'article-comtab
				       '(#\1 com-article-number-1
					 #\2 com-article-number-2
					 #\3 com-article-number-3
					 #\4 com-article-number-4
					 #\5 com-article-number-5
					 #\6 com-article-number-6
					 #\7 com-article-number-7
					 #\8 com-article-number-8
					 #\9 com-article-number-9
					 #\0 com-article-number-0
					 #\m-b com-newsgroup-list-summary-buffers
					 #\b com-article-b
					 #\c com-article-c
					 #\d com-article-d
					 #\f com-article-f
					 #\h com-article-help
					 #\j com-article-j
					 #\k com-article-k
					 #\m com-article-m
					 #\n com-article-n
					 #\c-n com-article-control-n
					 #\N com-article-shift-n
					 #\o com-article-=          ;1; added command  dkm*
					 #\c-o com-article-_        ;1; added command  dkm*
					 #\p com-article-p
					 #\P com-article-shift-p
					 #\m-p com-article-meta-p
					 #\q com-article-q
					 #\r com-article-r
					 #\s com-article-s
					 #\S com-article-shift-s
					 #\u com-article-u
					 #\v com-article-v
					 #\X com-article-shift-x
					 #\# com-article-#
					 #\- com-article--
					 #\^ com-article-^
					 #\$ com-article-$
					 #\= com-article-=
					 #\_ com-article-_
					 #\/ com-article-/
					 #\End com-article-q
					 #\Help com-article-help
					 #\Mouse-r com-article-mouse-r
					 #\Space com-article-space
					 #\Return com-article-return
					 #\Rubout com-article-rubout
					 )))
  (set-comtab-indirection *article-comtab* *zmacs-comtab*)

  (setq *article-control-x-comtab*
	(set-comtab 'article-control-x-comtab
		    '(#\c-w com-article-s
		      #\c-s com-article-s
		      )))
  (set-comtab-indirection *article-control-x-comtab* *zmacs-control-x-comtab*)

  (set-comtab *article-comtab* (list #\c-x (make-extended-command *article-control-x-comtab*)))
  (set-comtab-indirection *article-comtab* *zmacs-comtab*)
  )


(defmajor 4COM-ARTICLE-MODE* article-mode "2Article-mode*"
	  "Major mode for Explorer news article mode." ()
  (setq *comtab* *article-comtab*)
  (set-mouse-documentation)
  (set-mode-line-list (article-mode-line)))


(defun 4REDISPLAY-ARTICLE-MODE-LINE* ()
  (set-mode-line-list (article-mode-line))
  (redisplay-mode-line))


(defun 4ARTICLE-MODE-LINE* ()
  `("ZMACS (" *mode-name-list* ")  " ,(article-prompt)))


(defun 4ARTICLE-PROMPT* ()
  (let ((newsgroup-component (get-current-newsgroup)))
    (cond
      ((send newsgroup-component :start-of-newsgroup-p)
       (string-append
	 (format nil "Start of newsgroup ~a" (send newsgroup-component :newsgroup-string))
	 (if (> (send newsgroup-component :unread-article-count) 0)
	     (format nil " (~d article~:p still unread)" (send newsgroup-component :unread-article-count))
	     "")
	 (format nil "--What next? [~a]" (format nil "~@[^N~*~]~a" *subject-search-mode-p* *npq*))))
      ((send newsgroup-component :end-of-newsgroup-p)
       (string-append
	 (format nil "End of newsgroup ~a" (send newsgroup-component :newsgroup-string))
	 (if (> (send newsgroup-component :unread-article-count) 0)
	     (format nil " (~d article~:p still unread)" (send newsgroup-component :unread-article-count))
	     "")
	 (format nil "--What next? [~a]" (format nil "~@[^N~*~]~a" *subject-search-mode-p* *npq*))))
      (t
       (format nil "Article ~a (of ~a)--what next? [~a]      ~a"
	       (send newsgroup-component :current-article-number)
	       (send newsgroup-component :high-article-number)
	       (format nil "~@[^N~*~]~a" *subject-search-mode-p* *npq*)
	       (if (article-read-p newsgroup-component) #\  #\*))))))


(defun 4END-OF-NEWSGROUP-DISPLAY* ()
  "2Display the article prompt into the current buffer.*"
  (let ((stream (open-editor-stream :window *window* :start :end)))
    (format stream "~%~a" (article-prompt))
    (move-bp (point) (interval-last-bp *interval*))
    (must-redisplay *window* dis-text)))


;1;;Ensure that the newsgroup assigned to the buffer is the same as the current working newsgroup, if not, control*
;1;;is returned to newsgroup mode.  This can occur when two or more ZMACS processes are created (by system-ctrl-e)*
;1;;and the user switches between the news processes.*
(defmacro 4IN-ARTICLE-MODE-CONTEXT* (&body body)
  `(progn
     (let ((newsgroup-component (get-current-newsgroup)))
       (cond
	 ((equal newsgroup-component (send *en* :newsgroup-component))
	  (condition-case (cond-obj)
	      (with-read-only-suppressed (*en*)
		(progn . ,body))
	    (sys:abort (en-close))))
	 (t
	  (com-article-q))))
     dis-none))


(defcom 4COM-ARTICLE-SELECTION*
	""
	()
  (with-read-only-suppressed (*en*)
    (let ((newsgroup-component (get-current-newsgroup)))
      (send *en* :set-major-mode 'article-mode)
      (delete-interval *en*)
      (make-buffer-current *en*)
      (send *en* :set-newsgroup-component newsgroup-component)
      (setf *subject-search-mode-p* *subject-search-mode*)
      (setf *article-number* "")
      (setf *verbose-article-number* nil)
      (cond
	((send newsgroup-component :start-or-end-of-newsgroup-p)
	 (clear-buffer *en*)
	 (end-of-newsgroup-display))
	(t
	 (unless (en-display-article-into-buffer *en* newsgroup-component)
	   (format *query-io* "~:|Article ~a (of ~a) is not available."
		   (send newsgroup-component :current-article-number)
		   (send newsgroup-component :high-article-number)))
	 (save-article-subject newsgroup-component)))
      (redisplay-article-mode-line)))
  dis-none)


(defcom 4COM-ARTICLE-B*
	""
	()
  (in-article-mode-context
    (let ((*next-screen-context-lines* *next-screen-context-lines-for-article*))
      (com-previous-screen))))


(defcom 4COM-ARTICLE-C*
	""
	()
  (in-article-mode-context
    (cond
      ((y-or-n-p "Do you really want to mark everything as read?")
       (send newsgroup-component :mark-all-articles t)
       (format *query-io* "~:|End of newsgroup ~a~%" (send newsgroup-component :newsgroup-string))
       (com-article-q))
      (t
       (format *query-io* "~:|")))))


(defcom 4COM-ARTICLE-D*
	""
	()
  (in-article-mode-context
    (cond
      ;1;;The end of the article is displayed on the screen. *
      ((zwei:window-last-bp-displayed-p *window*)
       (if *subject-search-mode-p*
	   (com-article-control-n)
	   (com-article-n)))
      (t
       (let ((*next-screen-context-lines* (truncate (window-n-plines *window*) 2)))
	 (com-next-screen))))))


(defcom 4COM-ARTICLE-F*
	""
	()
  (in-article-mode-context
    (setf *mail-newsgroup-component* newsgroup-component)
    (en-mail *default-forward-news-mail-template*)))


(defcom 4COM-ARTICLE-HELP*
	""
	()
  (in-article-mode-context
    (article-help)))


(defcom 4COM-ARTICLE-K*
	""
	()
  (in-article-mode-context
    (cond
      ((article-selected-p newsgroup-component)
       (format *query-io* "~:|Removing duplicate subjects...")
       (en-k newsgroup-component)
       (article-n newsgroup-component))
      (t
       (format *query-io* "~:|Cannot delete null subject.")
       (clear-buffer *en*)
       (redisplay-article-mode-line)))))


(defcom 4COM-ARTICLE-J*
	""
	()
  (in-article-mode-context
    (send newsgroup-component :mark-article t *mark-xref-articles-p*)
    (format *query-io* "~:|Article ~a marked as read." (send newsgroup-component :current-article-number))
    (redisplay-article-mode-line)))


(defcom 4COM-ARTICLE-M*
	""
	()
  (in-article-mode-context
    (send newsgroup-component :mark-article nil nil)
    (when *mark-xref-articles-p* (send newsgroup-component :mark-xref-articles t))
    (format *query-io* "~:|Article ~a marked as still unread." (send newsgroup-component :current-article-number))
    (redisplay-article-mode-line)))


(defcom 4COM-ARTICLE-N*
	""
	()
  (in-article-mode-context
    (setf *subject-search-mode-p* nil)
    (setf *article-subject* nil)
    (article-n newsgroup-component)))


(defun 4ARTICLE-N* (newsgroup-component)
  (cond
    ;1;;There are articles to read in this newsgroup.  Find the next article to read.*
    ((> (send newsgroup-component :unread-article-count) 0)
     (when (send newsgroup-component :end-of-newsgroup-p)
       (send newsgroup-component :set-current-article-number *start-index*))
     (article-n-or-p newsgroup-component t nil))
    ;1;;There are no more articles to read in this newsgroup.  Return to newsgroup mode.*
    (t
     (clear-buffer *en*)
     (get-next-newsgroup nil)
     (send *en* :set-major-mode 'newsgroup-mode)
     (newsgroup-prompt))))
      

(defun 4ARTICLE-N-OR-P* (newsgroup-component next mode &aux operation)
  "2Display the next (next = t) or previous (next = nil) read (mode = t) or unread (mode = nil) article.*"
  (if next
      (setf operation :get-next-article-number)
      (setf operation :get-previous-article-number))
  (cond
    ((send newsgroup-component operation mode)
     ;1;;Loop until we display an article or we reach the end of the newsgroup.*
     (loop with count = 0 and first = t
	   until (en-display-article-into-buffer *en* newsgroup-component)
	   finally (save-article-subject newsgroup-component)
	   finally (format *query-io* "~:|")
	   do
	   ;1;;We need to make sure if we can't read an article that we can access the newsgroup.  This is more of a*
	   ;1;;precaution then anything else.  We don't want to mark articles as read if we can't access the newsgroup.*
	   (when first
	     (setf first nil)
	     (unless (en-group-command newsgroup-component)
	       (format *query-io* "~:|Can't access the newsgroup ~a.  It is protected or unavailable at this time."
		       (send newsgroup-component :newsgroup-string))
	       (com-article-q)
	       (return)))
	    ;1;;We need to make sure we are not at the end of the newsgroup.  *
	   (unless (send newsgroup-component operation mode)
	     (clear-buffer *en*)
	     (end-of-newsgroup-display)
	     (redisplay-article-mode-line)
	     (return))
	   (send newsgroup-component :mark-article t nil)	;1Mark this article as read so we don't look at it again.*
	   ;1;;Unavailable articles are articles that do not exist on the news server but are still included in the low article/high*
	   ;1;;article range.*
	   (cond
	     ((zerop count)
	      (format *query-io* "Skipping unavailable article(s)"))
	     ((zerop (mod count 10))
	      (format *query-io* "...~d" count)))
	   (incf count)))
     ;1;;We are at the end of the newsgroup.*
    (t
     (clear-buffer *en*)
     (end-of-newsgroup-display)
     (redisplay-article-mode-line))))


(defcom 4COM-ARTICLE-CONTROL-N*
	""
	()
  (in-article-mode-context
    (article-control-n newsgroup-component)))


(defun 4ARTICLE-CONTROL-N* (newsgroup-component)
  (cond
    ((> (send newsgroup-component :unread-article-count) 0)
     (when (send newsgroup-component :end-of-newsgroup-p)
       (send newsgroup-component :set-current-article-number *start-index*))
     (let (ret)
       (format *query-io* "~:|Searching for article with the same subject.")
       (multiple-value-setq (ret *article-subject*) (en-ctrl-n newsgroup-component *article-subject*))
       (format *query-io* "~:|")
       (cond
	 (ret
	  (setf *subject-search-mode-p* t)
	  (en-display-article-into-buffer *en* newsgroup-component)
	  (redisplay-article-mode-line))
	 (t
	  (setf *subject-search-mode-p* nil)
	  (clear-buffer *en*)
	  (get-next-newsgroup nil)
	  (send *en* :set-major-mode 'newsgroup-mode)
	  (newsgroup-prompt)))))
    (t
     (setf *subject-search-mode-p* nil)
     (clear-buffer *en*)
     (get-next-newsgroup nil)
     (send *en* :set-major-mode 'newsgroup-mode)
     (newsgroup-prompt))))


(defcom 4COM-ARTICLE-SHIFT-N*
	""
	()
  (in-article-mode-context
    (setf *subject-search-mode-p* nil)
    (setf *article-subject* nil)
    (cond
      ((send newsgroup-component :end-of-newsgroup-p)
       (clear-buffer *en*)
       (end-of-newsgroup-display))
      (t
       (article-n-or-p newsgroup-component t t)))
    (redisplay-article-mode-line)))


(defcom 4COM-ARTICLE-P*
	""
	()
  (in-article-mode-context
    (setf *subject-search-mode-p* nil)
    (setf *article-subject* nil)
    (article-n-or-p newsgroup-component nil nil)))


(defcom 4COM-ARTICLE-SHIFT-P*
	""
	()
  (in-article-mode-context
    (setf *subject-search-mode-p* nil)
    (setf *article-subject* nil)
    (article-n-or-p newsgroup-component nil t)
    (redisplay-article-mode-line)))


(defcom 4COM-ARTICLE-META-P*
	""
	()
  (in-article-mode-context
    (when *postnews-warning-message-p*
      (when (w:mouse-confirm (format nil "~a" *postnews-warning-message*))
	(setf *mail-newsgroup-component* newsgroup-component)
	(en-postnews *default-post-news-mail-template*)))))


(defcom 4COM-ARTICLE-Q*
	""
	()
  (clear-buffer *en*)
  (get-next-newsgroup nil)
  (send *en* :set-major-mode 'newsgroup-mode)
  (newsgroup-prompt)
  dis-none)


(defcom 4COM-ARTICLE-R*
	""
	()
  (in-article-mode-context
    (setf *mail-newsgroup-component* newsgroup-component)
    (en-mail *default-reply-news-mail-template*)))


(defcom 4COM-ARTICLE-RETURN*
	""
	()
  ;1;The last command character is altered to handle the problem when auto-fill-mode is turned on in this buffer.  Even*
  ;1;though auto-fill-mode is not used it can be turned on.  The auto-fill-mode hook will activate on a newline character*
  ;1;(which is how this function is called) and cause Explorer news to be thrown into the debugger.  This probably isn't*
  ;1;the best way to handle the problem.*
  (setf *last-command-char* nil)	     
  (in-article-mode-context
    (cond
      ((not (zerop (length *article-number*)))
       (send newsgroup-component :update-current-article-number (parse-number *article-number*))
       (send newsgroup-component :mark-article t *mark-xref-articles-p*)
       (setf *article-number* "")
       (cond
	 ((en-display-article-into-buffer *en* newsgroup-component)
	  (save-article-subject newsgroup-component))
	 (t
	  (save-article-subject newsgroup-component)
	  (format *query-io* "~:|Article ~a (of ~a) is not available."	
		  (send newsgroup-component :current-article-number)
		  (send newsgroup-component :high-article-number))))
       (redisplay-article-mode-line))
      (t
       nil))))


(defcom 4COM-ARTICLE-RUBOUT*
	""
	()
  (in-article-mode-context
    (when (> (length *article-number*) 0)
      (setf *article-number* (subseq *article-number* 0 (1- (length *article-number*))))
      (format *query-io* "~:|~d" *article-number*))))


(defcom 4COM-ARTICLE-S*
	""
	()
  (in-article-mode-context
    (cond
      ((send newsgroup-component :start-or-end-of-newsgroup-p))
      (t
       (let* ((*mini-buffer-dont-record* t)
	      (pathname (read-defaulted-pathname (format nil "Save article ~d into filename"
							 (send newsgroup-component :current-article-number))
						 (default-save-article-pathname)))
	      append-p)
	 (setf *saved-pathname* pathname)
	 (condition-case (cond-obj)
	     (progn
	      (setf append-p (fs:probe-file pathname))
	      (with-open-file (stream pathname :direction :output :if-exists :append :if-does-not-exist :create
				      :error t)
		(format *query-io* "~:[Saving~;Appending~] article into ~a..." append-p (send stream :pathname))
		(format stream "From ~a  "
			(if (null mail:*user-mail-address*) "unknown" mail:*user-mail-address*))
		(multiple-value-bind (sec min hour date month year day)
		    (time:decode-universal-time (get-universal-time))
		  (format stream "~A ~A ~2D ~2,48D:~2,48D:~2,48D ~D"
			  (time:day-of-the-week-string day :short)
			  (time:month-string month :short)
			  date hour min sec year))
		(en-display-article stream newsgroup-component t)
		(format stream "~2%")
		(format *query-io* "Done")))
	   (error (barf "Can't save article.  ~a." cond-obj))))))))


(defcom 4COM-ARTICLE-SHIFT-S*
	""
	()
  (in-article-mode-context
    (cond
      ((send newsgroup-component :start-or-end-of-newsgroup-p))
      (t
       (let ((buffername (prompt-and-read :string-or-nil "Save into Buffer:  ")))
	 (when (and buffername (write-to-buffer-p buffername))
	   (zwei:with-editor-stream (stream :buffer-name buffername :create-p t)
	     (format *query-io* "Saving article into ~a..." buffername)
	     (en-display-article stream newsgroup-component)
	     (format *query-io* "Done"))))))))


(defcom 4COM-ARTICLE-SPACE*
	""
	()
  (in-article-mode-context
    (cond
      ;1;;The end of the article is displayed on the screen. *
      ((zwei:window-last-bp-displayed-p *window*)
       (if *subject-search-mode-p*
	   (com-article-control-n)
	   (com-article-n)))
      (t
       (let ((*next-screen-context-lines* *next-screen-context-lines-for-article*))
	 (com-next-screen))))))


(defcom 4COM-ARTICLE-U*
	""
	()
  (in-article-mode-context
    (subscribe-newsgroup newsgroup-component nil)
    (format *query-io* "~:|Unsubscribed to newsgroup ~a" (send newsgroup-component :newsgroup-string))
    (com-article-q)))


(defcom 4COM-ARTICLE-V*
	""
	()
  (in-article-mode-context
    (let (mode)
      (unless (send newsgroup-component :start-or-end-of-newsgroup-p)
	(cond
	  ((equal *verbose-article-number* (send newsgroup-component :current-article-number))
	   (setf *verbose-article-number* nil)
	   (setf mode nil))
	  (t
	   (setf *verbose-article-number* (send newsgroup-component :current-article-number))
	   (setf mode t)))
	(unless (en-display-article-into-buffer *en* newsgroup-component mode)
	  (format *query-io* "~:|Article ~a (of ~a) is not available."
		  (send newsgroup-component :current-article-number)
		  (send newsgroup-component :high-article-number))))
      (redisplay-article-mode-line))))


(defcom 4COM-ARTICLE-SHIFT-X*
	""
	()
  (in-article-mode-context
    (cond
      ((send newsgroup-component :start-or-end-of-newsgroup-p)
       (clear-buffer *en*)
       (end-of-newsgroup-display))
      (t
       (en-display-article-into-buffer *en* newsgroup-component nil t)))))


(defun 4ROTL-LINE* (line)
  (loop for i from 0 to (1- (length line))
	with index do
	(when (setf index (position (aref line i) (car *rotl*)))
	  (setf (aref line i) (aref (cdr *rotl*) index)))
	finally (return line)))


(defcom 4COM-ARTICLE-#*
	""
	()
  (in-article-mode-context
    (format *query-io* "~:|Newsgroup:  ~a.  Article number = ~a" (send newsgroup-component :newsgroup-string)
	    (cond
	      ((send newsgroup-component :start-of-newsgroup-p)
	       "<beginning>")
	      ((send newsgroup-component :end-of-newsgroup-p)
	       "<end>")
	      (t
	       (send newsgroup-component :current-article-number))))))


(defcom 4COM-ARTICLE--*
	""
	()
  (in-article-mode-context
    (let ((temp (send newsgroup-component :current-article-number)))
      (send newsgroup-component :set-current-article-number (send newsgroup-component :previous-article-number))
      (send newsgroup-component :set-previous-article-number temp)
      (cond
	((send newsgroup-component :start-or-end-of-newsgroup-p)
	 (clear-buffer *en*)
	 (end-of-newsgroup-display))
	(t
	 (en-display-article-into-buffer *en*  newsgroup-component))))
    (redisplay-article-mode-line)))


(defcom 4COM-ARTICLE-^*
	""
	()
  (in-article-mode-context
    (send newsgroup-component :initialize-current-article-number)
    (send newsgroup-component :get-next-article-number t)
    (unless (en-display-article-into-buffer *en* newsgroup-component)
      (format *query-io* "~:|Article ~a (of ~a) is not available."
	      (send newsgroup-component :current-article-number)
	      (send newsgroup-component :high-article-number)))))


(defcom 4COM-ARTICLE-$*
	""
	()
  (in-article-mode-context
    (send newsgroup-component :set-previous-article-number (send newsgroup-component :current-article-number))
    (send newsgroup-component :set-current-article-number *end-index*)
    (clear-buffer *en*)
    (end-of-newsgroup-display)
    (redisplay-article-mode-line)))


(defcom 4COM-ARTICLE-=*
	""
	()
  (in-article-mode-context
    (summary-command nil)))


(defcom 4COM-ARTICLE-_*
	""
	()
  (in-article-mode-context
    (summary-command t)))


(defcom 4COM-ARTICLE-/*
	""
	()
  (in-article-mode-context
    (let ((string (or (prompt-and-read :string-or-nil (format nil "Search string (~a):  " */-string*)) */-string*)))
      (cond
	((not (zerop (length string)))
	 (setf */-string* string)
	 (format *query-io* "~:|Searching for ~a" */-string*)
	 (cond
	   ((en-/ newsgroup-component string)
	    (en-display-article-into-buffer *en* newsgroup-component)
	    (save-article-subject newsgroup-component)
	    (format *query-io* "~:|"))
	   (t
	    (format *query-io* "~:|Not Found.~%"))))
	(t
	 (format *query-io* "~:|"))))))


(defcom 4COM-ARTICLE-MOUSE-R*
	""
	()
  (in-article-mode-context
    (case (en-mouse-r)
      ('t
       (com-article-q))
      (':abort)
      (otherwise
       ;1;;Make sure we are able to access the newsgroup.*
       (unless (en-group-command newsgroup-component)
	 (format *query-io* "~:|Can't access the newsgroup ~a.  It is protected or unavailable at this time.~%"
		 (send newsgroup-component :newsgroup-string))
	 (com-article-q))))))


(defprop 4COM-ARTICLE-MOUSE-R* "News Menu" :mouse-short-documentation)


(defcom 4COM-ARTICLE-NUMBER-0*
	""
	()
  (in-article-mode-context
    (setf *article-number* (string-append *article-number* "0"))
    (format *query-io* "~:|~d" *article-number*)))


(defcom 4COM-ARTICLE-NUMBER-1*
	""
	()
  (in-article-mode-context
    (setf *article-number* (string-append *article-number* "1"))
    (format *query-io* "~:|~d" *article-number*)))


(defcom 4COM-ARTICLE-NUMBER-2*
	""
	()
  (in-article-mode-context
    (setf *article-number* (string-append *article-number* "2"))
    (format *query-io* "~:|~d" *article-number*)))


(defcom 4COM-ARTICLE-NUMBER-3*
	""
	()
  (in-article-mode-context
    (setf *article-number* (string-append *article-number* "3"))
    (format *query-io* "~:|~d" *article-number*)))


(defcom 4COM-ARTICLE-NUMBER-4*
	""
	()
  (in-article-mode-context
    (setf *article-number* (string-append *article-number* "4"))
    (format *query-io* "~:|~d" *article-number*)))



(defcom 4COM-ARTICLE-NUMBER-5*
	""
	()
  (in-article-mode-context
    (setf *article-number* (string-append *article-number* "5"))
    (format *query-io* "~:|~d" *article-number*)))


(defcom 4COM-ARTICLE-NUMBER-6*
	""
	()
  (in-article-mode-context
    (setf *article-number* (string-append *article-number* "6"))
    (format *query-io* "~:|~d" *article-number*)))


(defcom 4COM-ARTICLE-NUMBER-7*
	""
	()
  (in-article-mode-context
    (setf *article-number* (string-append *article-number* "7"))
    (format *query-io* "~:|~d" *article-number*)))


(defcom 4COM-ARTICLE-NUMBER-8*
	""
	()
  (in-article-mode-context
    (setf *article-number* (string-append *article-number* "8"))
    (format *query-io* "~:|~d" *article-number*)))


(defcom 4COM-ARTICLE-NUMBER-9*
	""
	()
  (in-article-mode-context
    (setf *article-number* (string-append *article-number* "9"))
    (format *query-io* "~:|~d" *article-number*)))
