/* TryRoot.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 *
 * $Header: /usr/src/cmd/lq-text/src/test/RCS/TryRoot.c,v 1.1 90/08/09 19:17:45 lee Rel1-10 $
 *
 * $Log:	TryRoot.c,v $
 * Revision 1.1  90/08/09  19:17:45  lee
 * Initial revision
 * 
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include "fileinfo.h" /* this is needed by wordinfo.h */
#include "wordinfo.h"
#include "wordrules.h" /* for the flags, etc */

char *progname = "TryRoot";

/** Unix/C Library Functions: **/
extern int strlen();
#ifndef tolower
extern int tolower();
#endif

/** lqtext library functions: **/
extern char *WordRoot();
extern void SetDefaults();

/** **/

int
main(argc, argv)
    int argc;
    char *argv[];
{
    t_WordInfo W;

    SetDefaults(argc, argv);

    while (--argc) {
	extern char *UnFlag();
	extern char *TryRoot();

	char *s;
	W.Word = *++argv;
	W.Length = strlen(*argv);
	W.WordPlace.Flags = 0;

	printf("%s --> ", *argv);
	if (isupper(W.Word[0])) {
	    W.WordPlace.Flags |= WPF_UPPERCASE;
	}
	for (s = W.Word; *s; s++) {
	    *s = tolower(*s);
	}
	s = WordRoot(&W);
	printf("%s [%d] -->", s, W.WordPlace.Flags);
	printf("%s", UnFlag(&W, W.WordPlace.Flags));
	printf(" [%d]\n", W.WordPlace.Flags);
    }
    return 0;
}
