/* NumberTest.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/*
 * This version of the test program prints messages even when things are OK.
 *
 * $Id$
 *
 */

#include "globals.h" /* defines and declarations for database filenames */
#include "error.h"

#include <stdio.h>
#include "numbers.h"

char *progname = "NumberTest";
int AsciiTrace = 0;

/** Unix system calls: **/
extern void exit();

/** Unix Library Functions: **/
extern int atoi();

/** liblqtext Library Functions: **/

/** Routines in this file which need declaring: **/
static void Test();

/** **/

static char *TestFile = "/tmp/trydbm";
static int ErrorCount = 0;

int
main(ac, av)
    int ac;
    char *av[];
{
    int Level;
    int i;
    char dbuf[30];

    if (ac > 2 || (ac == 2 && !strcmp(av[1], "-x"))) {
	fprintf(stderr, "Usage: %s [level, default is 1]\n", av[0]);
	exit(1);
    } else if (ac == 2) {
	Level = atoi(av[1]);
	if (Level <= 0) {
	    Error(E_FATAL, "optional argument must be a positive number.");
	}
    } else {
	Level = 1;
    }

    fprintf(stderr, "%s: ** Starting to test Compressed Number package\n",
	progname
    );

    do {
	Test(Level);
    } while (--Level);

    if (ErrorCount) {
	Error(E_FATAL,
	    "**** FAIL **** %d failures",
	    ErrorCount
	);
    }

    fprintf(stderr, "%s: ** Test complete - PASS\n", progname);
    exit(0);
}

static unsigned char Buffer[10];

static
ClearBuffer(Byte)
    unsigned char Byte;
{
    register unsigned char *p;

    for (p = Buffer; p - Buffer < sizeof(Buffer); p++) {
	*p = Byte;
    }
}

OneTest(i, Level, N, pad)
    int i;
    int Level;
    unsigned long N;
    unsigned char pad;
{
    unsigned long L;
    int Length;
    unsigned char *p;

    ClearBuffer(pad);
    p = Buffer;
    sWriteNumber(&p, N);
    Length = p -Buffer;
    p = Buffer;
    L = sReadNumber(&p);
    if (L != N) {
	Error(E_WARN,
	    "**** FAIL -- 2^%d+%d: wrote %ld read %ld",
	    i,
	    Level,
	    L,
	    N
	);
	++ErrorCount;
    }
    if (p - Buffer != Length) {
	Error(E_WARN,
	    "**** FAIL -- 2^%d+%d: wrote %ld bytes, read %ld bytes",
	    i,
	    Level,
	    Length,
	    p - Buffer
	);
	++ErrorCount;
    }
    if ((unsigned char)*p != (unsigned char) pad) {
	Error(E_WARN,
	    "**** FAIL -- 2^%d+%d: sentinel changed from 0%o to 0%o",
	    i,
	    Level,
	    pad,
	    *p
	);
	++ErrorCount;
    }
}

static void
Test(Level)
    int Level;
{
    int i;

    for (i = 0; i < 32; i++) {
	unsigned long N = (1 << i) + Level;

	OneTest(i, Level, N, (unsigned char) 0);
	OneTest(i, Level, N, (unsigned char) 0xff);
    }
}

