/* malloc.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/*
 * malloc.c -- wrapper routines for free/malloc, that can do checking and
 * print errors.
 *
 * $Id: malloc.c,v 1.10 92/08/24 00:27:50 lee Exp $
 */

#include "globals.h"
#include "error.h"

#include <malloc.h>
#include <stdio.h>
#include <ctype.h>
#include "emalloc.h"

extern char *progname;

extern void exit();

int _LiamIsInCurses = 0;
    /* TODO FIXME: This should be in error.c */

#undef malloc

INLINE char *
_emalloc(nbytes
#ifdef MALLOCTRACE
, FileName, Line
#endif
)
    unsigned nbytes;
#ifdef MALLOCTRACE
    char *FileName;
    int Line;
#endif
{
    char *Result;

    if ((Result = malloc(nbytes)) == (char *) 0) {
#ifdef MALLOCTRACE
	Error(E_FATAL|E_MEMORY, "%s: %d: emalloc(%u) failed.",
					FileName, Line, nbytes);
#else
	Error(E_FATAL|E_MEMORY, "emalloc request for %u bytes denied", nbytes);
#endif
    }

#ifdef MALLOCTRACE
    (void) fprintf(stderr, "malloc %u > 0x%x %s %d\n", nbytes, Result, FileName, Line);
#endif
    return Result;
}

#undef calloc

INLINE char *
_ecalloc(Number, Size
#ifdef MALLOCTRACE
			, FileName, Line
#endif
)
    unsigned Number;
    unsigned Size;
#ifdef MALLOCTRACE
    char *FileName;
    int Line;
#endif
{
    char *Result;

    if ((long) Number <= 0) {
#ifdef MALLOCTRACE
	fprintf(stderr, "%s: %s: %d: warning: ecalloc(%u x %u) strange!\n",
			progname, FileName, Line, Number, Size);
#else
	fprintf(stderr, "%s: warning: ecalloc(%u x %u) seemsa little odd.\n",
			progname, Number, Size);
#endif
    }
    if ((Result = calloc(Number, Size)) == (char *) 0) {
#ifdef MALLOCTRACE
	fprintf(stderr, "%s: %s: %d: ecalloc(%u x %u) failed.\n",
			progname, FileName, Line, Number, Size);
	exit(1);
#else
	Error(E_FATAL|E_MEMORY, "ecalloc request for (%u x %u) failed",
			Number, Size);
#endif
    }

    return Result;
}

#undef realloc

INLINE char *
_erealloc(OldString, NewSize
#ifdef MALLOCTRACE
				, FileName, Line
#endif
)
    char *OldString;
    unsigned NewSize;
#ifdef MALLOCTRACE
    char *FileName;
    int Line;
#endif
{
    char *Result;

    if ((Result = realloc(OldString, NewSize)) == (char *) 0) {
#ifdef MALLOCTRACE
	fprintf(stderr, "%s: %s: %d: erealloc(0x%x, %u) failed.\n",
			    progname, FileName, Line, OldString, NewSize);
	exit(1);
#else
	Error(E_FATAL|E_MEMORY, "erealloc to change 0x%x to %u bytes failed",
			    OldString, NewSize);
#endif
    }

#ifdef MALLOCTRACE
    (void) fprintf(stderr, "realloc 0x%x %u > 0x%x %s %d\n", OldString, NewSize, Result, FileName, Line);
#endif
    return Result;
}

#undef free

INLINE void
_efree(String
#ifdef MALLOCTRACE
		, FileName, Line
#endif
)
    char *String;
#ifdef MALLOCTRACE
    char *FileName;
    int Line;
#endif
{
    if (!String) {
#ifdef MALLOCTRACE
	(void) fprintf(stderr, "%s: %s: %d: Warning: free(0) ignored\n",
			progname, FileName, Line);
#else
	Error(E_WARN|E_MEMORY, "efree: call to free(0) ignored");
#endif
	return;
    }
#ifdef MALLOCTRACE
    (void) fprintf(stderr, "free 0x%x\n", String);
#endif

    (void) free(String);
}
