/* SetWID.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* SetWID.c -- get/set the largest current word number
 * 
 * $Id: SetWID.c,v 1.3 92/04/18 19:23:01 lee Exp $
 */

#include "globals.h" /* defines and declarations for database filenames */
#include "error.h"

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>

#include "fileinfo.h"
#include "wordinfo.h"
#include "blkheader.h"

/** declarations: **/
/** Unix system calls that need to be declared: **/

/** Unix Library Calls that need to be declared: **/

/** lq-text calls that need to be declared: **/
extern unsigned char *ReadBlock();
extern void WriteBlock(), FlushCache();
extern t_WID GetMaxWID();

#ifdef ASCIITRACE
 extern int AsciiTrace;
#endif
/** **/

extern t_WID LastNextWIDVal;

#undef GetNextWID

t_WID GetNextWID();

t_WID
SpoofGetNextWID(WriteCurrent)
{
    static int SinceLastUpdate = 0;

    if (WriteCurrent) {
	SinceLastUpdate = 0;
	return GetNextWID(WriteCurrent);
    }

    /* Call the real function sometimes, so that the database does
     * get updated in case of a crash or for other users.
     */
    if (++SinceLastUpdate > 10000) {
	SinceLastUpdate = 0;
	(void) GetNextWID(1);
	/* GetNextWID(1) sets LastNextWIDVal but doesn't increment it;
	 * This is ugly and has to be made cleaner... TODO FIXME
	 */
    }

    if (LastNextWIDVal == (t_WID) 0) {
	LastNextWIDVal = GetMaxWID();
	SinceLastUpdate = 0;
    }
    ++LastNextWIDVal;
    return LastNextWIDVal;
}

void
WriteCurrentMaxWID()
{
    (void) GetNextWID(1);
}

t_WID
GetNextWID(WriteCurrent)
    int WriteCurrent; /* simply write the current MaxWID if true */
{
    t_WID Result = 0;
    unsigned char *p;
    t_BlockHeader *BH;

    /** Alter the file, so other programs can see the new words...
     **/

    p = ReadBlock(0L);

    Result = (t_WID) p[9]; /* most significant byte */
    Result <<= 8; Result |= (t_WID) p[10];
    Result <<=8; Result |= (t_WID) p[11];
    Result <<=8; Result |= (t_WID) p[12];

    /* if WriteCurrent is set, we should not increment anything */
    if (!WriteCurrent) {
	++LastNextWIDVal;
	++Result;
    }

    /* but use the biggest */
    if (LastNextWIDVal > Result) {
	Result = LastNextWIDVal;
    } else {
	LastNextWIDVal = Result;
    }

    {
	t_WID tmp = Result;

	p[12] = (tmp & 0xff); /* least significant byte */
	tmp >>= 8; p[11] = (tmp & 0xff);
	tmp >>= 8; p[10] = (tmp & 0xff);
	tmp >>= 8; p[ 9] = (tmp & 0xff);
    }

    BH = (t_BlockHeader *) p;
    BH->NumberOfBlocks = 1;
    WriteBlock(0L, p, 1);

    if (WriteCurrent) {
	/* TODO FIXME implement this more efficiently! */
	FlushCache(0); /* write out entire block cache */
#ifdef ASCIITRACE
	if (AsciiTrace > 2) {
	    fprintf(stderr, "%s: wrote max wid %ld\n", progname, Result);
	}
#endif
    }

#ifdef ASCIITRACE
    if (AsciiTrace > 6) {
	fprintf(stderr, "max wid now %ld\n", Result);
    }
#endif

    return Result;
}

