/* wordinfo.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/*
 * $Id: wordinfo.h,v 1.5 92/08/24 00:27:00 lee Exp $
 */

typedef unsigned long t_WID;

#ifndef PBLOCK_H
# include "pblock.h"
#endif

#ifndef WIDBLOCKSIZE
#define WIDBLOCKSIZE 32
#endif

extern char *WidIndexFile; /* Default.c */

/* this is a hack for speed: */
#define GetNextWID SpoofGetNextWID

/** A t_WordInfo describes a single word, in terms of
 ** where it came from
 ** how to find its database entries
 ** how to find the in-core database entries (a copy of the above)
 **/

/* There would be a performance benefit if this struct was smaller.
 * It was foolish of me to use WordInfo for so many different things in
 * addfile, and now I pay the price.
 * Addfile may end up calling malloc for 10,000 of these things...
 *
 * There should be:
 * t_WordPlace (exists, pblock.h)
 *	for recording a specific occurrence of a given word in a given file
 * t_WordInfo (definition follows... look down...)
 *	for recording information about a WID's entry in the database
 * t_pblock (exists, see pblock.h)
 *	for containing the list of WordPlaces found in the database for a
 *	given word, or for putting them there.  Uses arrays rather than
 *	lists to squeeze a few extra milliseconds.  Some hope :-( :-)
 *
 * All of the entries marked with a leading comment (below) should
 * be elsewhere (and some of them were, in the Grand Design!).
 *
 */
typedef struct s_WordInfo {
    char *Word;
    t_WID WID; /* My Word Identifier */
    unsigned long NumberOfWordPlaces; /* total */
    t_FID FID; /* where we got it from */
    unsigned long Offset; /* word entry position in the data base */
    char *DataBlock; /* for writing me out to the index */
    char *WordPlaceStart;
    t_WordPlace *WordPlaces; /* first few pairs */
    t_WordPlace WordPlace; /* For addfile -- this is due to go!!!! */
    /* shorts are at the end to obviate alignment padding... */
    unsigned long WordPlacesInHere;
    unsigned char Length; /* Word length; reduce the need for strlen */
    unsigned char Flags;
} t_WordInfo;

