# include <stdio.h>			/* wheel.c (rev3.7) */
# include <ctype.h>

int nomap = 0;		/* toggle to not map upper to lower case */
int notch = 2;		/* number of words rolling around wheel */

main(argc, argv)	/* print overlapping word clusters in text */
int argc;
char *argv[];
{
	FILE *fp, *fopen();
	int i;

	if (argc == 1)
	{
		puts("Usage: wheel [+n -m -dF -] filename(s)\t\t(rev3.7)");
		puts("+n: print clusters of n words (default 2)");
		puts("-m: do not map upper case to lower case");
		puts("-d: define punctuation set according to file F");
		puts("- : read standard input instead of files");
		exit(1);
	}
	for (i = 1; i < argc; i++)
	{
		if (*argv[i] == '-')
			getflag(argv[i]);
		else if (*argv[i] == '+')
		{
			notch = atoi(argv[i]+1);
			if (notch > 20)
			{
				fprintf(stderr,
				"Clusters must be smaller than 20.\n");
				exit(1);
			}
		}
		else if ((fp = fopen(argv[i], "r")) != NULL)
		{
			roll(fp);
			fclose(fp);
		}
		else  /* cannot open file */
		{
			fprintf(stderr,
			"Wheel cannot access the file: %s\n", argv[i]);
			continue;
		}
	}
	exit(0);
}

getflag(f)		/* parses command line to set options */
char *f;
{
	char *pfile;

	f++;
	switch(*f++)
	{
		case 'm':
			nomap = 1;
			break;
		case 'd':
			pfile = f;
			getpunct(pfile);
			break;
		case NULL:
			roll(stdin);
			break;
		default:
			fprintf(stderr,
			"Invalid wheel flag: -%s\n", --f);
			exit(1);
			break;
	}
}

char punctuation[BUFSIZ] = ",.;:-?!\"()[]{}" ;

getpunct(pfile)		/* read user's punctuation from pfile */
char *pfile;
{
	FILE *pfp, *fopen();
	char s[BUFSIZ], *strcpy();

	if ((pfp = fopen(pfile, "r")) == NULL)
	{
		fprintf(stderr,
		"Wheel cannot access Punctfile: %s\n", pfile);
		exit(1);
	}
	else
		while (fgets(s, BUFSIZ, pfp))
			strcpy(punctuation, s);
}

roll(fp)		/* roll word wheel through text */
FILE *fp;
{
	char word[BUFSIZ], wheel[20][BUFSIZ];
	int i;

	for (i = 0; i < 20; i++)
		*wheel[i] = NULL;
	while (getword(word, fp))
	{
		for (i = 0; i < notch-1; i++)
			strcpy(wheel[i], wheel[i+1]);
		strcpy(wheel[notch-1], word);

		if (*wheel[0] == NULL)
			continue;
		for (i = 0; i < notch; i++)
		{
			if (i != 0)
				putchar(' ');
			fputs(wheel[i], stdout);
		}
		putchar('\n');
	}
}

getword(word, fp)	/* drives program through text word by word */
char word[];
FILE *fp;
{
	while ((*word = getc(fp)) && isskip(*word) && *word != EOF)
		;
	if (*word == EOF)
		return(0);
	if (!nomap && isupper(*word))
		*word = tolower(*word);

	while ((*++word = getc(fp)) && !isskip(*word) && *word != EOF)
	{
		if (!nomap && isupper(*word))
			*word = tolower(*word);
	}
	*word = NULL;
	return(1);
}

isskip(c)		/* function to evaluate punctuation */
char c;
{
	char *ptr;

	if (isspace(c))
		return(1);
	for (ptr = punctuation; *ptr != c && *ptr != NULL; ptr++)
		;
	if (*ptr == NULL)
		return(0);
	else
		return(1);
}
