# include <stdio.h>			/* tosel.c (rev3.7) */

main(argc, argv)	/* convert English for IBM terminal */
int argc;
char *argv[];
{
	FILE *fp, *fopen();

	if (argc == 1)
		convert(stdin);
	else
	{
		while (--argc > 0)
			if ((fp = fopen(*++argv, "r")) == NULL)
			{
				fprintf(stderr,
				"Tosel cannot access the file: %s\n",
				*argv);
				continue;
			}
			else
			{
				convert(fp);
				fclose(fp);
			}
		exit(0);
	}
}

convert(fp)		/* Unix ASCII to type-ball EBCDIC */
FILE *fp;
{
	char c;

	while ((c = getc(fp)) != EOF)
		switch (c)
		{
		case 'a': putchar(c = 'p'); break;
		case 'b': putchar(c = ','); break;
		case 'c': putchar(c = 'x'); break;
		case 'd': putchar(c = 'v'); break;
		case 'e': putchar(c = 'u'); break;
		case 'f': putchar(c = 'c'); break;
		case 'g': putchar(c = 'a'); break;
		case 'h': putchar(c = 'z'); break;
		case 'i': putchar(c = 'o'); break;
		case 'j': putchar(c = '&'); break;
		case 'k': putchar(c = 'w'); break;
		case 'l': putchar(c = 'y'); break;
		case 'm': putchar(c = 'j'); break;
		case 'n': putchar(c = 's'); break;
		case 'o': putchar(c = 'q'); break;
		case 'p': putchar(c = 'd'); break;
		case 'q': putchar(c = 'f'); break;
		case 'r': putchar(c = 'n'); break;
		case 's': putchar(c = 'r'); break;
		case 't': putchar(c = '@'); break;
		case 'u': putchar(c = 't'); break;
		case 'v': putchar(c = 'l'); break;
		case 'w': putchar(c = '$'); break;
		case 'x': putchar(c = '/'); break;
		case 'y': putchar(c = 'i'); break;
		case 'z': putchar(c = '0'); break;
		case '.': putchar(c = 'k'); break;
		case ',': putchar(c = 'g'); break;
		case ';': putchar(c = 'e'); break;
		case ':': putchar(c = 'E'); break;
		case '-': putchar(c = '.'); break;
		case '!': putchar(c = '='); break;	
		case '?': putchar(c = 'H'); break;
		case '/': putchar(c = 'h'); break;
		case '"': putchar(c = 'M'); break;
		case '\'': putchar(c = 'm'); break;
		case '(': putchar(c = '"'); break;
		case ')': putchar(c = '('); break;
		case '_': putchar(c = '~'); break;
		case '%': putchar(c = ':'); break;
		case '&': putchar(c = '%'); break;
		case '$': putchar(c = '*'); break;
		case '=': putchar(c = 'b'); break;
		case '+': putchar(c = 'B'); break;
		case '*': putchar(c = '>'); break;
		case '@': putchar(c = '<'); break;
		case '#': putchar(c = ';'); break;
		case '0': putchar(c = '9'); break;
		case '4': putchar(c = '8'); break;
		case '5': putchar(c = '4'); break;
		case '7': putchar(c = '5'); break;
		case '8': putchar(c = '7'); break;
		case '9': putchar(c = '#'); break;
		case 'A': putchar(c = 'P'); break;
		case 'B': putchar(c = '|'); break;
		case 'C': putchar(c = 'X'); break;
		case 'D': putchar(c = 'V'); break;
		case 'E': putchar(c = 'U'); break;
		case 'F': putchar(c = 'C'); break;
		case 'G': putchar(c = 'A'); break;
		case 'H': putchar(c = 'Z'); break;
		case 'I': putchar(c = 'O'); break;
		case 'J': putchar(c = '+'); break;
		case 'K': putchar(c = 'W'); break;
		case 'L': putchar(c = 'Y'); break;
		case 'M': putchar(c = 'J'); break;
		case 'N': putchar(c = 'S'); break;
		case 'O': putchar(c = 'Q'); break;
		case 'P': putchar(c = 'D'); break;
		case 'Q': putchar(c = 'F'); break;
		case 'R': putchar(c = 'N'); break;
		case 'S': putchar(c = 'R'); break;
		case 'T': putchar(c = '\\'); break;
		case 'U': putchar(c = 'T'); break;
		case 'V': putchar(c = 'L'); break;
		case 'W': putchar(c = '!'); break;
		case 'X': putchar(c = '?'); break;
		case 'Y': putchar(c = 'I'); break;
		case 'Z': putchar(c = ')'); break;
		case '[': putchar(c = '"'); break; /* prints ( */
		case '{': putchar(c = '"'); break;
		case ']': putchar(c = '('); break; /* prints ) */
		case '}': putchar(c = '('); break;
		case '`': putchar(c = 'm'); break;
		default: putchar(c); break;
		}
}
