# include <stdio.h>			/* tolpr.c (rev3.7) */
# include <ctype.h>

int spacing = 1;	/* spacing factor (2 = doublespace) */
char hdr[512];		/* page header for optional title */
int shift = 1;		/* toggle shift over one tab stop */

main(argc, argv)	/* send 8.5 inch wide output to lpr */
int argc;
char *argv[];
{
	FILE *fp, *fopen();
	int i, files = 0;

	for (i = 1; i < argc; i++)
	{
		if (*argv[i] == '-')
		{
			if (isdigit(argv[i][1]))
				spacing = atoi(argv[i]+1);
			else if (argv[i][1] == 'h')
			{
				strcpy(hdr, argv[++i]);
				strcat(hdr, "  ");
			}
			else if (argv[i][1] == 's')
				shift = 0;
			else {
				fprintf(stderr, "Invalid tolpr flag: %s\n",
					argv[i]);
				exit(1);
			}
		}
		else if ((fp = fopen(argv[i], "r")) != NULL)
		{
			files = 1;
			tolpr(fp);
			fclose(fp);
		}
		else  /* cannot open file */
		{
			fprintf(stderr,
			"Tolpr cannot access the file: %s\n", argv[i]);
			exit(1);
		}
	}
	if (!files)
		tolpr(stdin);
	exit(0);
}

tolpr(fp)		/* insert tab at BOL, remarry widows */
FILE *fp;
{
	char s[BUFSIZ], first = 1, paginate = 0, empty;
	static int pageno = 1;
	register int lno;
	int i;

	for (lno = 1; fgets(s, BUFSIZ, fp); lno++)
	{
		if (first)			/* determine page scheme */
		{
			if (s[0] != '\n')
				paginate = 1;
			first = 0;
		}
		if (paginate && lno == 1)	/* provide 3 blank lines */
		{
			printf("\n\n\n");
			if (shift)
				putchar('\t');
			printf("%sPage %d\n\n", hdr, pageno++);
			lno = 6;
		}
		else if (paginate && lno == 63)	 /* save widow, new page */
		{
			if (empty)
			{
				printf("\n\n\n\n\n\n\n");
				if (shift)
					putchar('\t');
				printf("%sPage %d\n\n", hdr,pageno++);
				lno = 6;
			}
		}
		else if (paginate && lno >= 64)	 /* break to new page */
		{
			breakpg:
				printf("\n\n\n\n\n\n");
				if (shift)
					putchar('\t');
				printf("%sPage %d\n\n", hdr,pageno++);
				lno = 6;
		}
		else if (lno >= 66)		/* reset page cycle */
			lno = 1;

		for (i = 1; i < spacing; i++)	/* optional linespacing */
		{
			putchar('\n');
			lno++;
			if (lno >= 64)
				goto breakpg;
		}
		if (s[0] != '\n' && shift)	/* don't pad empty lines */
		{
			putchar('\t');
			empty = 0;		/* remember empty lines */
		}
		else
			empty = 1;

		fputs(s, stdout);
	}
	while (lno++ <= 66)			/* force out page */
		putchar('\n');
}
