# include <stdio.h>				/* togrk.c (rev3.7) */

main(argc, argv)	/* transliterate Walton's Greek for nroff/troff */
int argc;
char *argv[];
{
	FILE *fopen(), *fp;
	int atbegin = 1;

	if (argc == 1)
	{
		tmacdef();
		togrk(stdin);
		exit(0);
	}
	while (--argc > 0)
	{
		if ((fp = fopen(*++argv, "r")) == NULL)
		{
			fflush(stdout);
			fprintf(stderr,
			"Togrk cannot access the file: %s\n", *argv);
			continue;
		}
		else  /* file opened successfully */
		{
			if (atbegin)
				tmacdef();
			atbegin = 0;
			togrk(fp);
			fclose(fp);
		}
	}
	exit(0);
}

togrk(fp)		/* convert transliteration to troff strings */
FILE *fp;
{
	register int c;

	while ((c = getc(fp)) != EOF)
	{
		switch (c)
		{
		case 'a': printf("\\(*a"); break;	/* alpha */
		case 'A': printf("\\(*A"); break;
		case 'b': printf("\\(*b"); break;	/* beta */
		case 'B': printf("\\(*B"); break;
		case 'g': printf("\\(*g"); break;	/* gamma */
		case 'G': printf("\\(*G"); break;
		case 'd': printf("\\(*d"); break;	/* delta */
		case 'D': printf("\\(*D"); break;
		case 'e': printf("\\(*e"); break;	/* epsilon */
		case 'E': printf("\\(*E"); break;
		case 'z': printf("\\(*z"); break;	/* zeta */
		case 'Z': printf("\\(*Z"); break;
		case 'h': printf("\\(*y"); break;	/* eta(* */
		case 'H': printf("\\(*Y"); break;
		case 'q': printf("\\(*h"); break;	/* theta(*) */
		case 'Q': printf("\\(*H"); break;
		case 'i': printf("\\(*i"); break;	/* iota */
		case 'I': printf("\\(*I"); break;
			/* iota subscript(*) - j - J */
		case 'j': printf("\\(*i"); break;	/* iota subsript? */
		case 'J': printf("\\(*I"); break;
		case 'k': printf("\\(*k"); break;	/* kappa */
		case 'K': printf("\\(*K"); break;
		case 'l': printf("\\(*l"); break;	/* lambda */
		case 'L': printf("\\(*L"); break;
		case 'm': printf("\\(*m"); break;	/* mu */
		case 'M': printf("\\(*M"); break;
		case 'n': printf("\\(*n"); break;	/* nu */
		case 'N': printf("\\(*N"); break;
		case 'x': printf("\\(*c"); break;	/* xi */
		case 'X': printf("\\(*C"); break;
		case 'o': printf("\\(*o"); break;	/* omicron */
		case 'O': printf("\\(*O"); break;
		case 'p': printf("\\(*p"); break;	/* pi */
		case 'P': printf("\\(*P"); break;
		case 'r': printf("\\(*r"); break;	/* rho */
		case 'R': printf("\\(*R"); break;
		case 's': printf("\\(*s"); break;	/* sigma */
		case 'S': printf("\\(*S"); break;
		case 't': printf("\\(*t"); break;	/* tau */
		case 'T': printf("\\(*T"); break;
		case 'u': printf("\\(*u"); break;	/* upsilon */
		case 'U': printf("\\(*U"); break;
		case 'f': printf("\\(*f"); break;	/* phi(*) */
		case 'F': printf("\\(*F"); break;
		case 'c': printf("\\(*x"); break;	/* chi */
		case 'C': printf("\\(*X"); break;
		case 'y': printf("\\(*q"); break;	/* psi */
		case 'Y': printf("\\(*Q"); break;
		case 'w': printf("\\(*w"); break;	/* omega */
		case 'W': printf("\\(*W"); break;
			/* digamma - \fIf\fR - \fIF\fR (passed as is) */
		case '+': printf("\\s-2\\(pl\\s0"); break;
		case '-': printf("\\s-2\\(mi\\s0"); break;
			/* grave accent - change from \ to ` */
		case '`':printf("\\*`"); break;
		case '^': printf("\\*^"); break;
		case '/': printf("\\*'"); break;
			/* question - ; (why not ? ?) */
			/* diaeresis e.g. over alpha - \(*:a */
			/* must be changed to a\*: */
		default: putchar(c); break;
		}
	}
}

tmacdef()	/* define troff macros so macro package isn't needed */
{
	printf(".if n \\{\\\n");
	printf(".ds #H 0\n");
	printf(".ds #V 0.8m\n");
	printf(".ds #f +0.3m\n");
	printf(".ds #[ \\f1\n");
	printf(".ds #] \\fP\n");
	printf(".\\}\n");
	printf(".if t \\{\\\n");
	printf(".ds #H ((1u-(\\\\\\\\n(.fu%2u))*0.13m)\n");
	printf(".ds #V 0.6m\n");
	printf(".ds #f \"\n");
	printf(".ds #[ \\&\n");
	printf(".ds #] \\&\n");
	printf(".\\}\n");
	printf(".ds ' \\k_\\h'-(\\\\n(.wu*8/10-\\*(#H)'\\*(#[\\(aa\\h'|\\\\n_u'\\*(#]\n");
	printf(".ds ` \\k_\\h'-(\\\\n(.wu*8/10-\\*(#H)'\\*(#[\\(ga\\h'|\\\\n_u'\\*(#]\n");
	printf(".ds ^ \\k_\\h'-(\\\\n(.wu-\\*(#H)'\\*(#[^\\h'|\\\\n_u'\\*(#]\n");
	printf(".ds : \\k_\\h'-(\\\\n(.wu*8/10-\\*(#H+0.1m\\*(#f)'\\v'-\\*(#V'\\*(#[\\z.\\h'0.2m\\*(#f'.\\h'|\\\\n_u'\\v'\\*(#V'\\*(#]\n");
	printf(".rm #[ #] #H #V #f\n");
}
