# include <stdio.h>

main(argc, argv)	/* allow user to enter lines within skeleton */
int argc;
char *argv[];
{
	FILE *fopen(), *pfp, *fp;
	char s[BUFSIZ];

	if (argc != 2)
	{
		puts("Usage: skel filename\t\t(rev3.7)");
		exit(1);
	}
	if (access(argv[1], 0) == 0)
	{
		printf("File %s already exists.\n", argv[1]);
		exit(1);
	}
	if ((pfp = fopen("promptfile", "r")) == NULL)
	{
		puts("Required promptfile is missing.");
		exit(1);
	}
	if ((fp = fopen(argv[1], "w")) == NULL)
	{
		perror(argv[1]);
		exit(1);
	}
	while (fgets(s, BUFSIZ, pfp))
	{
		fputs(s, fp);
		fputs(s, stdout);
		do {
			putchar('\t');
			fgets(s, BUFSIZ, stdin);
			if (s[0] == '~' && (s[1] == 'e' || s[1] == 'v'))
			{
				callex(fp, argv[1], s[1]);
				puts("(continue)");
				continue;
			}
			putc('\t', fp);
			if (s[0] == '.' && s[1] == '\n')
				s[0] = '\003';		/* ctrl-c (etx) */
			fputs(s, fp);
		} while (s[0] != '\003' || s[1] != '\n');
	}
}

callex(fp, argv, e)	/* call ex editor to correct mistakes */
FILE *fp;
char *argv, e;
{
	FILE *tfp, *fopen();
	register int c;
	char command[80], *tempfile, *mktemp(), *sprintf();

	fp = freopen(argv, "r", fp);
	tempfile = "/tmp/SklXXXXX";
	mktemp(tempfile);
	tfp = fopen(tempfile, "w");
	while ((c = getc(fp)) != EOF)
		putc(c, tfp);
	if (ferror(tfp))
		perror(tempfile);
	fclose(tfp);
	if (e == 'e')
		sprintf(command, "ex %s", tempfile);
	if (e == 'v')
		sprintf(command, "vi +$ %s", tempfile);
	system(command);
	tfp = fopen(tempfile, "r");
	fp = freopen(argv, "w", fp);
	while ((c = getc(tfp)) != EOF)
		putc(c, fp);
	if (ferror(fp))
		perror(argv);
	fp = freopen(argv, "a", fp);
	unlink(tempfile);
	return;
}
