# include <stdio.h>			/* exclude.c (rev3.7) */
# include <ctype.h>
# define MXWDS 500

char mode = 'i';	/* default is ignore mode, not only mode */

usage()			/* print proper usage and exit */
{
	puts("Usage: exclude [-i -o exclfile] [filename(s)]\t(rev3.7)");
	puts("-i: exclfile contains words to be ignored, one per line");
	puts("-o: exclfile has only words to be printed, one per line");
	puts("With no options, excluded words should be in \"exclfile\".");
	exit(1);
}

main(argc, argv)	/* exclude common words from concordance */
int argc;
char *argv[];
{
	FILE *fp, *fopen();
	int i = 1;

	if (argc == 1)
	{
		rdexclf("exclfile");
		exclude(stdin);
		exit(0);
	}
	if (argv[1][0] == '-')
	{
		if (argc == 2)
			usage();
		if (argv[1][1] == 'i')
			mode = 'i';
		else if (argv[1][1] == 'o')
			mode = 'o';
		else  /* bad flag */
			usage();
		rdexclf(argv[2]);
		if (argc == 3)
			exclude(stdin);
		i = 3;
	}
	else  /* no options used */
		rdexclf("exclfile");
	for (; i < argc; i++)
	{
		if ((fp = fopen(argv[i], "r")) != NULL)
		{
			exclude(fp);
			fclose(fp);
		}
		else  /* can't open input file */
		{
			fprintf(stderr,
			"Exclude cannot access the file: %s\n", argv[i]);
			continue;
		}
	}
	exit(0);
}

char *wdptr[MXWDS];	/* array of pointers to excluded words */
int nwds = 0;		/* the number of excluded words in core */

rdexclf(fname)		/* load structure with words from exclfile */
char fname[];
{
	FILE *efp, *fopen();
	char wd[512], *p, *malloc(), *strcpy();

	if ((efp = fopen(fname, "r")) == NULL)
	{
		fprintf(stderr,
		"Cannot access exclude file: %s\n", fname);
		usage();
		exit(1);
	}
	while (fgets(wd, 512, efp))
	{
		if (nwds >= MXWDS)
		{
			fprintf(stderr,
			"Maximum of %d exclude words allowed.\n", MXWDS);
			exit(1);
		}
		else if ((p = malloc((unsigned)(strlen(wd)+1))) == NULL)
		{
			fprintf(stderr,
			"Exclude: no more space left in core.\n");
			exit(1);
		}
		else  /* everything is OK */
		{
			strcpy(p, wd);
			wdptr[nwds++] = p;
		}
	}
	return;
}

exclude(fp)		/* filter out excluded words, i or o mode */
FILE *fp;
{
	char s[512], word[512];

	while (fgets(s, 512, fp))
	{
		if (firstword(s, word) == 0)
			continue;
		if (mode == 'i')
		{
			if (!inlist(word))
				fputs(s, stdout);
		}
		if (mode == 'o')
		{
			if (inlist(word))
				fputs(s, stdout);
		}
	}
}

firstword(s, wd)	/* return first word of string s */
char s[], *wd;
{
	int i = 0;

	if (isspace(s[i]))
		return(0);
	while (!isspace(s[i]))
		*wd++ = s[i++];
	*wd++ = '\n';
	*wd = NULL;
	return(1);
}

inlist(word)		/* check to see if word is in exclude list */
char word[];
{
	int i;

	for (i = 0; i < nwds; i++)
	{
		if (strcmp(word, wdptr[i]) == 0)
			return(1);
	}
	return(0);
}
