.TH ACCENT HUM (rev3.7)
.ds ]W UC Berkeley
.SH NAME
.nf
accent \- user-controlled accent module
cedilla \- convert plus mark to cedilla
umlaut \- convert plus mark to umlaut
.fi
.SH SYNOPSIS
.nf
\fBaccent\fP  [ \fB\-a\fP  accfile ]  [ filename ... ]
\fBcedilla\fP  [ filename ... ]
\fBumlaut\fP  [ filename ... ]
.fi
.SH DESCRIPTION
\fIAccent\fP reads accent mark definitions from ``accfile'',
or some other file specified after the -a option.
This file should have one or more lines
of a character, some space, and another character.
\fIAccent\fP converts all characters on the left
into a backspace and the corresponding character on the right.
When using \fIaccent\fP, create a punctuation file
(to be specified after the -d option of \fIkwic\fP)
containing all your left-hand accent marks on its second line.
\fIKwic\fP will consider these as zero-width characters.
.PP
For convenience, two links to \fIaccent\fP are provided:
\fIcedilla\fP and \fIumlaut\fP.
\fICedilla\fP converts the plus mark to a backspace and comma,
which looks like a cedilla on the lineprinter;
this convention is used even on the phototypesetter.
\fIUmlaut\fP converts the plus mark to a backspace and double quote;
this passes for an umlaut on unsophisticated output devices.
The plus mark should follow the character that is to be accented;
for example, type "Provenc+al" or "Mu+llerin" in your text.
The use of a plus character to represent both accent marks
implies that you cannot have cedillas and umlauts in the same text,
unless you use the \fIaccent\fP program.
.PP
Be sure to use the + option of \fIkwic\fP or \fIkwal\fP,
or have a second line of zero-width characters in the punctuation file,
in order to create the proper character alignment.
\fIAccent, cedilla,\fP or \fIumlaut\fP should be called
after \fIsort\fP, but before \fIformat\fP.
If you are using these programs,
invoke the \-d flag of \fIsort\fP to prevent accent marks
from influencing dictionary order.
.SH "SEE ALSO"
kwal(hum), kwic(hum)
.SH AUTHOR
Bill Tuthill
.SH BUGS
\fIAccent\fP should probably be able to convert a character
into an arbitrary-length string.
