/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*
  pdb.c
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include "pdb.h"
#include "atom.h"
#include "matrix.h"

const char *sphere_color[6] = 
{":Carbon",":Oxygen",":Blue",":Yellow",":Hydrogen",":Green"};
const char *sphere_radius[6] = 
{":CarbonRadius",":OxygenRadius",":NRadius",":SRadius",":HydrogenRadius", ":Green"};
const double theta2rad = (M_PI/180);

coodinate::coodinate(void)
{
  x = 0.0;
  y = 0.0;
  z = 0.0;
}

coodinate::coodinate(coodinate& A)
{
  x = A.CoodinateX();
  y = A.CoodinateY();
  z = A.CoodinateZ();
}

coodinate::coodinate(double a, double b, double c)
{
  x = a;
  y = b;
  z = c;
}

void coodinate::print(void)
{
  printf("\t%f\t%f\t%f", CoodinateX(), CoodinateY(), CoodinateZ());
}


void coodinate::normalize(void)
{
  x = x / sqrt( x*x + y*y + z*z );
  y = y / sqrt( x*x + y*y + z*z );
  z = z / sqrt( x*x + y*y + z*z );
}

void coodinate::Rotate(coodinate& A, coodinate&B, double rad)
{
  matrix Od(4,4);
  coodinate X, Y, Z;

  rad = rad * theta2rad;
  double Sin_V = sin(rad);
  double Cos_V = cos(rad);

  Z = B-A;
  X = A^Z;
  Y = Z^X;

  X = Normalize(X);
  Y = Normalize(Y);
  Z = Normalize(Z);

  double A_CodX = A.CoodinateX();
  double A_CodY = A.CoodinateY();
  double A_CodZ = A.CoodinateZ();
  Od(0,0) = Od(1,1) = Od(2,2) = Od(3,3) = 1;
  Od(3,0) = A_CodX;
  Od(3,1) = A_CodY;
  Od(3,2) = A_CodZ;

  matrix yokoX(1,4),yokoY(1,4),yokoZ(1,4);
  matrix V(3,1);
  matrix yoko(3,3), tate(3,3), rot(3,3);

  yoko(0,0) = yokoX(0,0) = X.CoodinateX();
  yoko(0,1) = yokoX(0,1) = X.CoodinateY();
  yoko(0,2) = yokoX(0,2) = X.CoodinateZ();
  yokoX(0,3) = 1;
  yoko(1,0) = yokoY(0,0) = Y.CoodinateX();
  yoko(1,1) = yokoY(0,1) = Y.CoodinateY();
  yoko(1,2) = yokoY(0,2) = Y.CoodinateZ();
  yokoY(0,3) = 1;
  yoko(2,0) = yokoZ(0,0) = Z.CoodinateX();
  yoko(2,1) = yokoZ(0,1) = Z.CoodinateY();
  yoko(2,2) = yokoZ(0,2) = Z.CoodinateZ();
  yokoZ(0,3) = 1;

  tate = yoko.tr();
  
  rot(0,0) = rot(1,1) = Cos_V;
  rot(0,1) = Sin_V;
  rot(1,0) = -Sin_V;
  rot(0,2) = rot(1,2) = rot(2,0) = rot(2,1) = 0;
  rot(2,2) = 1;

  V(0,0) = x - A_CodX;
  V(1,0) = y - A_CodY;
  V(2,0) = z - A_CodZ;
  
  matrix tmp(3,1);
  tmp = yoko * V;
  tmp = rot * tmp;
  tmp = tate * tmp;

  x = tmp(0,0) + A_CodX;
  y = tmp(1,0) + A_CodY;
  z = tmp(2,0) + A_CodZ;

/*  
  Ox = yokoX * Od;
  Oy = yokoY * Od;
  Oz = yokoZ * Od;

  puts(":Root:lineX is a line;");
  puts(":Root:lineY is a line;");
  puts(":Root:lineZ is a line;\n");
  puts(":Root:lineX color is :Aquamarine;");
  puts(":Root:lineY color is :LimeGreen;");
  puts(":Root:lineZ color is :LemonChiffon;");
  printf(":Root:lineX from{%f,%f,%f};\n",A.CoodinateX(),A.CoodinateY(),A.CoodinateZ());
  printf(":Root:lineX to{%f,%f,%f};\n",Ox(0,0),Ox(0,1),Ox(0,2));
  printf(":Root:lineY from{%f,%f,%f};\n",A.CoodinateX(),A.CoodinateY(),A.CoodinateZ());
  printf(":Root:lineY to{%f,%f,%f};\n",Oy(0,0),Oy(0,1),Oy(0,2));
  printf(":Root:lineZ from{%f,%f,%f};\n",A.CoodinateX(),A.CoodinateY(),A.CoodinateZ());
  printf(":Root:lineZ to{%f,%f,%f};\n",Oz(0,0),Oz(0,1),Oz(0,2));
  puts(":Root drawall;");
*/
/*
  yoko(0,0) = x;
  yoko(0,1) = y;
  yoko(0,2) = z;
  yoko(0,3) = 1;


  double nx = B.CoodinateX() - A.CoodinateX();
  double ny = B.CoodinateY() - A.CoodinateY();
  double nz = B.CoodinateZ() - A.CoodinateZ();

  nx = nx / sqrt(nx*nx + ny*ny + nz*nz);
  ny = ny / sqrt(nx*nx + ny*ny + nz*nz);
  nz = nz / sqrt(nx*nx + ny*ny + nz*nz);

  double p = 1 - Cos_V;

  Tr(0,0) = p * (nx*nx) + Cos_V;
  Tr(0,1) = p * nx*ny + nz * Sin_V;
  Tr(0,2) = p * nx*nz - ny * Sin_V;
  Tr(0,3) = Tr(1,3) = Tr(2,3) = 0;

  Tr(1,0) = p * nx*ny - nz * Sin_V;
  Tr(1,1) = p * (ny*ny) + Cos_V;
  Tr(1,2) = p * ny*nz + nx * Sin_V;

  Tr(2,0) = p * nx*nz + ny * Sin_V;
  Tr(2,1) = p * ny*nz - nx * Sin_V;
  Tr(2,2) = p * (nz*nz) +  Cos_V;

  Tr(3,0) = -Od(3,0) * (1 - p *(nx*nx)+      Cos_V)
            -Od(3,1) * (    p * nx*ny - nz * Sin_V)
            -Od(3,2) * (    p * nx*nz + ny * Sin_V);
  Tr(3,1) = -Od(3,0) * (    p * nx*ny + nz * Sin_V)
            +Od(3,1) * (1 - p *(ny*ny)+      Cos_V)
            -Od(3,2) * (    p * ny*nz - nx * Sin_V);
  Tr(3,2) = -Od(3,0) * (    p * nx*nz - ny * Sin_V)
            -Od(3,1) * (    p * ny*nz + nx * Sin_V)
            +Od(3,2) * (1 - p *(nz*nz)+      Cos_V);
  Tr(3,3) = 1;

  ans = yoko * Tr;
  x = ans(0,0);
  y = ans(0,1);
  z = ans(0,2);
*/

}

double coodinate::Rotate2(coodinate& A, coodinate&B, coodinate& E, double deg)
{
  coodinate X, Y, Z, BC, EA, C;

  C.CoodinateSetX(x);
  C.CoodinateSetY(y);
  C.CoodinateSetZ(z);

  Z  = B - A;
  BC = C - B;
  EA = E - A;

  X = BC^Z;
  Y = EA^Z;

  X = Normalize(X);
  Y = Normalize(Y);
  double rad = X | Y;
  deg = deg * theta2rad ;

  rad = fabs(acos(rad));
  printf("Rad: %f\n", rad /theta2rad);

  if(rad < 0) rad = rad - deg;
  else rad = deg - rad;

  return(rad);
}

secondStructure::secondStructure(void)
{
  //begin.coodinate();
  //end.coodinate();
  beginID = 0;
  endID   = 0;
  oligo = 0;
  head = NULL;
  tail = NULL;
}

secondStructure::secondStructure(secondStructure& A)
{
  begin = A.Begin();
  end = A.End();
  beginID = A.BeginID();
  endID   = A.EndID();
  oligo = A.Oligo();
  head = A.heads();
  tail = A.tails();
}

void secondStructure::HelixSetBegin(coodinate a)
{
  if(head == NULL) return;
  begin.CoodinateSetX(a.CoodinateX());
  begin.CoodinateSetY(a.CoodinateY());
  begin.CoodinateSetZ(a.CoodinateZ());
}

void secondStructure::HelixSetEnd(coodinate a)
{
  if(head == NULL) return;
  end.CoodinateSetX(a.CoodinateX());
  end.CoodinateSetY(a.CoodinateY());
  end.CoodinateSetZ(a.CoodinateZ());
}

void secondStructure::print(void)
{
  printf("%d\t%d\t%c\n", beginID, endID, oligo);
}

void secondStructure::append(int a, int b, char c)
{
  secondStructure *newnode;
  if(head){
    newnode = new secondStructure;
    newnode->beginID = a;
    newnode->endID = b;
    newnode->oligo = c;

    tail->Next(newnode); // from container
    tail = newnode;
  }else{
    head= new secondStructure;
    tail= new secondStructure;
    head->beginID = a;
    head->endID = b;
    head->oligo = c;
    tail = head;
  }
}

//secondStructure::~secondStructure(){
//
//}

secondStructure* secondStructure::GetHelix(int a)
{
  secondStructure *newnode = head;
  for(int i=0; i<a; ++i) newnode = (secondStructure*)newnode->Next();
  return newnode;
}

residue::residue(void)
{
  aminoID[0] = '\0';
  aminoID[4] = '\0';
  resID = 0;
  atomSum = 0;
  head = NULL;
  tail = NULL;
  firstAtom = NULL;
  lastAtom = NULL;
}

residue::residue(residue& A)
{
  strncpy(aminoID, A.aminoIDs(),4);
  resID = A.resIDs();
  head = A.heads();
  tail = A.tails();
  firstAtom = first();
  lastAtom = last();
}

void residue::AtomSumSet(unsigned a)
{
  atomSum = a;
}

residue* residue::Append(char* a, int b)
{
  residue *newnode;
  if(head){
    newnode = new residue;
    for(int i=0; i<3; ++i) newnode->aminoID[i] = a[i];
    newnode->resID = b;
    tail->Next(newnode);
    tail = newnode; //newnode;
    return newnode;
  }else{
    head= new residue;
    tail= new residue;
    for(int i=0; i<3; ++i) head->aminoID[i] = a[i];
    head->resID = b;
    tail = head;
    return head;
  }
}

void residue::AppendAtom(char a, coodinate& b, int c, int d, int e)
{
  atom *newatom;
  if(firstAtom){
    newatom = new atom;
    newatom->name = a;
    newatom->axiz = b;
    newatom->remoteness = c;
    newatom->branch = d;
    newatom->atomID = e;
    lastAtom->Next(newatom);
    last(newatom);
  }else{
    firstAtom = new atom;
    lastAtom = new atom;
    firstAtom->name = a;
    firstAtom->axiz = b;
    firstAtom->remoteness = c;
    firstAtom->branch = d;
    firstAtom->atomID = e;
    last(first());
  }
}

void residue::print(void)
{
  printf("\t%s\t%d\n", aminoID, resID);
  printAtom(first());
}

 chain::chain(void)
{
  chainID = ' ';
  num = 0;
  top = NULL;
  bottom = NULL;
  firstResidue = NULL;
  lastResidue = NULL;
}

chain::chain(chain& A)
{
  chainID = A.chainIDs();
  num = A.nums();
  residueTable = A.residueTables();
  top = A.tops();
  bottom = A.bottoms();
  firstResidue = A.firstResidues();
  lastResidue = A.lastResidues();
}

chain* chain::Append(char A)
{
  chain *newnode;
  if(top){
    newnode = new chain;
    newnode->chainIDs(A);
    bottom->Next(newnode);
    bottom = newnode;
    return newnode;
  }else{
    top = new chain;
    bottom = new chain;
    top->chainIDs(A);
    bottom = top;
    return top;
  }
}

residue* chain::Append(char* a, int b)
{
  residue *newnode;
  if(firstResidue){
    newnode = new residue;
    for(int i=0; i<3; ++i) newnode->aminoID[i] = a[i];
    newnode->resID = b;
    lastResidue->Next(newnode);
    lastResidue = newnode;
    return newnode;
  }else{
    firstResidue= new residue;
    lastResidue = new residue;
    for(int i=0; i<3; ++i) firstResidue->aminoID[i] = a[i];
    firstResidue->resID = b;
    lastResidue = firstResidue;
    return firstResidue;
  }
}

chain* chain::GetChain(int a)
{
  chain *newnode = top;
  for(int i=0; i<a; ++i) newnode = (chain*)newnode->Next();
  return newnode;
}

residue* chain::GetResidue(int a)
{
  if(a>=num){
    fprintf(stderr,"err : residue %d is nothing.\n",a);
    exit(1);
  }
  return (residue*)residueTable[a];
}

void chain::print(void)
{
  printf("[%c]\n", chainID);
  residue* newnode = firstResidues();
  while(newnode != NULL){
    newnode->print();
    newnode = (residue*)newnode->Next();
  }
}

void coodinate::operator=(coodinate& B)
{
  CoodinateSetX(B.CoodinateX());
  CoodinateSetY(B.CoodinateY());
  CoodinateSetZ(B.CoodinateZ());
}

coodinate operator-(coodinate& A, coodinate& B)
{
  coodinate C;
  C.CoodinateSetX(A.CoodinateX()-B.CoodinateX());
  C.CoodinateSetY(A.CoodinateY()-B.CoodinateY());
  C.CoodinateSetZ(A.CoodinateZ()-B.CoodinateZ());
  return C;
}

coodinate operator+(coodinate& A, coodinate& B)
{
  coodinate C;
  C.CoodinateSetX(A.CoodinateX()+B.CoodinateX());
  C.CoodinateSetY(A.CoodinateY()+B.CoodinateY());
  C.CoodinateSetZ(A.CoodinateZ()+B.CoodinateZ());
  return C;
}

coodinate operator/(coodinate& A, double B)
{
  coodinate C;
  C.CoodinateSetX(A.CoodinateX()/B);
  C.CoodinateSetY(A.CoodinateY()/B);
  C.CoodinateSetZ(A.CoodinateZ()/B);
  return C;
}

coodinate operator*(coodinate& A, double B)
{
  coodinate C;
  C.CoodinateSetX(A.CoodinateX()*B);
  C.CoodinateSetY(A.CoodinateY()*B);
  C.CoodinateSetZ(A.CoodinateZ()*B);
  return C;
}

coodinate operator^(coodinate& A, coodinate& B)
{
  coodinate C;
  double A_CodX = A.CoodinateX();
  double A_CodY = A.CoodinateY();
  double A_CodZ = A.CoodinateZ();
  double B_CodX = B.CoodinateX();
  double B_CodY = B.CoodinateY();
  double B_CodZ = B.CoodinateZ();
  C.CoodinateSetX(A_CodY * B_CodZ - A_CodZ * B_CodY);
  C.CoodinateSetY(A_CodZ * B_CodX - A_CodX * B_CodZ);
  C.CoodinateSetZ(A_CodX * B_CodY - A_CodY * B_CodX);
  return C;
}

double operator|(coodinate& A, coodinate& B)
{
  double C = 0.0;
  C  = A.CoodinateX() * B.CoodinateX();
  C += A.CoodinateY() * B.CoodinateY();
  C += A.CoodinateZ() * B.CoodinateZ();
  return C;
}

coodinate Normalize(coodinate& A)
{
  coodinate C;
  double x=A.CoodinateX(), y=A.CoodinateY(), z=A.CoodinateZ();
  double nx = 0.0, ny = 0.0, nz = 0.0;
  nx = x / sqrt( x*x + y*y + z*z );
  ny = y / sqrt( x*x + y*y + z*z );
  nz = z / sqrt( x*x + y*y + z*z );
  C.CoodinateSetX(nx);
  C.CoodinateSetY(ny);
  C.CoodinateSetZ(nz);
  return C;
}

void printChain(chain* A)
{
  while(A != NULL){
    printf("[%c]\n", A->chainIDs());
    while(A->firstResidues() != NULL){
      A->firstResidues()->print();
    }
    A = (chain*)A->Next();
  }
}

void Sphere(char A, int C, coodinate& B)
{
  printf(":test:Atom%c%d is a sphere;\n",A,C);
  int colorID = 0;
  if(A == 'C') colorID = 0;
  else if(A == 'O') colorID = 1;
  else if(A == 'N') colorID = 2;
  else if(A == 'S') colorID = 3;
  else if(A == 'H') colorID = 4;
  printf(":test:Atom%c%d radius is %s;\n",A, C, sphere_radius[colorID]);
  printf(":test:Atom%c%d color is %s;\n",A, C, sphere_color[colorID]);

  printf(":test:Atom%c%d moves{%f,%f,%f};\n", A, C, B.CoodinateX(),B.CoodinateY(),B.CoodinateZ());
}
