/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#ifdef MOTIF
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <Xm/List.h>
#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/ToggleBG.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>
#include <Xm/Separator.h>
#include "../3dview/objecttag.h"
#include "../3dview/boolean.h"
#include "method.h"

#define ITEM_COUNT 1
#define VISIBLE_COUNT 10
#define LightPink 0x9f90ff
#define PaleGreen 0x6af96a
#define CornflowerBlue 0xe26634

extern char parse_buffer[BUFSIZ];
extern char* parse_point;
extern int is_only_pr_talk;
extern int yyparse();

Widget topLevel;
Widget list, tx, templateP, groupWidget, rowP, objectAlpha, objectShiness;
Widget itemText, scaleText, alphaText, shinessText, floatText, integerText;
Widget stringText, radiusText, depthText;
Widget locationFrame, rotationFrame, radioFrameG, scaleFrame, materialRow;
Widget floatFrame, integerFrame, stringFrame, meshFrame, sphereFrame;
Widget lx, ly, lz, rx, ry, rz, cx, cy, cz, sx, sy, sz;
int drawToggleFlag;


void DeleteAllItem(void)
{
  XmListDeleteAllItems(list);
}

void AddObject(const char* string, int flag)
{
  XmString xmString = 
    XmStringCreateLtoR((char*)string, XmSTRING_DEFAULT_CHARSET);
  XmListAddItem(list, xmString, flag);
}

void AddListCB(Widget w, caddr_t *cliant_data, caddr_t *callData)
{
  XmString xmString;
  char* string = XmTextGetString(tx);
  if(strlen(string) > 0){
    xmString = XmStringCreateLtoR(string, XmSTRING_DEFAULT_CHARSET);
    XmListAddItem(list, xmString, 1);
    XmTextSetString(w, NULL);
  }
  XtFree(string);
}

void DisplayLocation(char* name)
{
  char xValue[5],yValue[5],zValue[5];
  LocationValue(name, xValue, yValue, zValue);
  XmTextSetString(lx, xValue);
  XmTextSetString(ly, yValue);
  XmTextSetString(lz, zValue);
}

void DisplayRotation(char* name)
{
  char xValue[5],yValue[5],zValue[5];
  RotationValue(name, xValue, yValue, zValue);
  XmTextSetString(rx, xValue);
  XmTextSetString(ry, yValue);
  XmTextSetString(rz, zValue);
}

void SelectCB(Widget w, Widget lb, XmListCallbackStruct *call_data)
{
  Arg args[1];
  XtSetArg(args[0], XmNlabelString, call_data->item);
  XtSetValues(lb, args,1);

  char *objectName;
  if(XmStringGetLtoR(call_data->item, XmSTRING_DEFAULT_CHARSET, &objectName)){
    XmTextSetString(itemText, objectName);
    switch(GetObjectType(objectName)){
    case GROUP_OBJ :
      XtUnmanageChild(materialRow);
      XtUnmanageChild(floatFrame);
      XtUnmanageChild(integerFrame);
      XtUnmanageChild(stringFrame);
      XtUnmanageChild(meshFrame);
      XtUnmanageChild(sphereFrame);
      if(call_data->reason == XmCR_DEFAULT_ACTION) InGroup(objectName);
      else {
	DisplayLocation(objectName);
	DisplayRotation(objectName);
      }
      XtManageChild(locationFrame);
      XtManageChild(rotationFrame);
      XtManageChild(scaleFrame);
      XtManageChild(radioFrameG);      
      break;
    case MATERIAL_OBJ:
      XtUnmanageChild(locationFrame);
      XtUnmanageChild(rotationFrame);
      XtUnmanageChild(scaleFrame);
      XtUnmanageChild(radioFrameG);
      XtUnmanageChild(floatFrame);
      XtUnmanageChild(integerFrame);
      XtUnmanageChild(stringFrame);
      XtUnmanageChild(meshFrame);
      XtUnmanageChild(sphereFrame);

      char red[5], green[5], blue[5];
      ColorValue(objectName, red, green, blue);
      XmTextSetString(cx, red);
      XmTextSetString(cy, green);
      XmTextSetString(cz, blue);
      char specRed[5], specGreen[5], specBlue[5];
      SpecularValue(objectName, specRed, specGreen, specBlue);
      XmTextSetString(sx, specRed);
      XmTextSetString(sy, specGreen);
      XmTextSetString(sz, specBlue);
      float alpha = AlphaValue(objectName);
      char aText[5];
      sprintf(aText,"%1.2f",alpha);
      XmTextSetString(alphaText, aText);
      XtSetArg(args[0], XmNvalue, alpha * 100);
      XtSetValues(objectAlpha,args,1);

      float shiness = ShinessValue(objectName);
      sprintf(aText,"%.0f",shiness);
      XmTextSetString(shinessText, aText);
      XtSetArg(args[0], XmNvalue, shiness);
      XtSetValues(objectShiness,args,1);

      XtManageChild(materialRow);
      break;
    case DAT_INTEGER:
      XtUnmanageChild(locationFrame);
      XtUnmanageChild(rotationFrame);
      XtUnmanageChild(scaleFrame);
      XtUnmanageChild(radioFrameG);
      XtUnmanageChild(materialRow);
      XtUnmanageChild(floatFrame);
      XtUnmanageChild(stringFrame);
      XtUnmanageChild(meshFrame);
      XtUnmanageChild(sphereFrame);

      int valueInt = IntegerValue(objectName);
      char textInt[5];
      sprintf(textInt,"%d",valueInt);
      XmTextSetString(integerText, textInt);
      XtManageChild(integerFrame);
      break;
    case DAT_FLOAT:
      XtUnmanageChild(locationFrame);
      XtUnmanageChild(rotationFrame);
      XtUnmanageChild(scaleFrame);
      XtUnmanageChild(radioFrameG);
      XtUnmanageChild(materialRow);
      XtUnmanageChild(integerFrame);
      XtUnmanageChild(stringFrame);
      XtUnmanageChild(meshFrame);
      XtUnmanageChild(sphereFrame);

      float valueFloat = FloatValue(objectName);
      char text[5];
      sprintf(text,"%.2f",valueFloat);
      XmTextSetString(floatText, text);
      XtManageChild(floatFrame);
      break;
    case DAT_STRING:
      XtUnmanageChild(locationFrame);
      XtUnmanageChild(rotationFrame);
      XtUnmanageChild(scaleFrame);
      XtUnmanageChild(radioFrameG);
      XtUnmanageChild(materialRow);
      XtUnmanageChild(integerFrame);
      XtUnmanageChild(floatFrame);
      XtUnmanageChild(meshFrame);
      XtUnmanageChild(sphereFrame);

      XmTextSetString(stringText, StringValue(objectName));
      XtManageChild(stringFrame);
      break;
    case LIGHT_OBJ:
      XtUnmanageChild(rotationFrame);
      XtUnmanageChild(scaleFrame);
      XtUnmanageChild(radioFrameG);
      XtUnmanageChild(materialRow);
      XtUnmanageChild(integerFrame);
      XtUnmanageChild(floatFrame);
      XtUnmanageChild(stringFrame);
      XtUnmanageChild(meshFrame);
      XtUnmanageChild(sphereFrame);

      DisplayLocation(objectName);
      XtManageChild(locationFrame);
      break;
    case POL_SPHERE:
      XtUnmanageChild(materialRow);
      XtUnmanageChild(integerFrame);
      XtUnmanageChild(floatFrame);
      XtUnmanageChild(stringFrame);

      DisplayLocation(objectName);
      DisplayRotation(objectName);
      char rad[8], dep[5];
      SphereValue(objectName, rad, dep);
      XmTextSetString(radiusText, rad);
      XmTextSetString(depthText,  dep);

      XtManageChild(locationFrame);
      XtManageChild(rotationFrame);
      XtManageChild(radioFrameG);
      XtManageChild(sphereFrame);
      XtManageChild(scaleFrame);
      break;
    case POL_PIPE0:
    case POL_CYLINDER0:
      XtUnmanageChild(materialRow);
      XtUnmanageChild(integerFrame);
      XtUnmanageChild(floatFrame);
      XtUnmanageChild(stringFrame);
      XtUnmanageChild(sphereFrame);

      DisplayLocation(objectName);
      DisplayRotation(objectName);
      XtManageChild(locationFrame);
      XtManageChild(rotationFrame);
      XtManageChild(scaleFrame);
      break;
    case POL_MESH:
      XtUnmanageChild(materialRow);
      XtUnmanageChild(integerFrame);
      XtUnmanageChild(floatFrame);
      XtUnmanageChild(stringFrame);
      XtUnmanageChild(sphereFrame);

      DisplayLocation(objectName);
      DisplayRotation(objectName);
      XtManageChild(locationFrame);
      XtManageChild(rotationFrame);
      XtManageChild(scaleFrame);
      XtManageChild(radioFrameG);
      XtManageChild(meshFrame);
      break;
    case GORTH_OBJ:
    case DAT_LIST:
    default:
      fprintf(stderr,"not exist in current group.%d\n",GetObjectType(objectName));
      break;
    }
  }
  XtFree(objectName);
}

void upButtonCB(Widget w, caddr_t *cliant_data, caddr_t *callData)
{
  char* valueName = OutGroup();
  XmString name = XmStringCreateLtoR(valueName, XmSTRING_DEFAULT_CHARSET);
  Arg args[1];
  XtSetArg(args[0], XmNlabelString, name);
  XtSetValues(w, args,1);
  XmTextSetString(itemText, valueName);
}

void colorEditCB(Widget w, char* text)
{
  Widget editor;

}

void selectItemCB(Widget w, caddr_t *cliant_data, caddr_t *callData)
{

}

void scaleCB(Widget w, caddr_t cliant_data, XmScaleCallbackStruct *cbs)
{
  double magnify = cbs->value / 100.0;
  printf("%s magnify %1.2f;\n",XmTextGetString(itemText), magnify);
  fflush(stdout);
  char sText[5];
  sprintf(sText,"%1.2f", magnify);
  XmTextSetString(scaleText, sText);
}

void shinessCB(Widget w, caddr_t cliant_data, XmScaleCallbackStruct *cbs)
{
  double shiness = cbs->value;
  char aText[5];
  sprintf(aText,"%.0f", shiness);
  XmTextSetString(shinessText, aText);
}

void alphaCB(Widget w, caddr_t cliant_data, XmScaleCallbackStruct *cbs)
{
  double alpha = cbs->value / 100.0;
  char aText[5];
  sprintf(aText,"%1.2f", alpha);
  XmTextSetString(alphaText, aText);
}

void LocationCB(Widget w, char* label)
{
  char* name =  XmTextGetString(itemText);
  char* value= XmTextGetString(w);
  double v = atof(value);

  if(strcmp(label,"LocationX")==0) {
    char* strY = XmTextGetString(ly);
    double y = atof(strY);
    char* strZ = XmTextGetString(lz);
    double z= atof(strZ);
    MoveObject(name, v, y, z);
    XtFree(strY);
    XtFree(strZ);
  }
  else if(strcmp(label,"LocationY")==0) {
    char* strX = XmTextGetString(lx);
    double x = atof(strX);
    char* strZ = XmTextGetString(lz);
    double z= atof(strZ);
    MoveObject(name, x, v, z);
    XtFree(strX);
    XtFree(strZ);
  }
  else {
    char* strX = XmTextGetString(lx);
    double x = atof(strX);
    char* strY = XmTextGetString(ly);
    double y= atof(strY);
    MoveObject(name, x, y, v);
    XtFree(strX);
    XtFree(strY);
  }
  fflush(stdout);

  XtFree(value);
  XtFree(name);
}

void SphereTextCB(Widget w, char* label)
{
  char* name =  XmTextGetString(itemText);
  char* value = XmTextGetString(w);
  
  if(strcmp(label,"radius")==0) RadiusObject(name, (const char*)value);
  else DepthObject(name, (const char*)value);
  fflush(stdout);

  XtFree(value);
  XtFree(name);
}

void toggleCB(Widget w, int which, XmToggleButtonCallbackStruct *state)
{
  if(state->set == 0) return;
  fprintf(stderr,"%s: set = %d, which = %d\n",XtName(w), state->set, which);
  char *name = XmTextGetString(itemText);
  if(which == 0){
    printf("%s draw;\n",name);
    fflush(stdout);
  }
  else if(which == 1){
    printf("%s hide;\n",name);
    fflush(stdout);
  }
  XtFree(name);
}

void MainLoop(int argc, char** argv)
{
  Arg args[10];
  int i, n;
  XmString xms[20];

  topLevel = XtInitialize(argv[0],"List",NULL,0,&argc,argv);
  rowP = XtVaCreateWidget("rowP",xmRowColumnWidgetClass, topLevel,
				 XmNorientation, XmHORIZONTAL, NULL);
  XtManageChild(rowP);

  /* ¦Υե졼 */
  Widget leftFrame = 
    XtVaCreateManagedWidget("leftFrame",xmFrameWidgetClass,rowP,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);

  Widget bBoard = XmCreateRowColumn(leftFrame, "bBoard", NULL, 0);
  
  xms[0] = XmStringCreateLtoR("Root", XmSTRING_DEFAULT_CHARSET);

  /* ȥ롼פɽܥκ */
  Widget upButton = XmCreatePushButton(bBoard,":",NULL,0);
  XtManageChild(upButton);
  XtAddCallback(upButton,XmNactivateCallback, (XtCallbackProc)upButtonCB,NULL);

  /* СդꥹȥåȤκ */
  n = 0;
  XtSetArg(args[n], XmNitems, xms); n++;
  XtSetArg(args[n], XmNitemCount, ITEM_COUNT); n++;
  XtSetArg(args[n], XmNvisibleItemCount, VISIBLE_COUNT); n++;
  XtSetArg(args[n], XmNlistSizePolicy, XmCONSTANT); n++;
  XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n++;
  XtSetArg(args[n], XmNwidth, 300); n++;
  list = XmCreateScrolledList(bBoard, "list", args, n);
  XtManageChild(list);
  XtAddCallback(list,XmNbrowseSelectionCallback,
		(XtCallbackProc)SelectCB,upButton);
  XtAddCallback(list,XmNdefaultActionCallback,
		(XtCallbackProc)SelectCB,upButton);
  XmListDeleteAllItems(list);
  GroupList("Root", 0);

  Widget sep = XmCreateSeparator(bBoard, "sep", NULL,0);
  XtManageChild(sep);

  /* ʸѥƥȥåȤκ */
  tx = XmCreateText(bBoard,"tx", NULL,0);
  XtManageChild(tx);
  XtAddCallback(tx, XmNactivateCallback, (XtCallbackProc)AddListCB,NULL);
  XtManageChild(bBoard);


  /* ƥ֥ѤΥƥץ졼Ȥο */
  groupWidget = XmCreateRowColumn(rowP, "groupWidget", NULL, 0);

  /* 򤵤줿ƥɽ٥κ */
  Widget itemFrame = 
    XtVaCreateManagedWidget("itemFrame",xmFrameWidgetClass,groupWidget,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  Widget itemRow = XtVaCreateWidget("itemRow",xmRowColumnWidgetClass,
					itemFrame, XmNorientation, 
					XmVERTICAL, NULL);
  Widget iLabel = XtVaCreateManagedWidget("Selected Object",xmLabelWidgetClass,
					  itemRow, NULL);
  XtSetArg(args[0], XmNwidth,400);
  itemText = XmCreateText(itemRow,"itemText", args, 1);
  XtManageChild(itemText);
  XtAddCallback(itemText, XmNactivateCallback,
		(XtCallbackProc)selectItemCB,NULL);
  XtManageChild(itemRow);

  /* Location Widget */
  locationFrame = 
    XtVaCreateManagedWidget("locationFrame",xmFrameWidgetClass,groupWidget,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  XtUnmanageChild(locationFrame);
  Widget locationRow = XtVaCreateWidget("lRow",xmRowColumnWidgetClass,
					locationFrame, XmNorientation, 
					XmHORIZONTAL, NULL);
  XtManageChild(locationRow);
  Widget lLabel = XtVaCreateManagedWidget("Location",xmLabelWidgetClass,
					  locationRow, NULL);
  XtSetArg(args[0], XmNwidth, 90);
  lx = XmCreateText(locationRow,"lx", args, 1);
  XtManageChild(lx);
  ly = XmCreateText(locationRow,"ly", args, 1);
  XtManageChild(ly);
  lz = XmCreateText(locationRow,"lz", args, 1);
  XtManageChild(lz);
  XtAddCallback(lx,XmNactivateCallback,LocationCB,"LocationX");
  XtAddCallback(ly,XmNactivateCallback,LocationCB,"LocationY");
  XtAddCallback(lz,XmNactivateCallback,LocationCB,"LocationZ");

  /* Rotation Widget */
  rotationFrame = 
    XtVaCreateManagedWidget("rotationFrame",xmFrameWidgetClass,groupWidget,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  XtUnmanageChild(rotationFrame);
  Widget rotationRow = XtVaCreateWidget("lRow",xmRowColumnWidgetClass,
					rotationFrame, XmNorientation, 
					XmHORIZONTAL, NULL);
  XtManageChild(rotationRow);
  Widget rLabel = XtVaCreateManagedWidget("Rotation",xmLabelWidgetClass,
					  rotationRow, NULL);
  rx = XmCreateText(rotationRow,"rx", args, 1);
  XtManageChild(rx);
  ry = XmCreateText(rotationRow,"ry", args, 1);
  XtManageChild(ry);
  rz = XmCreateText(rotationRow,"rz", args, 1);
  XtManageChild(rz);

  materialRow = XmCreateRowColumn(groupWidget,"material",NULL,0);
  XtUnmanageChild(materialRow);

  /* Widget */
  Widget colorFrame = 
    XtVaCreateManagedWidget("colorFrame",xmFrameWidgetClass,materialRow,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  Widget colorMainRow = XtVaCreateWidget("colormain", xmRowColumnWidgetClass,
					 colorFrame,
					 XmNpacking, XmPACK_COLUMN,
					 XmNnumColumns,1,
					 XmNisAligned, True,
					 NULL);
  Widget colorRow = XtVaCreateWidget("lRow",xmRowColumnWidgetClass,
				     colorMainRow,
				     XmNorientation, XmHORIZONTAL,
				     NULL);
  Widget colorLabel = XtVaCreateManagedWidget("Color   ",xmLabelWidgetClass,
					  colorRow, NULL);
  XtSetArg(args[0], XmNwidth, 70);
  XtSetArg(args[1], XmNbackground,LightPink);
  cx = XmCreateText(colorRow,"cx", args, 2);
  XtManageChild(cx);
  XtSetArg(args[1], XmNbackground,PaleGreen);
  cy = XmCreateText(colorRow,"cy", args, 2);
  XtManageChild(cy);
  XtSetArg(args[1], XmNbackground,CornflowerBlue);
  cz = XmCreateText(colorRow,"cz", args, 2);
  XtManageChild(cz);
  Widget colorEdit = XmCreatePushButton(colorRow,"Edit",NULL,0);
  XtManageChild(colorEdit);
  XtAddCallback(colorEdit,XmNactivateCallback, colorEditCB,"Color");
  XtManageChild(colorRow);

  Widget specularRow = XtVaCreateWidget("lRow",xmRowColumnWidgetClass,
				     colorMainRow,
				     XmNorientation, XmHORIZONTAL,
				     NULL);
  Widget specularLabel = XtVaCreateManagedWidget("Specular",xmLabelWidgetClass,
					  specularRow, NULL);
  XtSetArg(args[0], XmNwidth, 70);
  XtSetArg(args[1], XmNbackground,LightPink);
  sx = XmCreateText(specularRow,"sx", args, 2);
  XtManageChild(sx);
  XtSetArg(args[1], XmNbackground,PaleGreen);
  sy = XmCreateText(specularRow,"sy", args, 2);
  XtManageChild(sy);
  XtSetArg(args[1], XmNbackground,CornflowerBlue);
  sz = XmCreateText(specularRow,"sz", args, 2);
  XtManageChild(sz);
  Widget specularEdit = XmCreatePushButton(specularRow,"Edit",NULL,0);
  XtManageChild(specularEdit);
  XtAddCallback(specularEdit,XmNactivateCallback,colorEditCB,"Specular");
  XtManageChild(specularRow);
  XtManageChild(colorMainRow);
  XtManageChild(colorFrame);

  /* Widget */
  Widget shinessFrame = 
    XtVaCreateManagedWidget("shinessFrame",xmFrameWidgetClass,materialRow,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  Widget shinessRow = XtVaCreateWidget("lRow",xmRowColumnWidgetClass,
				       shinessFrame,
				       XmNorientation, XmHORIZONTAL,
				       XmNisAligned, True,
				       NULL);
  XtManageChild(shinessRow);
  Widget shinessLabel = XtVaCreateManagedWidget("Shiness",xmLabelWidgetClass,
					      shinessRow, NULL);
  n=0;
  XtSetArg(args[n], XmNmaximum, 255); n++;
  XtSetArg(args[n], XmNminimum, 0); n++;
  XtSetArg(args[n], XmNwidth, 225); n++;
  XtSetArg(args[n], XmNshowValue, True); n++;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  objectShiness = XmCreateScale(shinessRow, "shiness",args,n);
  XtManageChild(objectShiness);
  XtSetArg(args[0], XmNwidth, 70);
  XtSetArg(args[1], XmNvalue, "1.00");
  shinessText = XmCreateText(shinessRow,"shinessText", args, 2);
  XtManageChild(shinessText);
  XtAddCallback(objectShiness, XmNdragCallback,
		(XtCallbackProc)shinessCB,NULL);
  XtAddCallback(objectShiness, XmNvalueChangedCallback,
		(XtCallbackProc)shinessCB,NULL);
  XtManageChild(shinessFrame);

  /* Ʃ٤Widget */
  Widget alphaFrame = 
    XtVaCreateManagedWidget("alphaFrame",xmFrameWidgetClass,materialRow,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  Widget alphaRow = XtVaCreateWidget("lRow",xmRowColumnWidgetClass,
					alphaFrame, XmNorientation, 
					XmHORIZONTAL, NULL);
  XtManageChild(alphaRow);
  Widget alphaLabel = XtVaCreateManagedWidget("Alpha  ",xmLabelWidgetClass,
					      alphaRow, NULL);
  n=0;
  XtSetArg(args[n], XmNmaximum, 100); n++;
  XtSetArg(args[n], XmNminimum, 0); n++;
  XtSetArg(args[n], XmNwidth, 225); n++;
  XtSetArg(args[n], XmNshowValue, True); n++;
  XtSetArg(args[n], XmNdecimalPoints, 2); n++;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  objectAlpha = XmCreateScale(alphaRow, "alpha",args,n);
  XtManageChild(objectAlpha);
  XtSetArg(args[0], XmNwidth, 70);
  XtSetArg(args[1], XmNvalue, "1.00");
  alphaText = XmCreateText(alphaRow,"alphaText", args, 2);
  XtManageChild(alphaText);
  XtAddCallback(objectAlpha, XmNdragCallback, (XtCallbackProc)alphaCB,NULL);
  XtAddCallback(objectAlpha, XmNvalueChangedCallback,
		(XtCallbackProc)alphaCB,NULL);
  XtManageChild(alphaFrame);

  /* Float Widget */
  floatFrame = 
    XtVaCreateManagedWidget("floatFrame",xmFrameWidgetClass,groupWidget,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  XtUnmanageChild(floatFrame);
  Widget floatRow = XtVaCreateWidget("lRow",xmRowColumnWidgetClass,
					floatFrame, XmNorientation, 
					XmHORIZONTAL, NULL);
  XtManageChild(floatRow);
  Widget floatLabel = XtVaCreateManagedWidget("Float",xmLabelWidgetClass,
					  floatRow, NULL);
  XtSetArg(args[0], XmNwidth, 90);
  floatText = XmCreateText(floatRow,"floatText", args, 1);
  XtManageChild(floatText);

  /* Integer Widget */
  integerFrame = 
    XtVaCreateManagedWidget("integerFrame",xmFrameWidgetClass,groupWidget,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  XtUnmanageChild(integerFrame);
  Widget integerRow = XtVaCreateWidget("lRow",xmRowColumnWidgetClass,
					integerFrame, XmNorientation, 
					XmHORIZONTAL, NULL);
  XtManageChild(integerRow);
  Widget integerLabel = XtVaCreateManagedWidget("Integer",xmLabelWidgetClass,
					  integerRow, NULL);
  XtSetArg(args[0], XmNwidth, 90);
  integerText = XmCreateText(integerRow,"integerText", args, 1);
  XtManageChild(integerText);

  /* String Widget */
  stringFrame = 
    XtVaCreateManagedWidget("stringFrame",xmFrameWidgetClass,groupWidget,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  XtUnmanageChild(stringFrame);
  Widget stringRow = XtVaCreateWidget("lRow",xmRowColumnWidgetClass,
					stringFrame, XmNorientation, 
					XmHORIZONTAL, NULL);
  XtManageChild(stringRow);
  Widget stringLabel = XtVaCreateManagedWidget("String",xmLabelWidgetClass,
					  stringRow, NULL);
  stringText = XmCreateText(stringRow,"stringText", NULL, 0);
  XtManageChild(stringText);

  /* Sphere Widget */
  sphereFrame = 
    XtVaCreateManagedWidget("sphereFrame",xmFrameWidgetClass,groupWidget,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  XtUnmanageChild(sphereFrame);
  Widget sphereRow = XtVaCreateWidget("lRow",xmRowColumnWidgetClass,
					sphereFrame, XmNorientation, 
					XmHORIZONTAL, NULL);
  XtManageChild(sphereRow);
  Widget radiusLabel = XtVaCreateManagedWidget("Radius",xmLabelWidgetClass,
					  sphereRow, NULL);
  XtSetArg(args[0], XmNwidth, 90);
  radiusText = XmCreateText(sphereRow,"radiusText", args, 1);
  XtManageChild(radiusText);
  Widget depthLabel = XtVaCreateManagedWidget("Depth",xmLabelWidgetClass,
					  sphereRow, NULL);
  XtSetArg(args[0], XmNwidth, 90);
  depthText = XmCreateText(sphereRow,"depthText", args, 1);
  XtManageChild(depthText);
  XtAddCallback(radiusText, XmNactivateCallback,SphereTextCB, "radius");
  XtAddCallback(depthText,  XmNactivateCallback,SphereTextCB, "depth");

  /* Scale Widget */
  scaleFrame = 
    XtVaCreateManagedWidget("scaleFrame",xmFrameWidgetClass,groupWidget,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  XtUnmanageChild(scaleFrame);
  Widget scaleRow = XtVaCreateWidget("lRow",xmRowColumnWidgetClass,
					scaleFrame, XmNorientation, 
					XmHORIZONTAL, NULL);
  XtManageChild(scaleRow);
  Widget sLabel = XtVaCreateManagedWidget("Scale",xmLabelWidgetClass,
					  scaleRow, NULL);
  n=0;
  XtSetArg(args[n], XmNmaximum, 200); n++;
  XtSetArg(args[n], XmNminimum, 0); n++;
  XtSetArg(args[n], XmNvalue, 100); n++;
  XtSetArg(args[n], XmNwidth, 250); n++;
  XtSetArg(args[n], XmNshowValue, True); n++;
  XtSetArg(args[n], XmNdecimalPoints, 2); n++;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  Widget objectScale = XmCreateScale(scaleRow, "scale",args,n);
  XtManageChild(objectScale);
  XtSetArg(args[0], XmNwidth, 70);
  XtSetArg(args[1], XmNvalue, "1.00");
  scaleText = XmCreateText(scaleRow,"scaleText", args, 2);
  XtManageChild(scaleText);
  XtAddCallback(objectScale, XmNdragCallback, (XtCallbackProc)scaleCB,NULL);
  XtAddCallback(objectScale, XmNvalueChangedCallback, 
		(XtCallbackProc)scaleCB,NULL);


  /* Radio Button Widget */
  radioFrameG = 
    XtVaCreateManagedWidget("radioFrameG",xmFrameWidgetClass,groupWidget,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  XtUnmanageChild(radioFrameG);
  Widget drawRadioG = XmVaCreateSimpleRadioBox(radioFrameG, "drawRadioG",
	     0, //the initial choice
	     (XtCallbackProc)toggleCB,
	     XmNorientation, XmHORIZONTAL, 
	     XmVaRADIOBUTTON, XmStringCreateSimple("Draw"),NULL,NULL,NULL,
	     XmVaRADIOBUTTON, XmStringCreateSimple("Hide"),NULL,NULL,NULL,
	     XmVaRADIOBUTTON, XmStringCreateSimple("Wire"),NULL,NULL,NULL,
	     NULL);
  XtManageChild(drawRadioG);

  /* å奪֥Widget */
  meshFrame = 
    XtVaCreateManagedWidget("meshFrame",xmFrameWidgetClass,groupWidget,
			    XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  XtUnmanageChild(meshFrame);
  Widget meshRow = XtVaCreateWidget("meshRow", xmRowColumnWidgetClass,
				    meshFrame,
				    XmNorientation, XmHORIZONTAL, 
				    XmNpacking, XmPACK_COLUMN,
				    NULL);
  Widget anti = XtVaCreateManagedWidget("Antialias", xmToggleButtonGadgetClass,
					meshRow, NULL);
  //XtAddCallback(anti, XmNvalueChangedCallback, (XtCallbackProc)meshCB,0);
  Widget smooth = XtVaCreateManagedWidget("Smooth", xmToggleButtonGadgetClass,
					meshRow, NULL);
  //XtAddCallback(smooth, XmNvalueChangedCallback, (XtCallbackProc)meshCB,1);
  Widget nurbs = XtVaCreateManagedWidget("Nurbs", xmToggleButtonGadgetClass,
					meshRow, NULL);
  //XtAddCallback(nurbs, XmNvalueChangedCallback, (XtCallbackProc)meshCB,2);
  XtManageChild(meshRow);

  XtManageChild(groupWidget);

  XtRealizeWidget(topLevel);
  XtMainLoop();
}
#endif
