/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#ifndef _atom_h_
#define _atom_h_

#ifndef _header_h_
#include "../3dview/header.h"
#endif 
#ifndef _object_h_
#include "../3dview/object.h"
#endif 
#ifndef _pdb_h_
#include "pdb.h"
#endif

class atom :public header
{
  char name;
  coodinate axiz;
  int atomID;
  int remoteness;
  int branch;
  atom* bond1;
  atom* bond2;
  atom* bond3;
  atom* bond4;
  atom* head;
  atom* tail;
  friend class residue;

 public:
  atom(void);
  atom(atom& A);
//  ~atom(void){}
  void Append(char a, coodinate& b, int c, int d);
  atom* GetAtom(int);
  void print(void);
//  header* Location();
  inline char names(void){return name;}
  inline coodinate& axizs(void){return axiz;}
  inline void axizs(coodinate& A){axiz = A;}
  inline int atomIDs(void){return atomID;}
  inline int remotenesses(void){return remoteness;}
  inline int branchs(void){return branch;}
  inline atom* heads(void){return head;}
  inline atom* tails(void){return tail;}
  inline atom* bonds(int a){
    switch(a){
      case 1: return bond1; break;
      case 2: return bond2; break;
      case 3: return bond3; break;
      case 4: return bond4; break;
    }
  }
  inline void bonds(int a, atom* b){
    switch(a){
      case 1: bond1 = b; break;
      case 2: bond2 = b; break;
      case 3: bond3 = b; break;
      case 4: bond4 = b; break;
    }
  }
  inline void heads(atom* a){head = a;}
  inline void tails(atom* a){tail = a;}
  inline void print(int a){GetAtom(a)->print();}

};

extern void printAtom(atom* A);
extern void printAtomSingle(atom* A);
extern void bonds(atom* A, atom* B);

#endif /* eof ifndef _atom_h_ */



