/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
class wavelet
{
  int     NumberOfWavelets;
  int     Width;
  double* Wavelets;
 public:
  inline wavelet(void)
    {
      NumberOfWavelets = 0;
      Width            = 0;
      Wavelets         = NULL;
    }
  wavelet(int NW,int W);
  inline ~wavelet(void)
    {
      delete Wavelets;
    }
  inline double coordinate(int J)
    {
      double D = 2.0/(Width - 1);
      D =  2.0/(Width - 1);
      return ( -1.0 + D*J);
    }
  inline double& position(int I,int J)
    {
      if(I<0 || I>=NumberOfWavelets || J<0 || J>=Width)
	{
	  cerr << "Out of range\n";
	  exit(1);
	}
      return Wavelets[I*Width+J];
    }
  inline double* position(int I)
    {
      if(I<0 || I>=NumberOfWavelets)
	{
	  cerr << "Out of range\n";
	  exit(1);
	}
      return Wavelets+I*Width;
    }
  inline double& operator()(int I,int J)
    {
      return position(I,J);
    }
  inline double* operator()(int I)
    {
      return position(I);
    }
  inline double product(int I1,int I2)
    {
      double Product = 0;
      for(int J=0;J<Width;++J)
	Product += position(I1,J)*position(I2,J);
      return Product;
    }
  inline void copy(wavelet& Src)
    {
      NumberOfWavelets = Src.NumberOfWavelets;
      Width            = Src.Width;
      Wavelets         = new double[Width*NumberOfWavelets];
      for(int I=0;I<Width*NumberOfWavelets;++I)
	Wavelets[I] = Src.Wavelets[I];
    }
};

inline void operator =(wavelet& A,wavelet& B)
{
  A.copy(B);
}
