/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#ifndef _math_h_
#include <math.h>
#define _math_h_
#endif

#ifndef _stdlib_h_
#include <stdlib.h>
#define _stdlib_h_
#endif

#ifndef _matrix_h_
#define _matrix_h_

#define EPS 1E-6
#define MAX_ITER 100

class eigenvalue ;
class matrix {
 protected:
  unsigned int Nsize;
  unsigned int DimI;
  unsigned int DimJ;
  double* D;
 public:
  /* constructor function defined at matrix.c */
  matrix(int M,int N) ;
  matrix(void);
  matrix(matrix& A);

  /* destructor function defined at matrix.c */
  virtual ~matrix(void);
  virtual  void zap   (void);
  /* inline member function defined matrix.h */
  inline int    sizeN( void);
  inline int    sizeI( void);
  inline int    sizeJ( void);
  inline void   sizeN( int);
  inline void   sizeI( int);
  inline void   sizeJ( int);
  inline int pivotsearch(matrix C,int* q,int k);

  /* mwmber function defined at matrix.c */
  virtual void copy(matrix& A);
  double &operator ()(int I, int J);
  void print(void);
  matrix tr(void);
  matrix inverse(void);
  void changeline(int m1, int m2);
  double innerproduct(int n, double* u, double* v);
  double householder(int n,double* x);
  void tridiagonalize(double* d, double* e);
  eigenvalue eigen(void);
  /* friend function defined at matrix.c */
  friend void   operator/=(matrix& A, double B);      
  friend void   operator*=(matrix& A, double B);
};

extern matrix operator-(matrix& A);
extern matrix operator+(matrix& A);
extern matrix operator+(matrix& A, matrix& B);
extern matrix operator-(matrix& A, matrix& B);
extern matrix operator*(matrix& A, matrix& B);
extern matrix operator*(double& K, matrix& A);
extern matrix operator*(matrix& A, double& K);
extern matrix operator/(matrix& A, double& K);
extern void   operator=(matrix& A, matrix& B);



/* inline function for class matrix */

inline int matrix::pivotsearch(matrix C,int* q,int k)
{
  double max = 0.0;
  int L = 0;
  for (int i=0 ; i<DimI; i++,q++) {
    if (*q != 0)  continue;
    if (fabs(C(i,k)) <= max)	continue;
    max = fabs(C(i,k));
    L = i;
  }
  if (max < EPS) {
    fprintf(stderr,"Too Small Pivot 2\n max %f\n",max);
    exit(1);	  	      
  }
  return L;
}

inline int matrix::sizeN()
{
  return (unsigned int)Nsize;
}

inline int matrix::sizeI( void)
{
  return DimI;
}

inline int matrix::sizeJ( void)
{
  return DimJ;
}

inline void matrix::sizeN(int n)
{
  Nsize = (unsigned int)n;
}

inline void matrix::sizeI(int i)
{
  DimI = (unsigned int)i;
}

inline void matrix::sizeJ(int j)
{
  DimJ = (unsigned int)j;
}

/*#define sgn(x) ((x == 0) ? 0 : ((x>0.0) ? 1.0 : -1.0))*/

#endif /* eof ifndef _matrix_h_ */
