/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stream.h>
#include "matrix.h"
#include "d3vector.h"
#include "wavelet.h"
#include "amino.h"

class      residue
{
  int      ResOrder;
  amino    Amino;
  d3vector Coordinate;
  int      Internality;
 public:
  inline residue(void){ResOrder = Internality = 0;}
  inline void input(int& R,amino& A, d3vector& C, int I)
    {
      ResOrder    = R;
      Amino       = A;
      Coordinate  = C;
      Internality = I;
    }
  inline int&      order(void)      {return ResOrder;}
  inline amino&    amino(void)      {return Amino;}
  inline d3vector& coordinate(void) {return Coordinate;}
  inline int&      internality(void){return Internality;}
};

class localStruct
{
  int       FullCnt;
  int       Width;
  int       StartPoint;
  residue*  Residues;

  int       InternalSum;

// Local Vectors
  d3vector  LongVector;
  d3vector  BendVector;
  double    AngleLongBend;

// Local Coordinate Vectors
  d3vector  VecK;
  d3vector  VecI;
  d3vector  VecJ;

  void longVec(void);
  void bendVec(void);
 public:
  inline localStruct(int W)
    {
      FullCnt    =  0;
      Width      =  W;
      StartPoint = -1;
      InternalSum=  0;
      Residues   = new residue[Width];
    }
  inline ~localStruct(void)
    {
      delete Residues;
    }
  inline int fullCnt(void){return FullCnt;}
  inline residue& residue(int I)
    {
      return  Residues[(StartPoint+I+1)%Width];
    }

  d3vector center(void);
  void     input(int,amino&,d3vector&, int);
  int      parity(d3vector&);
  double   angleLong(d3vector&);
  double   angleBend(d3vector&);
  double   elemI(d3vector&);
  double   elemJ(d3vector&);
  double   elemK(d3vector&);
  d3vector startVector(void);
  d3vector endVector(void);
  d3vector wv3Vector(void);
  d3vector wv4Vector(void);
  void     printSeq(void);
  void     print(void);

  inline d3vector longVector(void){return LongVector;}//Long Vector
  inline d3vector bendVector(void){return BendVector;}//Bend Vector
  inline double   angleLongBend(void){return AngleLongBend;}//Angle

  d3vector rotVector(void);//  Rotation Vector
  d3vector intVector(void);// -Internality*Wavelet0-Coordinate*Wavelet0

  double   int0(void);     // -Internality*Wavelet0
  double   int1(void);     // -Internality*Wavelet1
  double   int2(void);     // -Internality*Wavelet2
};

extern wavelet  Wavelet;

