/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <stream.h>
#include <String.h>
#include "eigenvalue.h"
#include "multivar.h"

void multiData::div
(
 FILE* DivFile,
 int   Level,
 int   PlusMinus,
 int   SmthFlag,
 int*  FieldID,
 int   PFlag,
 int   OFlag
)
{
  matrix* Histo = (SmthFlag!=0?Histogram:HistogramSmooth);
  if(Histogram==NULL)
    {
      makeHistogram();
    }
  if(SmthFlag)
    {
      if(HistogramSmooth==NULL)
	{
	  smoothHistogram();
	}
    }

  double CntMin      [NumAxis];
  int    CntHist     [NumAxis];
  int    DivPoint    [NumAxis];
  int    DivPointHist[NumAxis];

  for(int J=0;J<NumAxis;++J)
    {
      CntMin      [J] = NumData;
      CntHist     [J] = 0;
      DivPoint    [J] = 0;
      DivPointHist[J] = 0;
    }
  for(int I=0;I<NumHist;++I)
    {
      for(J=0;J<NumAxis;++J)
	{
	  if(CntHist[J]>NumData/20 && (NumData-CntHist[J])<NumData/20)
	    {
	      if(
		 (*Histo)(I,J)<(*Histo)(I-1,J) &&
		 (*Histo)(I,J)<(*Histo)(I+1,J)
		 )  
	      if((*Histo)(I,J)<CntMin[J])
		{	
		  CntMin      [J] = (*Histo)(I,J);
		  DivPoint    [J] = I;
		  DivPointHist[J] = CntHist[J];
		}
	    }
	  CntHist[J] += int((*Histogram)(I,J));
	}
    }
  double AxisMin = NumData;
  int AxisID;
  for(J=0;J<NumAxis;++J)
    {
      if(CntMin[J] < AxisMin)
	{
	  AxisMin = CntMin[J];
	  AxisID = J;
	}
    }
  
  double Threshold = Range*2.0/NumHist*(DivPoint[AxisID]+0.5)-Range;
  fprintf(DivFile,"Level  %4d %c\n",
	  Level,(PlusMinus==0? ' ' :(PlusMinus>0? '+' : '-' )));
  Multivar->fprint(DivFile);

  multiData MultiDataMinus(AxisNum,FieldID);
  multiData MultiDataPlus (AxisNum,FieldID);
    
  for(I=0;I<NumData;++I)
    {
      matrix* PrincipalVal = makePrincipalVal(I);
      for(J=0;J<NumAxis;++J)
	{
	  if(PrincipalVal(0,AxisID)<Threshold)
	    {
	      MultiDataMinus.push(I,J,(*DataMatrix)(I,J));
	    }
	  else
	    {
	      MultiDataPlus.push(I,J,(*DataMatrix)(I,J));	      
	    }
	}
    }
  MultiDataMinus.end("_INTERNAL_",FieldID,PFlag,OFlag);
  MultiDataPlus .end("_INTERNAL_",FieldID,PFlag,OFlag);

  MultiDataMinus.div(DivFile,Level+1,-1,SmthFlag,FieldID,PFlag,OFlag);
  MultiDataPlus .div(DivFile,Level+1,+1,SmthFlag,FieldID,PFlag,OFlag);
}
