/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* */
/* -*-C++-*- */
#include "sphere.h"
#include "symbol.h"
#include "data.h"
#include "hash.h"
#include "exit.h"
#include "group.h"

extern group *root_obj;
extern char line_buffer[BUFSIZ];
char* errmsg_sphere_material_invalid = "Fatal : \nsphere member material invalid object\n";
char* errmsg_sphere_radius_invalid   = "Fatal : \nsphere member radius invalid object\n";
char* errmsg_sphere_depth_invalid    = "Fatal : \nsphere member depth invalid object\n";

node* default_node_sphere_radius;
node* default_node_sphere_depth;

/* #define _SELF_SPHERE_ */
/* 饤֥Ѥʤ */

void initialize_sphere()
//{}
// ֵץ֥ȤΥǥեȤͤ롣
//{}
{
  float_number* default_radius;
  fixed_number* default_depth;
  default_radius  = new float_number[1]; 
  default_radius->Value(1);
  default_radius->Split();
  default_depth  = new fixed_number[1]; 
  default_depth->Value(DEFAULT_DEPTH);
  default_depth->Split();
  default_node_sphere_radius = (node*)(root_obj->Search_and_Create("DefaultSphereRadius"));
  default_node_sphere_radius->Value(default_radius);
  default_node_sphere_radius->Split();
  default_node_sphere_depth = (node*)(root_obj->Search_and_Create("DefaultSphereDepth"));
  default_node_sphere_depth->Value(default_depth);
  default_node_sphere_depth->Split();
}

sphere::sphere()
//{}
//奪֥Ȥιۻ
//{}
{
  type = POL_SPHERE;
  sym_id = sym_sphere;
  dstate = ObjectHidding;
  scale = 1.0;
  header* value;
  value = default_node_sphere_radius->Value();
  value->Split();
  obj[0].Id(sym_om_radius);
  obj[0].Value(value);/*DefailtSphereRadius*/
  obj[0].Split();
  value = default_node_sphere_depth->Value();
  value->Split();
  obj[1].Id(sym_om_depth);
  obj[1].Value(value);/*DefailtSphereDepth*/
  obj[1].Split();
#ifdef DEBUG
  fprintf(stderr, "this (%x) rc %d void sphere::sphere()\n",(unsigned int) this,ref_c);
#endif
}

 void sphere::CopySplitMember()
//{}
// 奪֥ȤΥԡΥФλȥȽ
//{}
{
#ifdef DEBUG
  fprintf(stderr, "this (%x) rc %d void sphere::CopyMember()\n",(unsigned int) this,ref_c);
#endif
  object_location->Split();
  object_rotation->Split();
  int color_id = color->Id();
  header* cv = color->Value();
  cv->Split();
  color = new node[1];
  color->Id(color_id);
  color->Value(cv);
  header* value;
  int c ;
  for (c = 0;c<SPHERE_WORD_SIZE;c++) {
    value = obj[c].Value();
    value->Split();
  }
}

void sphere::Draw()
//{}
// ؿ
//{}
{
#ifdef DEBUG
  fprintf(stderr, "this (%x) rc %d void sphere::Draw()\n",(unsigned int) this,ref_c);
#endif
#ifndef _DISABLE_GL_
  float v[4];
  if (dstate == ObjectHidding) {
    return;
  }
  if (scale == 0) return; 
  check_material_and_bind(color->Value(),errmsg_sphere_material_invalid);
  v[0] = v[1] = v[2] = 0;
  radius = numerical2float(obj[0].Value(),errmsg_sphere_radius_invalid);
  if (radius <= 0) return ;
  v[3] = radius;
  depth = numerical2int(obj[1].Value(),errmsg_sphere_depth_invalid);
  if (depth > SPH_MAXDEPTH){
    fprintf(stderr,"Warning : sphere depth %d\nSphere depth must smaller than %d\n",depth,SPH_MAXDEPTH);
    depth = SPH_MAXDEPTH; 
  }
  if (depth < 1){
    fprintf(stderr,
       "Warning : sphere depth %d\nSphere depth must greater than 0\n",depth);
    depth = 1;
  }
  PushScale();
  PushTranslation();
  PushRotation();
  if (dstate == ObjectDrawing) {
    v[0] = 0;  v[1] = 0;  v[2] = 0;
#ifdef _SELF_SPHERE_
    backface(TRUE);
    int no_of_part ;
    float YTheta;
    float s[3];
    YTheta = M_PI/2;
    float tpi = 2*M_PI;
    float pd  = tpi/no_of_part;
    no_of_part = depth*4;
    for (;YTheta < (3*M_PI/2);YTheta += pd) {
      float sp_radius ;
      float sp_radius_next;
      float ZTheta = 0;
      sp_radius_next = radius*cos(YTheta+pd);
      sp_radius = radius*cos(YTheta);
      for (;ZTheta < tpi;ZTheta += pd) {
	bgnpolygon();
	float n[3] = {cos(ZTheta),sin(ZTheta),0};
	n3f(n);	
	s[0] = sp_radius*sin(ZTheta);
	s[1] = sp_radius*cos(ZTheta);
	s[2] = radius*sin(YTheta);
	v3f(s);
	s[0] = sp_radius_next*sin(ZTheta);
	s[1] = sp_radius_next*cos(ZTheta);
	s[2] = radius*sin(YTheta+pd);
	v3f(s);
	s[0] = sp_radius_next*sin(ZTheta+pd);
	s[1] = sp_radius_next*cos(ZTheta+pd);
	s[2] = radius*sin(YTheta+pd);
	v3f(s);
	s[0] = sp_radius*sin(ZTheta+pd);
	s[1] = sp_radius*cos(ZTheta+pd);
	s[2] = radius*sin(YTheta);
	v3f(s);
	endpolygon();
      }
    }
#else
    backface(TRUE);
    if (depth == (::sphere_depth)) sphdraw(v);
    else {
      sphmode(SPH_DEPTH,depth);
      sphdraw(v);
      sphmode(SPH_DEPTH,::sphere_depth);
    }
#endif
  } else {
    float Theta;
    int nof_part = depth*4;
    float DTheta = 2*M_PI/nof_part;
    int count;
    float lv[3];
    bgnline();
    for (Theta = 0,count = 0;count <= nof_part;count++,Theta+=DTheta) {
      lv[0] = v[3]*cos(Theta); lv[1] = v[3]*sin(Theta); lv[2] = 0; v3f(lv);
    }
    endline();
    bgnline();
    for (Theta = 0,count = 0;count <= nof_part;count++,Theta+=DTheta) {
      lv[0] = 0; lv[1] = v[3]*cos(Theta); lv[2] = v[3]*sin(Theta); v3f(lv);
    }
    endline();
    bgnline();
    for (Theta = 0,count = 0;count <= nof_part;count++,Theta+=DTheta) {
      lv[0] = v[3]*sin(Theta); lv[1] = 0; lv[2] = v[3]*cos(Theta); v3f(lv);
    }
    endline();
  }
  PopRotation();
  PopTranslation();
  PopScale();
#endif
}

 void sphere::Close()
//{}
// ΥԤʤ
// ȥȤ0ˤʤäˡΰ롣
// ⤷ޤ¾黲ȤƤСȥȤ
// 1餹
//{}
{
#ifdef DEBUG
  fprintf(stderr, "this (%x) rc %d void sphere::Close()\n",(unsigned int) this,ref_c);
#endif
  ref_c--;
  if (ref_c == 0) {
    color->Close();
    object_location->Close();
    for (int cc = 0;cc < SPHERE_WORD_SIZE;cc++) {
      obj[cc].Close();
    }
    free(this);
  }
}

 header* sphere::Reference(int id)
//{}
//奪֥ȤΥл
//ϥåidĥ̾ΥФ¸ߤС
//ФΥΡɤΥɥ쥹֤ǤʤС
//0֤
//{}
{

//  fprintf(stderr,"this (%x) header* shpere::Reference(int %d(char* %s))\n",
//	(unsigned int)this,id,hash_table.idWord(id));

  if (id == sym_om_color) {
    return (header*)(color);
  }
  for (int cc = 0;cc < SPHERE_WORD_SIZE;cc++) {
    if (id == (obj[cc].Id())) {
      return (header*)(obj+cc);
    }
  }
  return (header*)0;
}

void sphere::Scale(double s)
{
  scale = s;
}
