/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -*-C++-*- */
#ifdef _UN_USE_YACC_
#include <stdio.h>
#include "header.h"
#include "object.h"
#include "exit.h"
#include "node.h"
#include "group.h"
#include "data.h"
#include "hash.h"
#include "message.h"
#include "function.h"
#include "parser.h"

YYSTYPE yylval;

extern void bcopy(char* src,char* obj,unsigned int size);
extern message* make_message(MethodID id,header* args);
extern message* insert_message(message* top,message* tail);
extern header*  execute(header* obj,message* mess);
extern header*  make_instance(int id);
extern header*  insert_list(header* a,header* b);
extern header*  builtin_function(FunctionID fid,header* arg);
extern header*  object_member(header* obj,int id);
extern int      arg_length(header* arg);
extern header*  make_location(header* arg);
extern header*  append_args(header* top,header* tail);
extern group*   var_list;
extern group*   current_ref_group;
extern group* root_obj;
extern int      yylex();
extern void     yyerror(const char* s);
extern int      line_number;
extern char line_buffer[BUFSIZ];

#define SIZE_OF_STACK 40
int token_stack_index;
int token_stack_symbol[SIZE_OF_STACK];
YYSTYPE token_stack_value[SIZE_OF_STACK];

header* yyparse(int n,header *cn,int kflag);
void get_argment(int o,container* wp,header* np);

inline void init_token_stack()
{
  token_stack_index = 0;
}

void push_token(int symbol,YYSTYPE* value) 
{
#ifdef DEBUG
  printf("void push_token(int %d,YYSTYPE* %x)\n",symbol,(unsigned int)value);
#endif
  token_stack_symbol[token_stack_index] = symbol;
  bcopy((char*)&token_stack_value[token_stack_index],(char*)value,sizeof(YYSTYPE));
  token_stack_index++;
}

int pop_token(YYSTYPE* value) 
{
#ifdef DEBUG
  printf("int pop_token(YYSTYPE* %x)\n",(unsigned int)value);
#endif
  token_stack_index--;
  if (token_stack_index <0) {
    token_stack_index = 0;
#ifdef DEBUG
    printf("return %d\n",-1);
#endif
    return -1;
  }
  bcopy((char*)value,(char*)&token_stack_value[token_stack_index],sizeof(YYSTYPE));
#ifdef DEBUG
  printf("return %d\n",token_stack_symbol[token_stack_index]);
#endif
  return token_stack_symbol[token_stack_index];
}

inline int GetToken() 
{
#ifdef DEBUG
  printf("int GetToken()\n");
#endif
  int lex_code ;
  if ((lex_code = pop_token(&yylval))<0) {
    lex_code = yylex();
  }
#ifdef DEBUG
  printf("return %d\n",lex_code);
#endif
  return lex_code;
}

inline header* NextGroup(header* gobj,int sval)
{
#ifdef DEBUG
  printf("inline header* NextGroup(header* %x(",(unsigned int)gobj);
  gobj->Print();
  printf("),int %d)\n",sval);
#endif
  group* gp;
  gp = (group*)gobj;
  return  gp->Search_and_Create(sval);
}

inline void error_msg_is_not_group(header* cn)
{
  fprintf(stderr,"Fatal:\n%s is not group object %d\n",cn->Name(),line_number);
  error_exit();
}
inline void error_msg_is_not_member()
{
  fprintf(stderr,"Fatal:\n%s is not member line %d\n",hash_table.idWord(yylval.sval),line_number);
  error_exit();
}

inline void append_list(cons*last, header* new_car)
{
  cons* nc ;
  nc = new cons[1];
  nc->Car(new_car);
  last->Cdr(nc);
}

header* compute(header* obja,int op,header* objb)
{
  switch(op){
  case PLUS:
    return add(obja,objb);
  case MINUS:
    return sub(obja,objb);
  case MUL:
    return mul(obja,objb);
  case DIV:
    return dev(obja,objb);
  default:
    break;
  }
  return (header*)0;
}

int oprate(int lex_code)
{
  switch(lex_code) {
  case PLUS: case MINUS:
    return 100;
  case MUL: case DIV:
    return 200;
  default:
    break;
  }
  return 0;
}

header* expression (header* obj,int op)
{
  int op_level = oprate(op);
  node* np;
  int op_next_level;
  np = (node*)current_ref_group->Parent();
  for(;;){
    int lex_code;
    lex_code = GetToken();
    if (lex_code == MATH_FUNC) {
      FunctionID fid = yylval.fidval;
      lex_code = GetToken();
      header* obj;
      obj = yyparse(-1,current_ref_group->Parent(),TRUE);
      if (obj->Type() == NODE_OBJ) {
	obj = ((node*)obj)->Value();
      }
      op_level = oprate(lex_code = GetToken());
      obj = builtin_function(fid,obj);
      op_level = oprate(lex_code = GetToken());
      if (op_level == 0){
	if (lex_code != ENDSTR)
	  push_token(lex_code,&yylval);
	return obj;
      }else{
	return expression(obj,lex_code);
      }
    }
    if (lex_code == INTEGER) {
      int i_val = yylval.ival;
      op_next_level = oprate(lex_code = GetToken());
      if (op_next_level == 0) {
	if (lex_code != ENDSTR)
	  push_token(lex_code,&yylval);
	return compute(obj,op,create_integer(i_val));
      }else if(op_next_level > op_level){
	return compute(obj,op,expression(create_integer(i_val),lex_code));
      }else if(op_next_level == op_level){
	header* nobj ;
	nobj = compute(obj,op,create_integer(i_val));
	obj = nobj;
	op = lex_code;
      }else if(op_next_level < op_level){
	header* nobj;
	nobj = compute(obj,op,create_integer(i_val));
	op_level = op_next_level;
	op = lex_code;
      }
    }
    if (lex_code == BGNSTR) {
      header* nobj;
      nobj = yyparse(-1,current_ref_group->Parent(),TRUE);
      if(nobj->Type() == NODE_OBJ) {
	nobj = ((node*)nobj)->Value();
      }
      op_next_level = oprate(lex_code = GetToken());
      if(op_next_level == 0) {
	push_token(lex_code,&yylval);
	return nobj;
      }else if(op_next_level > op_level){
	expression(obj,lex_code);
      }else if(op_next_level == op_level){
	nobj = compute(obj,op,nobj);
	op = lex_code;
	obj = nobj;
      }else if(op_next_level < op_level){
	nobj = compute(obj,op,nobj);
	op_level = op_next_level;
	op = lex_code;
      }
    }
    if (lex_code == SYMBOL) {
      header* node_value = ((node*)np)->Value();
      if ((node_value->Type()) == GROUP_OBJ) {
	header* next_group;
	next_group = NextGroup(node_value,yylval.sval);
	if (next_group == (header*)0) {
	  error_msg_is_not_group(np);
	}
	op_next_level = oprate(lex_code = GetToken());
	if(op_next_level == 0) {
	  if (lex_code == SYMBOL) {
	    if (lex_code != ENDSTR)
	      push_token(lex_code,&yylval);
	    np = (node*)next_group;
	    continue;
	  }else{
	    header* nobj;
	    nobj = ((node*)next_group)->Value();
	    if (lex_code != ENDSTR)
	      push_token(lex_code,&yylval);
	    return compute(obj,op,nobj);
	  }
	}else{
	  header* nobj;
	  nobj = ((node*)next_group)->Value();
	  if(op_next_level > op_level){
	    return compute( obj,op,expression(nobj,lex_code));
	  }else if(op_next_level == op_level){
	    nobj = compute(obj,op,nobj);
	    obj = nobj;
	    op = lex_code;
	  }else if(op_next_level < op_level){
	    nobj = compute(obj,op,nobj);
	    op_level = op_next_level;
	    op = lex_code;
	  }
	}
      }
    }
    if (lex_code == FLOAT) {
      float f_val = yylval.fval;
      int op_next_level = oprate(lex_code = GetToken());
      if (op_next_level == 0) {
	if (lex_code != ENDSTR)
	  push_token(lex_code,&yylval);
	return compute(obj,op,create_float(f_val));
      }else if(op_next_level > op_level){
	return compute( obj,op,expression(create_float(f_val),lex_code));
      }else if(op_next_level == op_level){
	header* nobj ;
	nobj = compute(obj,op,create_float(f_val));
	op = lex_code;
	obj = nobj;
      }else if(op_next_level < op_level){
	header* nobj;
	nobj = compute(obj,op,create_float(f_val));
	op_level = op_next_level;
	op = lex_code;
      }
    }
  }
}

void get_list(cons* lp,header* np)
{
#ifdef DEBUG
  printf("void get_list(cons* %x,header* %x(",(unsigned int)lp,(unsigned int)np);
  np->Print();
  printf(")\n");
#endif
  int minus_flag;
  minus_flag = FALSE;
  int lex_code ;
  for(;;) {
    lex_code = GetToken();
    if(lex_code == TE) {
      fprintf(stderr,"Fatal :\n']' mismatch %d\n",line_number);
      error_exit();
    }
    if(lex_code == BGNLIST) {
      cons* wcp;
      wcp = new cons [1];
      get_list(wcp,current_ref_group->Parent());
      cons* dp;
      dp = wcp;
      if (wcp->Cdr() == (cons*)0) {
	lp->Cdr((cons*)0);
	return;
      }
      wcp = (cons*)wcp->Cdr();
      dp->Car(wcp);
      dp->Cdr((header*)0);
      lp->Cdr(dp);
      lp = (cons*)lp->Cdr();
      continue;
    }
    if(lex_code == COMMA) {
      if (np != current_ref_group->Parent()) {
	append_list(lp,((node*)np)->Value());
	lp = (cons*)lp->Cdr();
	np = current_ref_group->Parent();
      }
      continue;
    }
    if(lex_code == ENDLIST) {
      if (np != current_ref_group->Parent()) {
	append_list(lp,((node*)np)->Value());
      }
      return;
    }
    if(lex_code == INTEGER) {
      header* value;
      value = create_integer(yylval.ival);
      if (minus_flag) {
	value = minus(value);
	minus_flag = FALSE;
      }
      append_list(lp,value);
      lp = (cons*)lp->Cdr();
    }
    if(lex_code == FLOAT) {
      header* value;
      value = create_float(yylval.fval);
      if (minus_flag) {
	value = minus(value);
	minus_flag = FALSE;
      } 
      append_list(lp,value);
      lp = (cons*)lp->Cdr();
    }
    if(lex_code == MINUS) {
      minus_flag = TRUE;
    }
    if(lex_code == MEMBER) {
      np = object_member((((node*)np)->Value()),yylval.sval);
      if (np == (header*)0) {
	error_msg_is_not_member();
      }
      continue;
    }
    if(lex_code == SYMBOL) {
      header* node_value;
      node_value = ((node*)np)->Value();
      if (node_value == (header*)0) {
	fprintf(stderr,"Syntax Error :\n line %d:\n",line_number);
	error_exit();
      }else{
	np = NextGroup(node_value,yylval.sval);
	continue;
      }
    }
    if(lex_code == BGNARGS) {
      header* top;
      top = (header*)(new fixed_number[1]);
      ((fixed_number*)top)->Value(0);
      push_token(lex_code,&yylval);
      get_argment(0,(container*)top,current_ref_group->Parent());
      fixed_number* dp;
      dp = (fixed_number*)top;
      top = ((container*)top)->Next();
      if (arg_length((header*)top) == 3) {
	top = (container*)make_location((header*)top);
      }
      append_list(lp,top);
      lp = (cons*)lp->Cdr();
      continue;
    }
    if(lex_code == BGNSTR) {
      header* car;
      car = yyparse(-1,current_ref_group->Parent(),TRUE);
      cons* nc ;
      nc = new cons[1]; 
      nc->Car(car);
      lp->Cdr(nc);
      lp = (cons*)lp->Cdr();
      continue;
    }
  }
}

void get_argment(int o,container* wp,header* np)
{
#ifdef DEBUG
  printf("void get_argment(int %d,container* %x(",o,(unsigned int)wp);
  wp->Print();
  printf("),header* %x(%s))\n",(unsigned int)np,np->Name());
#endif
  int structerd = FALSE;
  int minus_flag = FALSE;
  int lex_code;
  int op_level = 0;
  for (;;){
    lex_code = GetToken();
    if(lex_code == BGNLIST) {
      cons* wcp;
      wcp = new cons [1];
      get_list(wcp,current_ref_group->Parent());
      cons* dp;
      dp = wcp;
      wcp = (cons*)wcp->Cdr();
      delete dp;
      wp->Next(wcp);
      wp = (container*)wp->Next();
      continue;
    }
    if(lex_code == BGNSTR) {
      header* obj;
      obj = yyparse(-1,current_ref_group->Parent(),TRUE);
      if(obj->Type() == NODE_OBJ) {
	obj = ((node*)obj)->Value();
      }
      op_level = oprate(lex_code = GetToken());
      if (op_level == 0){
	push_token(lex_code,&yylval);
	wp->Next(obj);
	wp = (container*)wp->Next();
	continue;
      }else{
	wp->Next(expression(obj,lex_code));
	ArgNext;
      }
    }else if (lex_code == INTEGER) {
      int i_val = yylval.ival;
      if (minus_flag) {
	i_val*=(-1);
	minus_flag = FALSE;
      }
      op_level = oprate(lex_code = GetToken());
      if (op_level == 0){
	push_token(lex_code,&yylval);
	wp->Next(create_integer(i_val));
      }else{
	wp->Next(expression(create_float(i_val),lex_code));
      }
      ArgNext;
    }else if (lex_code ==  MATH_FUNC) {
      FunctionID fid = yylval.fidval;
      lex_code = GetToken();
      header* obj;
      obj = yyparse(-1,current_ref_group->Parent(),TRUE);
      if (obj->Type() == NODE_OBJ) {
	obj = ((node*)obj)->Value();
      }
      op_level = oprate(lex_code = GetToken());
      obj = builtin_function(fid,obj);
      if (minus_flag) {
	obj = minus(obj);
      }
      op_level = oprate(lex_code = GetToken());
      if (op_level == 0){
	if (lex_code != ENDSTR)
	  push_token(lex_code,&yylval);
	wp->Next(obj);
      }else{
	wp->Next(expression(obj,lex_code));
      }
      ArgNext;
    }else if (lex_code ==  FLOAT) {
      float f_val;
      f_val = yylval.fval;
      if(minus_flag) {
	f_val*=(-1);
	minus_flag = FALSE;
      }
      op_level = oprate(lex_code = GetToken());
      if (op_level == 0){
	push_token(lex_code,&yylval);
	wp->Next(create_float(f_val));
      }else{
	wp->Next(expression(create_float(f_val),lex_code));
      }
      ArgNext;
    }else if ((lex_code == SWSYM) ||(lex_code == STRING)) {
      header* sp;
      sp = create_string(yylval.sval);
      sp->Split();
      wp ->Next(sp);
      ArgNext;
    }else if(lex_code == MINUS) {
      minus_flag = TRUE;
      continue;
    }else if (lex_code == BGNARGS) {
      structerd = TRUE;
    }else if (lex_code == ENDARGS) {
      wp->Next((header*)0);
      if (np != (current_ref_group->Parent())) {
	header* next;
	next = ((node*)np)->Value();
	((container*)next)->Next((header*)0);
	wp->Next(next);
      }
      return;
    }else if(lex_code == TE) {
      push_token(lex_code,&yylval);
      if (np != (current_ref_group->Parent())) {
	header* next;
	next = ((node*)np)->Value();
	((container*)next)->Next((header*)0);
	wp->Next(next);
	wp = (container*)next;
      }
      return;
    }else if(lex_code == NEW) {
      lex_code = GetToken();
      if(lex_code == OBJECT_TYPE) {
	wp->Next(make_instance(yylval.sval));
	wp = (container*)wp->Next();
	wp->Next((header*)0);
	return; 
      }else if ((lex_code == SYMBOL)||(lex_code == STRING)){
	fprintf(stderr,"%s\n",line_buffer);
	fprintf(stderr,"Syntax Error :\n %s No such class line %d\n",
		hash_table.idWord(yylval.sval),line_number);
	error_exit();
      }else{
	fprintf(stderr,"%s\n",line_buffer);
	fprintf(stderr,"Syntax Error :\n line number %d\n",line_number);
	error_exit();
      }
    }else if(lex_code ==  COMMA) {
      if (np != (current_ref_group->Parent())) {
	header* next;
	next = ((node*)np)->Value();
	if (minus_flag) {
	  minus_flag = FALSE;
	}
	((container*)next)->Next((header*)0);
	wp->Next(next);
	wp = (container*)next;
	np = current_ref_group->Parent();
      }
      continue;
    }else if (lex_code == MEMBER) {
      np = object_member((((node*)np)->Value()),yylval.sval);
      if (np == (header*)0) {
	error_msg_is_not_member();
      }
      op_level = oprate(lex_code = GetToken());
      if (op_level == 0) {
	push_token(lex_code,&yylval);
	continue;
      }else{
	header* obj;
	obj = ((node*)np)->Value();
	wp->Next(expression(obj,lex_code));
	if(structerd){
	  wp = (container*)wp->Next();
	  np = current_ref_group->Parent();
	  continue;
	}else{
	  return;
	}
      }
    }else if (lex_code == QS) {
      np = root_obj->Parent();
      continue;
    }else if (lex_code == SYMBOL) {
      header* node_value = ((node*)np)->Value();
      if ((node_value->Type()) == GROUP_OBJ) {
	header* next_group;
	next_group = NextGroup(node_value,yylval.sval);
	if (next_group == (header*)0) {
	  error_msg_is_not_group(np);
	}
	op_level = oprate(lex_code = GetToken());
	if(op_level == 0) {
	  push_token(lex_code,&yylval);
	  np = next_group;
	  continue;
	}else{
	  header* obj;
	  obj = ((node*)np)->Value();
	  wp->Next(expression(obj,lex_code));
	  if(structerd){
	    wp = (container*)wp->Next();
	    np = current_ref_group->Parent();
	    continue;
	  }else{
	    return;
	  }
	}
      }else{
	  error_msg_is_not_group(np);
      }
    }else { 
      fprintf(stderr,"%s\n",line_buffer);
      fprintf(stderr,"Syntax Error :\n line %d:\n",line_number);
      error_exit();
    }
  }
}

header* yyparse(int n,header *cn,int kflag)
/* header* cn : current node */
{
#ifdef DEBUG
  printf("header* yyparse(int %d,header* %x)\n",n,(unsigned int)cn);
#endif
  n++;
  container* top;
  int minus_flag = FALSE;
  int lex_code;
  int op_level = 0;
  for (;;) {
    lex_code = GetToken();
    if (lex_code == 0) return (header*)0;
    if (lex_code == TE) {
      if (kflag){
	fprintf(stderr,"%s\n",line_buffer);
	fprintf(stderr,"Syntax Error :\n')' mismatch %d\n",line_number);
	error_exit();
      }
      return cn;
    }
    int n_args = cn->Accept(lex_code,yylval.midval);
    if (n_args == 0) {
      cn = cn->Reduce(yylval.midval,(header*)0);
      continue;
    }else if (n_args > 0) {
      MethodID mid = yylval.midval;
      top = (container*)create_integer(0);
      get_argment(0,top,current_ref_group->Parent());
      container* dp;
      dp = top;
      top = (container*)top->Next();
      dp->Next((header*)0);
      dp->Close();
      if (top != (header*)0) {
	if (arg_length((header*)top) == 3) {
	  top = (container*)make_location((header*)top);
	}
	if (top->Type() == NODE_OBJ) {
	  top = (container*)((node*)top)->Value();
	}
      }
      cn = cn->Reduce(mid,top);
      continue;
    }else if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
      fprintf(stderr,"%s\n",line_buffer);
      fprintf(stderr,"Fatal:\n%s illiegal message %d\n",((node*)cn)->Name(),line_number);
      error_exit();
    }else if (lex_code == QS) {
      cn = root_obj->Parent();
      continue;
    }else if (lex_code == INTEGER) {
      header* obj;
      obj = create_integer(yylval.ival);
      if(minus_flag) {
	obj = minus(obj);
	minus_flag = FALSE;
      }
      op_level = oprate(lex_code = GetToken());
      if (op_level == 0){
	if (lex_code != ENDSTR)
	  push_token(lex_code,&yylval);
	return obj;
      }else{
	return expression(obj,lex_code);
      }
    }else if (lex_code == FLOAT) {
      header* obj;
      obj = create_float(yylval.fval);
      if(minus_flag) {
	obj = minus(obj);
	minus_flag = FALSE;
      }
      op_level = oprate(lex_code = GetToken());
      if (op_level == 0){
	if (lex_code != ENDSTR) 
	  push_token(lex_code,&yylval);
	return obj;
      }else{
	return expression(obj,lex_code);
      }
    }else if (lex_code == MATH_FUNC) {
      FunctionID fid = yylval.fidval;
      lex_code = GetToken();
      header* obj;
      obj = yyparse(-1,current_ref_group->Parent(),TRUE);
      if (obj->Type() == NODE_OBJ) {
	obj = ((node*)obj)->Value();
      }
      obj = builtin_function(fid,obj);
      if (minus_flag) {
	obj = minus(obj);
      }
      op_level = oprate(lex_code = GetToken());
      if (op_level == 0){
	if (lex_code != ENDSTR)
	  push_token(lex_code,&yylval);
	return obj;
      }else{
	return (expression(obj,lex_code));
      }
    }else if (lex_code == MINUS) {
      minus_flag = FALSE;
    }else if (lex_code == SYMBOL) {
      header* node_value = ((node*)cn)->Value();
      if (node_value == (header*)0){
	error_msg_is_not_group(cn);
      }else if ((node_value->Type()) == GROUP_OBJ) {
	header* next_group;
	next_group = NextGroup(node_value,yylval.sval);
	if (next_group == (header*)0) {
	  error_msg_is_not_group(cn);
	}
	cn = next_group;
	continue;
      } else { 
	error_msg_is_not_group(cn);
      }
    }else if (lex_code == MEMBER) {
      cn = object_member((((node*)cn)->Value()),yylval.sval);
      if (cn == (header*)0) {
	error_msg_is_not_member();
      }
      continue;
    }else if(lex_code == ENDFILE) {
      return cn;
    }else if (lex_code == ENDSTR) {
      if (!kflag) {
	fprintf(stderr,"Syntax Error :\n')' missmatch line %d\n",line_number);
	error_exit();
      }else {
	if (minus_flag) {
	  header* obj;
	  obj = ((node*)cn)->Value();
	  ObjectTypeTag type = obj->Type();
	  if ((type == DAT_INTEGER) ||(type == DAT_FLOAT)){
	    return minus(obj);
	  }
	}
	return cn;
      }
    }
  }
  return cn;
}

int yyparse()
{
  init_token_stack();
  header* dummy;
  dummy = yyparse(0,current_ref_group->Parent(),FALSE);
  return 0;
}
#endif/*_UN_USE_YACC_*/










