/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <math.h>
#include <gl/gl.h>
#include <string.h>
#include <gl/device.h>
#include "node.h"
#include "hash.h"
#include "group.h"
#include "cylinder.h"
#include "sphere.h"
#include "text.h"
#include "light.h"
#include "color_obj.h"
#include "panel.h"
#include "symbol.h"
#include "primitive.h"

extern "C" {
#include "ui.h"
};

#define SmallDial (3.0/5.0)
/*¦Υ礭Ψ(ɬ¿ɽ뤳) */

#define INPUT_LENGTH (33)
/*ʸϤκ*/

#define TEXT_ARRAY (10)
/*֥̾ΰǻȤʸơ֥礭*/

#define NODE_SELECT_SIZE (10)

#define SIZE_OF_PANEL_ITEM (30)
/*ѥͥʤκĿ*/

#define NO_OF_PANEL_ITEM (11)
/*ȥѥͥ򳫤ΥѥͥʤθĿ*/

#define BORDER_SIZE (4)
/*ʤȤ*/

#define BACKGROUND_COLOR  (0xaacdc9c9) 
/* Хå饦ɤο SNOW3*/
#define BORDER_COLOR (0xaa8b8989)
/* ܡ饤ο SNOW4*/

#define LIGHT_COLOR (0xaaeee9e9)
#define NORMAL_COLOR BACKGROUND_COLOR
#define DARK_COLOR BORDER_COLOR

#define D_LARGE_COLOR (0xff507fff)
/*¦Υο*/
#define D_SMALL_COLOR (0xfffd0f70)
/*¦Υο*/

#define BORDER_VALUE (10) 
#define SELECTWIDTH (300)


#ifndef _DISABLE_GL_
extern float rvec[4];
extern float trans[3];
extern long mainwin;
#endif
extern hash hash_table;
extern Matrix MatI;
extern void set_orth_graphic();
extern group* root_obj;
extern void make_name(char* str,node* np);

static long pwind;
static tty_str_buff[128];

/*ʤǻȤϥХåե*/
static char tty_str_buff_rot_x[INPUT_LENGTH];
static char tty_str_buff_rot_y[INPUT_LENGTH];
static char tty_str_buff_rot_z[INPUT_LENGTH];
static char tty_str_buff_loc_x[INPUT_LENGTH];
static char tty_str_buff_loc_y[INPUT_LENGTH];
static char tty_str_buff_loc_z[INPUT_LENGTH];
static char tty_str_buff_string[INPUT_LENGTH];
static char tty_str_buff_radius[INPUT_LENGTH];
static char tty_str_buff_depth[INPUT_LENGTH];
static char tty_str_buff_top[INPUT_LENGTH];
static char tty_str_buff_bottom[INPUT_LENGTH];
static char tty_str_buff_divide[INPUT_LENGTH];
static char tty_str_buff_height[INPUT_LENGTH];
static char tty_str_buff_scale[INPUT_LENGTH];
static char tty_str_buff_font[INPUT_LENGTH];
static char tty_str_buff_size[INPUT_LENGTH];

int items; /* ѥͥʤο */
int is_node_scroll_bar;
int cursor_x;
int cursor_y;
node* node_select[NODE_SELECT_SIZE];
int left_mouse_state;
Item item_table[SIZE_OF_PANEL_ITEM];
char *text_array[TEXT_ARRAY];
int char_letter;
int is_keybord_event;
group* current_group;
node* current_node;
group* save_group;
node* selected_node;
double save_scale;

Item* display_scale;
Item* hslider_scale;
Item* display_button;
Item* textwindow_child;
Item* selector_child;
Item* vslider_child;
Item* button_child;
Item* graphic_obj_rot_tty_x;
Item* graphic_obj_rot_tty_y;
Item* graphic_obj_rot_tty_z;
Item* graphic_obj_rot_dial_x;
Item* graphic_obj_rot_dial_y;
Item* graphic_obj_rot_dial_z;

/* ------------ class Item Member Function ------------------ */

/* ѥͥʤΥ饹ItemΥдؿǤ롣*/
/*
Υ饹Υǡϡ3ĤδؿΥݥ󥿤ġ

behavior ץꥱν
display ѥͥʤɽ
select  ѥͥʤưɬפ

*/

 Item::Item()
/* constructor */
{
  loc = Center;
}

void Item::TextArray(char** s)
/* ̾Υơ֥Υݥ󥿤ꤹ롣 */
{
  array = s;
}

char** Item::TextArray()
/* ̾Υơ֥Υݥ󥿤򻲾Ȥ롣 */
{
  return array;
}

void Item::Display(void (*u_func)(Item*))
/* ѥͥʤɽ롼Ԥʤ */
{
  display = u_func;
}

void Item::Display(Item* c)
/* ѥͥʤɽ롼εưԤʤ */
{
  (*display)(c);
}

void Item::Select(void (*u_func)(Item*))
/* ѥͥʤư롼Ԥʤ */
{
  select = u_func;
}

void Item::Select(Item* c)
/* ѥͥʤư롼ư롣 */
{
  (*select)(c);
}

void Item::Behavior(void (*u_func)(Item*))
/* ѥͥʤΥץꥱΥ롼Ԥʤ */
{
  behavior = u_func;
}

void Item::Behavior(Item* c)
/* ѥͥʤΥץꥱΥ롼εưԤʤ */
{
  (*behavior)(c);
}

float Item::Total()
/*饤ɥСξͤ򻲾Ȥ롣*/
{
  return total;
}

void Item::Total(float t)
/*饤ɥСξͤꤹ롣*/
{
  total = t;
}

float Item::Value()
/* 饤ɥСͤ򻲾Ȥ롣 */
{
  return value;
}

void Item::Value(float t)
/* 饤ɥСͤꤹ롣 */
{
  value = t;
}

int Item::NoOfSelect()
/*쥯ȥơ֥Υ֤*/
{
  return size;
}

void Item::NoOfSelect(int t)
/*쥯ȥơ֥Υꤹ롣*/
{
   size = t;
}

int Item::CurrentEntry()
/* ߥ뤬¸ߤݥȤΥǥå֤ */
{
  return current;
}

void Item::CurrentEntry(int t)
/* ߥ뤬¸ߤݥȤΥǥåꤹ롣 */
{
   current = t;
}
 
void Item::Location(StringLocation l)
/* ʸΰ(Left,Right,Center)ꤹ롣 */
{
 loc = l;
}

StringLocation Item::Location()
/* ʸΰ(Left,Right,Center)֤ */
{
  return loc;
}

char* Item::Text()
/* Ǽʸݥ󥿤֤ */
{
  return str;
}

void Item::Text(char* s)
{
  for (char* sp = str;*s != '\0';sp++,s++) {
    *sp = *s;
  }
  *sp = *s;
}

int Item::Xb()
{
  return x1;
}

int Item::Yb()
{
  return y1;
}

int Item::Xe()
{
  return x2;
}

int Item::Ye()
{
  return y2;
}
 
int Item::IsSelected(int x,int y)
{
  if ((x >= x1)&&(x <= x2)&&(y >= y1)&&(y <= y2)) {
    return TRUE;
  }
  return FALSE;
}

void Item::SetRect(int a,int b,int c,int d)
{
  if (b<d) {
    y1 = b;    y2 = d;
  }else {
    y1 = d;    y2 = b;
  }
  if (a<c) {
    x1 = a;    x2 = c;
  }else{
    x1 = c;    x2 = a;
  }
}

void Item::DialColor(long i)
/*γ¦οꤹ*/
{
  dial_color = i;
}

long Item::DialColor()
/*γ¦ο򻲾Ȥ*/
{
  return dial_color;
}

void Item::SmallDialColor(long i)
/*¦οꤹ*/
{
  sdial_color = i;
}

long Item::SmallDialColor()
/*¦ο򻲾Ȥ*/
{
  return sdial_color;
}

/* */

float f_cut (float v,float n)
/* ffloorŪ롼 */
/* nƤvnСΤޤ֤*/
/* n>vʤȤv֤ͤ */
{
  float w = v;
  for(;v>=n;v-=n){
    if (v == n) {
      return w;
    }
  }
  return (w-v);
}

float f_mod (float v,float n)
/* fmod׵˹פʤΤǴʰŪ˺ä롼 */
{
  for (;v >= n;v -= n){
    ;
  }
  return v;
}

void SelectJogDial(Item* item)
{
  if (left_mouse_state == UP) return;
  float xb = item->Xb();
  float xe = item->Xe();
  float yb = item->Yb();
  float ye = item->Ye();
  float x = (xb+xe)/2;
  float y = (yb+ye)/2;
  float radius = ((x-xb)<(y-yb)) ? (x-xb):(y-yb);
  float tradius = radius*SmallDial;
  float dx = cursor_x-x,dy = cursor_y-y;
  if ((fabs(dx) > radius)||(fabs(dy) > radius))
    return;
  float Theta;
  if (dx != 0) {
    float ypx = fabs(dy/dx);
    Theta = atan(ypx);
    if ((dx < 0) &&(dy >= 0)) {
      Theta = M_PI-Theta;
    }
    if ((dx < 0)&&(dy <0)){
      Theta += M_PI;
    }
    if ((dx > 0)&&(dy <0)){
      Theta = 2*M_PI-Theta;
    }
  }else{
    if(dy > 0){ 
      Theta = M_PI/2;
    }else if(dy < 0) {
      Theta = M_PI+M_PI/2;
    }else{
      Theta = 0;
    }
  }
  Theta = Theta *180/M_PI;
  if ((fabs(dx) <= tradius)&&(fabs(dy) <= tradius)) {
    float val_base = f_cut(item->Value(),10);
    if (Theta == 0) {
      float before = item->Total();
      if (before > 270) {
	/*žǤ*/
	item->Value(val_base+10);
      }else if(before > 0){
	/*žǤ*/
	if (item->Value() == 0) {
	  val_base = 360;
	}
	item->Value(val_base-10);
      }
    }else{
      /* 1ñ̤βž */
      if(val_base >= 360) val_base = 0;
      item->Value(val_base+(int)(Theta/36));
    }
    item->Total(Theta);
  }else{
    item->Value(Theta);
  }
  item->Behavior(item);
  item->Display(item);
}

void SelectVSlide(Item* item) 
/* Υ饤ɤ롼Ǥ롣ʤȤϡ */
/* Υ롼񤭴ɬפϤʤ */
{
  if ((left_mouse_state == UP)||(left_mouse_state == ANY)) return;
  int ye = item->Ye();
  int yb = item->Yb();
  float yt = item->Total();
  float yd = (float)(ye-yb);
  float yv = (float)(ye - cursor_y);
  item->Value((yv*yt)/yd);
  item->Behavior(item);
  item->Display(item);
}

void SelectHSlide(Item* item) 
/* Υ饤ɤ롼Ǥ롣ʤȤϡ */
/* Υ롼񤭴ɬפϤʤ */
{
  if ((left_mouse_state == UP)||(left_mouse_state == ANY)) return;
  int ye = item->Xe();
  int yb = item->Xb();
  float yt = item->Total();
  float yd = (float)(ye-yb);
  float yv = (float)(cursor_x - yb) ;
  item->Value((yv*yt)/yd);
  item->Behavior(item);
  item->Display(item);
}

void SelectTty(Item* item)
/* KeyϤʸХåե˽񤭹ࡣ */
/* Υ롼񴹤ɬפϤʤ*/
{
  if (!is_keybord_event) return;
  char* text_str = item->Text();
  int text_length = strlen(text_str);
  if (char_letter == 13) {
    /*ʸ*/
    item->Behavior(item);
    item->Display(item);
    return;
  }
  if (char_letter == 127) {
    /*DEL*/
    if (text_length > 0)
      text_str[text_length-1] = '\0';
  } else {
    text_str[text_length]   = char_letter;
    text_str[text_length+1] = '\0';
  }
} 

void SelectButton(Item* item) 
/* Хȥ󤬲줿νԤʤ */
/* Υ롼񴹤ɬפϤʤ*/
{
  if (left_mouse_state == DOWN) 
    item->Behavior(item);
  item->Display(item);
}

void DspJogDial(Item* item)
/*륪֥Ȥɽ롼Ǥ롣*/
/*ǥѤϤ񤭴롣*/
{
  float xb = item->Xb(), xe = item->Xe(), yb = item->Yb(),ye = item->Ye();
  float x = (xb+xe)/2;
  float y = (yb+ye)/2;
  float radius = ((x-xb)<(y-yb)) ? (x-xb):(y-yb);
  float tinyradius = radius*SmallDial;
  float VTheta = item->Value();
  float z = 0;
  float height = 1;
  float v[3];
  int divide = 15;
  int divide_cur = 3;
  float v2[2];
  cpack(0xfffff0f0);
  bgnline();
  v2[0] = xb; v2[1] = yb;v2f(v2);
  v2[0] = xb; v2[1] = ye;v2f(v2);
  v2[0] = xe; v2[1] = ye;v2f(v2);
  v2[0] = xe; v2[1] = yb;v2f(v2);
  v2[0] = xb; v2[1] = yb;v2f(v2);
  endline();
  translate(x,y,z);
  float DTheta = 2*M_PI/divide;
  float Theta = 0;
  int count;
  for (count = 0;count < divide;count++,Theta+=DTheta) {
    cpack(item->DialColor());
    bgntmesh();
    v[0] = 0; v[1] = 0;v[2] = height;v3f(v);
    v[0] = radius*cos(Theta); v[1] = radius*sin(Theta);v[2] = 0;v3f(v);
    v[0] = radius*cos(Theta+DTheta); v[1] = radius*sin(Theta+DTheta);v[2] = 0;v3f(v);
    endtmesh();
    cpack(item->SmallDialColor());
    bgntmesh();
    v[0] = 0; v[1] = 0;v[2] = height;v3f(v);
    v[0] = tinyradius*cos(Theta); v[1] = tinyradius*sin(Theta);v[2] = 0;v3f(v);
    v[0] = tinyradius*cos(Theta+DTheta); v[1] = tinyradius*sin(Theta+DTheta);v[2] = 0;v3f(v);
    endtmesh();
  }
  float Sv = f_mod (VTheta,10);
  float Lv = VTheta;
  Sv *= 36;
  translate(-x,-y,-z);
  cpack(0xfffff0f0);
  float tl, tradius, tx, ty ;
  tradius = radius/8;
  tl = (3*radius/4);
  tx = tl*cos(Lv*M_PI/180)+x;
  ty = tl*sin(Lv*M_PI/180)+y;
  translate(tx,ty,z);
  Theta = 0;
  for (count = 0;count < divide_cur;count++,Theta+=DTheta) {
    bgntmesh();
    v[0] = 0; v[1] = 0;v[2] = height;v3f(v);
    v[0] = tradius*cos(Theta); v[1] = tradius*sin(Theta);v[2] = 0;v3f(v);
    v[0] = tradius*cos(Theta+DTheta); v[1] = tradius*sin(Theta+DTheta);v[2] = 0;v3f(v);
    endtmesh();
  }
  translate(-tx,-ty,-z);
  tradius = tinyradius/5;
  tl = (3*tinyradius/4);
  tx = tl*cos(Sv*M_PI/180)+x;
  ty = tl*sin(Sv*M_PI/180)+y;
  translate(tx,ty,z);
  Theta = 0;
  for (count = 0;count < divide_cur;count++,Theta+=DTheta) {
    cpack(0xfffff0f0);
    bgntmesh();
    v[0] = 0; v[1] = 0;v[2] = height;v3f(v);
    v[0] = tradius*cos(Theta); v[1] = tradius*sin(Theta);v[2] = 0;v3f(v);
    v[0] = tradius*cos(Theta+DTheta); v[1] = tradius*sin(Theta+DTheta);v[2] = 0;v3f(v);
    endtmesh();
  }
  translate(-tx,-ty,-z);
  gflush();
}

void DspText(Item* item)
/*ʸԤʤ*/
{
  int xb = item->Xb(), yb = item->Yb(), xe = item->Xe(),ye = item->Ye();
  int lx = (xb+xe)/2-(strwidth(item->Text())/2);
  int ly = (yb+ye)/2-(getheight()/2);
  unsigned long txtcolor;
  txtcolor = 0xff000000;
  cmov2i(lx,ly);
  cpack(txtcolor);
  charstr(item->Text());
}

void DspButtonText(Item* item)
/*СɽԤʤ*/
{
  int xb = item->Xb(), yb = item->Yb(),xe = item->Xe(), ye = item->Ye();
  int height = getheight();
  int length = strwidth(item->Text());
  int lx = (xb+xe)/2-(length/2);
  int ly = (yb+ye)/2-(height/2);
  unsigned long txtcolor;
  txtcolor = 0xff000000;
  if (left_mouse_state == DOWN) {
    if ((item->IsSelected(cursor_x,cursor_y)) == TRUE) {
      txtcolor = 0xffffffff;
    }
  }
  cmov2i(lx,ly);
  cpack(txtcolor);
  charstr(item->Text());
}

void DspTextWindow(Item* item)
/*BoxդʸɽԤʤ*/
{
  long v[2];
  int c;
  int xe = (item->Xe())-BORDER_SIZE, xb = (item->Xb())+BORDER_SIZE ,ye = (item->Ye())-BORDER_SIZE, yb = (item->Yb())+BORDER_SIZE;
  for (c = BORDER_SIZE;c >-1;c--,xb--,xe++,ye++,yb--) {
    cpack (BORDER_COLOR);
    bgnline();
    v[0] = xb; v[1] = yb; v2i(v);
    v[1] = ye; v2i(v);
    v[0] = xe; v2i(v);
    endline();
    bgnline();
    v[0] = xb; v[1] = yb; v2i(v);
    v[0] = xe; v2i(v);
    v[1] = ye; v2i(v);
    endline();
  }
  if (strlen(item->Text()) >0) {
    int height = getheight();
    int length = strwidth(item->Text());
    int lx = (xb+xe)/2-(length/2);
    int ly = (yb+ye)/2-(height/2);
    StringLocation loc = item->Location();
    int m_width = strwidth("m");
    if (loc == Left) {
      cmov2i(xb+m_width,ly);
    }else if (loc == Center) {
      cmov2i(lx,ly);
    }else{
      cmov2i(xe-(length+m_width),ly);
    }
    cpack(0xff000000);
    charstr(item->Text());
  }
  gflush();
}

void DspVSlider(Item* item) 
/* Υ饤ɥСɽ롼Ǥ롣*/
{
  long v[2];
  int c;
  int xb = item->Xb(), yb = item->Yb(), xe = item->Xe(), ye = item->Ye();
  int height,h_height;
  float total = item->Total();
  float dy = (ye-yb-(2*BORDER_VALUE));
  float value = item->Value();
  float s_height = (BORDER_VALUE*dy)/total;
  if (BORDER_VALUE >total) {
    return;
  }
  float h_s_height = s_height/2;
  height = (int)s_height;
  h_height = height/2;
  float s_locate = ((float)ye-BORDER_VALUE) - (value*dy)/total;
  s_locate = ((ye - h_s_height) <= s_locate) ? (ye - h_s_height):s_locate;
  s_locate = ((yb + h_s_height) >= s_locate) ? (yb + h_s_height):s_locate;
  int locate ;
  locate = (int)s_locate;
  int ybottom = locate-h_height;
  int ytop = locate+h_height;
  cpack(NORMAL_COLOR);
  rectfi(xb+BORDER_SIZE,ybottom+BORDER_SIZE,xe-BORDER_SIZE,ytop-BORDER_SIZE);
  for (c = BORDER_SIZE;c < (BORDER_SIZE*2);c++) {
    cpack (LIGHT_COLOR);
    bgnline();
    v[0] = xb+c; v[1] = ybottom+c; v2i(v);
    v[1] = ytop-c; v2i(v);
    v[0] = xe-c; v2i(v);
    endline();
    cpack(DARK_COLOR);
    bgnline();
    v[0] = xb+c;  v[1] = ybottom+c;  v2i(v);
    v[0] = xe-c;  v2i(v);
    v[1] = ytop-c; v2i(v);
    endline();
  }
  gflush();
}

void DspHSlider(Item* item) 
/* Υ饤ɥСɽ롼Ǥ롣*/
{
  long v[2];
  int c;
  int xb = item->Xb()+BORDER_SIZE, yb = item->Yb()+BORDER_SIZE, xe = item->Xe()-BORDER_SIZE, ye = item->Ye()-BORDER_SIZE;
  int height,h_height;
  float total = item->Total();
  float dx = (xe-xb);
  float value = item->Value();
  float s_height = (BORDER_VALUE*dx)/total;
  if (BORDER_VALUE >total) {
    return;
  }
  float h_s_height = s_height/2;
  height = (int)s_height;
  h_height = height/2;
  float s_locate = ((float)xb) + (value*dx)/total;
  s_locate = ((xe - h_s_height) <= s_locate) ? (xe - h_s_height):s_locate;
  s_locate = ((xb + h_s_height) >= s_locate) ? (xb + h_s_height):s_locate;
  int locate ;
  locate = (int)s_locate;
  int xright = locate-(h_height-2*BORDER_SIZE);
  int xleft  = locate+h_height-BORDER_SIZE;
  cpack(NORMAL_COLOR);
  rectfi(xb,yb,xe,ye);
  for (c = BORDER_SIZE;c < (BORDER_SIZE*2);c++) {
    cpack (LIGHT_COLOR);
    bgnline();
    v[0] = xleft+c; v[1] = yb+c; v2i(v);
    v[1] = ye-c; v2i(v);
    v[0] = xright-c; v2i(v);
    endline();
    cpack(DARK_COLOR);
    bgnline();
    v[0] = xleft+c; v[1] = yb+c;  v2i(v);
    v[0] = xright-c; v2i(v);
    v[1] = ye-c;  v2i(v);
    endline();
  }
}

void SelectSelect(Item* item)
/*̾ΰǤ򤹤ܥåưԤʤ롼Ǥ롣*/
{
  int size = item->NoOfSelect();
  int ye = (item->Ye())-BORDER_SIZE, yb = (item->Yb())+BORDER_SIZE;
  int dy = ye-yb;
  int ddy = dy/(size);
  int current = (ye - cursor_y)/ddy;
  current = (current>= size) ? size-1:current;
  item->CurrentEntry(current);
  if (left_mouse_state == DOWN) {
    item->Behavior(item);
  }
  item->Display(item);
}

void DspSelect(Item* item)
/*̾ΰǤ򤹤ܥåɽԤʤ롼Ǥ롣*/
{
  long v[2];
  int size = item->NoOfSelect();
  char** array = item->TextArray();
  int xe = (item->Xe())-BORDER_SIZE, xb = (item->Xb())+BORDER_SIZE, ye = (item->Ye())-BORDER_SIZE, yb = (item->Yb())+BORDER_SIZE;
  int dy = ye-yb;
  int ddy = dy/(size);
  int current = item->CurrentEntry();
  int height = getheight()/2;
  int c;
  cpack (BORDER_COLOR);
  for (c = BORDER_SIZE;c >-1;c--) {
    bgnline();
    v[0] = xb-c; v[1] = yb-c; v2i(v);
    v[1] = ye+c; v2i(v);
    v[0] = xe+c; v2i(v);
    endline();
    bgnline();
    v[0] = xb-c; v[1] = yb-c;	v2i(v);
    v[0] = xe+c; v2i(v);
    v[1] = ye+c; v2i(v);
    endline();
  }
  cpack (0xffffaf7f);
  rectfi(xb,ye - ((current+1)*ddy),xe,ye - (current*ddy));
  cpack (0xff000000);
  for (c = 0;c < size;c++) {
    int ly;
    ly = ye-ddy*c;
    cmov2i(xb+3,ly-height-(ddy/2));
    charstr(array[c]);
  }
  gflush();
}

void DspBack(Item* item) 
/* 饤ɥСطʤ񤯡*/
{
  long v[2];
  int c;
  linewidth(1);
  int xb = item->Xb(), yb = item->Yb(), xe = item->Xe(), ye = item->Ye();
  unsigned long cp1,cp2,reccolor;
  reccolor = NORMAL_COLOR;
  if (left_mouse_state == DOWN) {
    if ((item->IsSelected(cursor_x,cursor_y)) == TRUE) {
      cp1 = DARK_COLOR;
      cp2 = LIGHT_COLOR;
    }
  }
  cpack(reccolor);
  xb -= 2;
  xe += 2;
  rectfi(xb,yb,xe,ye);
  for (c = 0;c < BORDER_SIZE;c++) {
    cpack(cp1);
    bgnline();
    v[0] = xb+c; v[1] = yb+c;	v2i(v);
    v[1] = ye-c; v2i(v);
    v[0] = xe-c; v2i(v);
    endline();
    cpack (cp2);
    bgnline();
    v[0] = xb+c; v[1] = yb+c; v2i(v);
    v[0] = xe-c; v2i(v);
    v[1] = ye-c; v2i(v);
    endline();
  }
}

void DspWhite(Item* item)
/* Ϳ줿WidgetΰΥꥢԤʤ*/
{
  int xb = item->Xb(), yb = item->Yb(), xe = item->Xe(), ye = item->Ye();
  cpack (0xffffffff);
  rectfi(xb,yb,xe,ye);
}

void SelectTextWindow(Item* item)
/*BoxĤǡֻǽ(Left,Right,Center)ʸWidget*/
/*ư롼Ǥ롣ץꥱ¸ǤϤʤ*/
{
  DspTextWindow(item);
}

void SelectText(Item* item)
/*BoxʤʸWidget*/
/*ư롼Ǥ롣ץꥱ¸ǤϤʤ*/
{
  DspText(item);
}

void DisplayTextWindow(Item* item)
/*BoxĤǡֻǽ(Left,Right,Center)ʸWidget*/
/*ɽ롼Ǥ롣ץꥱ¸ǤϤʤ*/
{
  DspWhite(item);
  DspTextWindow(item);
}

void DisplayText(Item* item)
/* ʸɽԤʤ */
{
  DspText(item);
}

void DisplaySelect(Item* item)
/*Select֥ȤɽκǾ̥롼*/
{
  DspWhite(item);
  DspSelect(item);
}

void DisplayVSlider(Item* item)
/*ĤΥ饤ɥСɽκǾ̥롼*/
{
  DspBack(item);
  DspVSlider(item);
}

void DisplayHSlider(Item* item)
/*Υ饤ɥСɽκǾ̥롼*/
{
  DspBack(item);
  DspHSlider(item);
}

void DisplayButton(Item* item)
/* Buttonɽ롼 */
{
   DspBack(item);
   DspButtonText(item);
}

void behavior_sample_button(Item* item) 
/* ץꥱν롼 */
/* ǤϿƥ롼פ̾ΥСνԤʤäƤ롣 */
{
  if (current_group != root_obj){
    char str[80];
    node* np;
    np = (node*)(current_group->Parent());
    current_group = (group*)np->Parent();
    np = (node*)(current_group->Parent());
    make_name(str,np);
    item->Text(str);
    current_node = (node*)current_group->First();
    np = current_node;
    int c;
    for (c = 0;c < TEXT_ARRAY;c++) {
      if (np == (node*)0) break;
      header* wp;
      wp = np->Value();
      node_select[c] = np;
      make_name(&text_array[c][0],np);
      np = (node*)np->Next();
    }
    selector_child->CurrentEntry(0);
    selector_child->NoOfSelect(c);
    vslider_child->Total((current_group->NoOfObjects()));
    vslider_child->Value(0);
  }
}

void behavior_scale_value_text_window(Item* item) 
/**/
{
}
void behavior_sample_tty_window(Item* item) 
/**/
{
  if (!is_keybord_event) return;
  if (char_letter != 13) return;
  char* text_str = item->Text();
  char name[128];
  if (selected_node != (node*)0) {
    make_name(name,selected_node);
    printf("%s %s\n",name,text_str);
  }else{
    printf(": %s\n",text_str);
  }
  fflush(stdout);
  text_str[0] = '\0';
}

void behavior_sample_text_window(Item* item) 
/**/
{
}

void behavior_scale_vslider(Item* item) 
/**/
{
  if (selected_node != (node*)0) {
    header* obj;
    obj = selected_node->Value();
    if(obj != (header*)0) {
      float scale = (item->Value())/10;
      ((object*)obj)->Scale((double)scale);
      sprintf(display_scale->Text(),"%6.3f",scale);
    }
  }
}

void behavior_sample_vslider(Item* item) 
{
  float value = item->Value();
  int objects = current_group->NoOfObjects();
  int start = (value > (objects-TEXT_ARRAY)) ? (objects-TEXT_ARRAY):(int)value;
  start = (start <0) ? 0:start;
  int c;
  current_node = (node*)current_group->First();
  for (c = 0;c<start;c++) {
    current_node = (node*)current_node->Next();
  }
  node* np;
  np = current_node;
  for (c = 0;c < TEXT_ARRAY;c++) {
    if (np == (node*)0) break;
    header* wp;
    wp = np->Value();
    node_select[c] = np;
    sprintf(text_array[c],"%s",np->Name());
    //make_name(&text_array[c][0],np);
    np = (node*)np->Next();
  }
}

void behavior_sample_scale_window(Item* item) 
{
  double value = atof(item->Text());
  double max = hslider_scale->Total()/10;
  if (max < value){
    hslider_scale->Total(value*10);
  }
  hslider_scale->Value(value*10);
  sprintf(item->Text(),"%6.3f",value);
  if (selected_node != (node*)0) {
    header* obj;
    obj = selected_node->Value();
    if(obj != (header*)0) {
      ((object*)obj)->Scale((double)value);
    }
  }
}

void behavior_rot_x_rotation(Item* item) 
/*JogDialϤФ᥽å*/
/*ʸˤϤBoxƤιԤʤ*/
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  location* rot;
  rot = (location*)((object*)node_value)->Rotate();
  double val = item->Value();
  sprintf(graphic_obj_rot_tty_x->Text(),"%8.3f",val);
  rot->X(val);
}
void behavior_rot_y_rotation(Item* item) 
/*JogDialϤФ᥽å*/
/*ʸˤϤBoxƤιԤʤ*/
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  location* rot;
  rot = (location*)((object*)node_value)->Rotate();
  double val = item->Value();
  sprintf(graphic_obj_rot_tty_y->Text(),"%8.3f",val);
  rot->Y(val);
}
void behavior_rot_z_rotation(Item* item) 
/*JogDialϤФ᥽å*/
/*ʸˤϤBoxƤιԤʤ*/
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  location* rot;
  rot = (location*)((object*)node_value)->Rotate();
  double val = item->Value();
  sprintf(graphic_obj_rot_tty_z->Text(),"%8.3f",val);
  rot->Z(val);
}
void behavior_input_x_rotation(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  location* rot;
  rot = (location*)((object*)node_value)->Rotate();
  double val = atof(item->Text());
  graphic_obj_rot_dial_x->Value(val);
  rot->X(val);
}

void behavior_input_y_rotation(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  location* rot;
  rot = (location*)((object*)node_value)->Rotate();
  double val = atof(item->Text());
  graphic_obj_rot_dial_y->Value(val);
  rot->Y(val);
}

void behavior_input_z_rotation(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  location* rot;
  rot = (location*)((object*)node_value)->Rotate();
  double val = atof(item->Text());
  graphic_obj_rot_dial_z->Value(val);
  rot->Z(val);
}

void behavior_input_x_location(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  location* loc;
  loc = (location*)((object*)node_value)->Location();
  double val = atof(item->Text());
  loc->X(val);
  if (node_value->Type() == LIGHT_OBJ) {
#ifndef _DISABLE_GL_
    winset(mainwin);
#endif
    ((light*)node_value)->Bind();
    winset(pwind);
  }
}

void behavior_input_y_location(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  location* loc;
  loc = (location*)((object*)node_value)->Location();
  double val = atof(item->Text());
  loc->Y(val);
  if (node_value->Type() == LIGHT_OBJ) {
#ifndef _DISABLE_GL_
    winset(mainwin);
#endif
    ((light*)node_value)->Bind();
    winset(pwind);
  }
}

void behavior_input_z_location(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  location* loc;
  loc = (location*)((object*)node_value)->Location();
  double val = atof(item->Text());
  loc->Z(val);
  if (node_value->Type() == LIGHT_OBJ) {
#ifndef _DISABLE_GL_
    winset(mainwin);
#endif
    ((light*)node_value)->Bind();
    winset(pwind);
  }
}

void behavior_input_red(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  double val = atof(item->Text());
  if (node_value->Type() == LIGHT_OBJ) {
#ifndef _DISABLE_GL_
    winset(mainwin);
#endif
    ((light*)node_value)->Red(val);
    ((light*)node_value)->Bind();
    winset(pwind);
  }else{
#ifndef _DISABLE_GL_
    winset(mainwin);
#endif
    ((material*)node_value)->Red(val);
    ((material*)node_value)->Bind();
    winset(pwind);
  }
}

void behavior_input_green(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  double val = atof(item->Text());
  if (node_value->Type() == LIGHT_OBJ) {
#ifndef _DISABLE_GL_
    winset(mainwin);
#endif
    ((light*)node_value)->Green(val);
    ((light*)node_value)->Bind();
    winset(pwind);
  }else{
#ifndef _DISABLE_GL_
    winset(mainwin);
#endif
    ((material*)node_value)->Green(val);
    ((material*)node_value)->Bind();
    winset(pwind);
  }
}

void behavior_input_blue(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  double val = atof(item->Text());
  if (node_value->Type() == LIGHT_OBJ) {
#ifndef _DISABLE_GL_
    winset(mainwin);
#endif
    ((light*)node_value)->Blue(val);
    ((light*)node_value)->Bind();
    winset(pwind);
  }else{
#ifndef _DISABLE_GL_
    winset(mainwin);
#endif
    ((material*)node_value)->Blue(val);
    ((material*)node_value)->Bind();
    winset(pwind);
  }
}

void behavior_input_sred(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  double val = atof(item->Text());
#ifndef _DISABLE_GL_
  winset(mainwin);
#endif
  ((material*)node_value)->SRed(val);
  ((material*)node_value)->Bind();
  winset(pwind);
}

void behavior_input_sgreen(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  double val = atof(item->Text());
#ifndef _DISABLE_GL_
  winset(mainwin);
#endif
  ((material*)node_value)->SGreen(val);
  ((material*)node_value)->Bind();
  winset(pwind);
}

void behavior_input_sblue(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  double val = atof(item->Text());
#ifndef _DISABLE_GL_
  winset(mainwin);
#endif
  ((material*)node_value)->SBlue(val);
  ((material*)node_value)->Bind();
  winset(pwind);
}

void behavior_input_alpha(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  double val = atof(item->Text());
#ifndef _DISABLE_GL_
  winset(mainwin);
#endif
  ((material*)node_value)->Alpha(val);
  ((material*)node_value)->Bind();
  winset(pwind);
}

void behavior_input_shine(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  double val = atof(item->Text());
#ifndef _DISABLE_GL_
  winset(mainwin);
#endif
  ((material*)node_value)->Shiness(val);
  ((material*)node_value)->Bind();
  winset(pwind);
}

void behavior_input_integer(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  fixed_number* fnum;
  fnum = (fixed_number*)node_value;
  int val = atoi(item->Text());
  fnum->Value(val);
}

void behavior_input_float(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  float_number* fnum;
  fnum = (float_number*)node_value;
  float val = atof(item->Text());
  fnum->Value(val);
}

void behavior_input_string(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  string* vstr;
  vstr = (string*)node_value;
  int  val = hash_table.wordId(item->Text());
  vstr->Id(val);
}

void behavior_input_smooth(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  graphic_primitive* gpr;
  gpr = (graphic_primitive*)node_value;
  int sw = hash_table.wordId(item->Text());
  if (sw == sym_param_on) {
    item->Text("off");
    gpr->SmoothState("off");
  }else{
    item->Text("on");
    gpr->SmoothState("on");
  }
}

void behavior_input_alias(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  graphic_primitive* gpr;
  gpr = (graphic_primitive*)node_value;
  int sw = hash_table.wordId(item->Text());
  if (sw == sym_param_on) {
    item->Text("off");
    gpr->AliasState("off");
  }else{
    item->Text("on");
    gpr->AliasState("on");
  }
}

void behavior_input_nurbs(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  int sw = hash_table.wordId(item->Text());
  if (node_value->Type() == PR_LINE) {
    line* gpr;
    gpr = (line*)node_value;
    if (sw == sym_param_on) {
      item->Text("off");
      gpr->Nurbs("off");
    }else{
      item->Text("on");
      gpr->Nurbs("on");
    }
  }else {
    mesh* gpr;
    gpr = (mesh*)node_value;
    if (sw == sym_param_on) {
      item->Text("off");
      gpr->Nurbs("off");
    }else{
      item->Text("on");
      gpr->Nurbs("on");
    }
  }
}

void behavior_input_text_string(Item* item) 
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  header* member;
  member = ((text*)node_value)->Reference(sym_om_string);
  string* str;
  str = (string*)((node*)member)->Value();
  str->Id(hash_table.wordId(item->Text()));
}

void behavior_input_top(Item* item) 
{
  header* node_value;
  header* member;
  node_value = selected_node->Value();
  member = ((cylinder*)node_value)->Reference(sym_om_top);
  header* value;
  value  = ((node*)member)->Value();
  if (value->Type() == DAT_INTEGER) {
    ((fixed_number*)value)->Value(atoi(item->Text()));
  }else{
    ((float_number*)value)->Value(atof(item->Text()));
  }
}

void behavior_input_bottom(Item* item) 
{
  header* node_value;
  header* member;
  node_value = selected_node->Value();
  member = ((cylinder*)node_value)->Reference(sym_om_bottom);
  header* value;
  value  = ((node*)member)->Value();
  if (value->Type() == DAT_INTEGER) {
    int bottom  = atoi(item->Text());
    sprintf(item->Text(),"%d",bottom);
    ((fixed_number*)value)->Value(bottom);
  }else{
    float bottom  = atof(item->Text());
    sprintf(item->Text(),"%f",bottom);
    ((float_number*)value)->Value(bottom);
  }
}

void behavior_input_height(Item* item) 
{
  header* node_value;
  header* member;
  node_value = selected_node->Value();
  member = ((cylinder*)node_value)->Reference(sym_om_height);
  header* value;
  value  = ((node*)member)->Value();
  if (value->Type() == DAT_INTEGER) {
    int height  = atoi(item->Text());
    sprintf(item->Text(),"%d",height);
    ((fixed_number*)value)->Value(height);
  }else{
    float height  = atof(item->Text());
    sprintf(item->Text(),"%f",height);
    ((float_number*)value)->Value(height);
  }
}

void behavior_input_divide(Item* item) 
{
  header* node_value;
  header* member;
  node_value = selected_node->Value();
  member = ((cylinder*)node_value)->Reference(sym_om_division);
  fixed_number* value;
  value  = (fixed_number*)((node*)member)->Value();
  int divide_value = atoi(item->Text());
  sprintf(item->Text(),"%d",divide_value);
  ((fixed_number*)value)->Value(divide_value);
}

void behavior_input_radius(Item* item)
{
  header* node_value = selected_node->Value();
  if (node_value == NULL) return;
  header* member =       ((sphere*)node_value)->Reference(sym_om_radius);
  header* radius_value = ((node*)member)->Value();
  if (radius_value->Type() == DAT_INTEGER) {
    fixed_number* radius;
    radius = (fixed_number*)radius_value;
    radius->Value(atoi(item->Text()));
  }else{
    float_number* radius;
    radius = (float_number*)radius_value;
    radius->Value(atof(item->Text()));
  }
}

void behavior_input_depth(Item* item)
/*sphere ֥ȤdepthѤ롣*/
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  header* member;
  member = ((sphere*)node_value)->Reference(sym_om_depth);
  fixed_number* depth;
  depth = (fixed_number*)((node*)member)->Value();
  int depth_value = atoi(item->Text());
  if (depth_value > 30) {
    depth_value = 30;
    sprintf(item->Text(),"%d",depth_value);
    item->Display(item);
  }
  depth->Value(depth_value);
}

void behavior_input_font(Item* item)
/*text ֥ȤΥեȤѤ롣*/
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  header* member;
  member = ((sphere*)node_value)->Reference(sym_om_font);
  string* font;
  font = (string*)((node*)member)->Value();
  int id = hash_table.wordId(item->Text());
  font->Id(id);
}

void behavior_input_size(Item* item)
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  header* member;
  member = ((sphere*)node_value)->Reference(sym_om_size);
  header* mem_value = ((node*)member)->Value();
  if (mem_value->Type() == DAT_INTEGER) {
    fixed_number* size;
    size = (fixed_number*)mem_value;
    int size_value = atoi(item->Text());
    sprintf(item->Text(),"%d",size_value);
    item->Display(item);
    size->Value(size_value);
  }else{
    float_number* size;
    size = (float_number*)mem_value;
    float size_value = atof(item->Text());
    sprintf(item->Text(),"%8.3f",size_value);
    item->Display(item);
    size->Value(size_value);
  }
}

void initialize_input_text_window(Item* item)
{
  item->Display(DisplayTextWindow);
  item->Select(SelectTty);
  item->Location(Left);
}

void initialize_text_window(Item* item)
{
  item->Display(DisplayText);
  item->Select(SelectText);
  item->Behavior(behavior_sample_text_window);
}


void initialize_jog_dial(Item* item)
{
  item->DialColor(D_LARGE_COLOR);
  item->SmallDialColor(D_SMALL_COLOR);
  item->Display(DspJogDial);
  item->Select(SelectJogDial);
}
void make_input_text_object_wiget()
{
  header* node_value;
  header* member;
  int y_loc = 190,height = 30,x_len = 70;
  node_value = selected_node->Value();
  member = ((text*)node_value)->Reference(sym_om_string);
  if (node_value == (header*)0) return;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(360,y_loc,420,y_loc+height);
  item_table[items].Text((char*)"String");
  items++;
  string* str;
  tty_str_buff_string[0] = '\0';
  str = (string*)((node*)member)->Value();
  sprintf(tty_str_buff_string,"%s",((string*)str)->Value());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(420,y_loc,660,y_loc+height);
  item_table[items].Behavior(behavior_input_text_string);
  item_table[items].Text(tty_str_buff_string);
  items++;
  y_loc -= 40;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(360,y_loc,420,y_loc+height);
  item_table[items].Text((char*)"Font");
  items++;
  member = ((text*)node_value)->Reference(sym_om_font);
  str = (string*)((node*)member)->Value();
  sprintf(tty_str_buff_font,"%s",((string*)str)->Value());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(420,y_loc,660,y_loc+height);
  item_table[items].Behavior(behavior_input_font);
  item_table[items].Text(tty_str_buff_font);
  items++;
  y_loc -= 40;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(360,y_loc,420,y_loc+height);
  item_table[items].Text((char*)"Size");
  items++;
  member = ((text*)node_value)->Reference(sym_om_size);
  header* size;
  size = ((node*)member)->Value();
  if (size->Type() == DAT_INTEGER){
    sprintf(tty_str_buff_size,"%d",((fixed_number*)size)->Value());
  }else{
    sprintf(tty_str_buff_size,"%f",((float_number*)size)->Value());
  }
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(420,y_loc,420+x_len,y_loc+height);
  item_table[items].Behavior(behavior_input_size);
  item_table[items].Text(tty_str_buff_size);
  items++;
}

void make_input_cylinder_object_wiget()
{
  header* node_value;
  header* member;
  node_value = selected_node->Value();
  int y_loc = 190,height = 30;
  header* value;
  member = ((cylinder*)node_value)->Reference(sym_om_top);
  value = ((node*)member)->Value();
  initialize_text_window(item_table+items);
  item_table[items].SetRect(360,y_loc,420,y_loc+height);
  item_table[items].Text((char*)"Top");
  items++;
  if (value->Type() == DAT_INTEGER) {
    sprintf(tty_str_buff_top,"%d",((fixed_number*)value)->Value());
  }else{
    sprintf(tty_str_buff_top,"%f",((float_number*)value)->Value());
  }
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(420,y_loc,510,y_loc+height);
  item_table[items].Behavior(behavior_input_top);
  item_table[items].Text(tty_str_buff_top);
  items++;

  member = ((cylinder*)node_value)->Reference(sym_om_bottom);
  value = ((node*)member)->Value();
  initialize_text_window(item_table+items);
  item_table[items].SetRect(520,y_loc,580,y_loc+height);
  item_table[items].Text((char*)"Bottom");
  items++;
  if (value->Type() == DAT_INTEGER) {
    sprintf(tty_str_buff_bottom,"%d",((fixed_number*)value)->Value());
  }else{
    sprintf(tty_str_buff_bottom,"%f",((float_number*)value)->Value());
  }
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(590,y_loc,680,y_loc+height);
  item_table[items].Behavior(behavior_input_bottom);
  item_table[items].Text(tty_str_buff_bottom);
  items++;
  y_loc -= 40;
  member = ((cylinder*)node_value)->Reference(sym_om_height);
  value = ((node*)member)->Value();
  initialize_text_window(item_table+items);
  item_table[items].SetRect(360,y_loc,420,y_loc+height);
  item_table[items].Text((char*)"Height");
  items++;
  if (value->Type() == DAT_INTEGER){
    sprintf(tty_str_buff_height,"%d",((fixed_number*)value)->Value());
  }else{
    sprintf(tty_str_buff_height,"%f",((float_number*)value)->Value());
  }
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(420,y_loc,510,y_loc+height);
  item_table[items].Behavior(behavior_input_height);
  item_table[items].Text(tty_str_buff_height);
  items++;
  
  member = ((cylinder*)node_value)->Reference(sym_om_division);
  value = ((node*)member)->Value();
  initialize_text_window(item_table+items);
  item_table[items].SetRect(520,y_loc,580,y_loc+height);
  item_table[items].Text((char*)"Divide");
  items++;
  sprintf(tty_str_buff_divide,"%d",((fixed_number*)value)->Value());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(590,y_loc,680,y_loc+height);
  item_table[items].Behavior(behavior_input_divide);
  item_table[items].Text(tty_str_buff_divide);
  items++;
}

void make_input_conic_object_wiget()
{
  header* node_value;
  header* value;
  header* member;
  int y_loc = 190,height = 30;
  node_value = selected_node->Value();
  member = ((cylinder*)node_value)->Reference(sym_om_bottom);
  value = ((node*)member)->Value();
  initialize_text_window(item_table+items);
  item_table[items].SetRect(360,y_loc,420,y_loc+height);
  item_table[items].Text((char*)"Bottom");
  items++;
  if (value->Type() == DAT_INTEGER) {
    sprintf(tty_str_buff_bottom,"%d",((fixed_number*)value)->Value());
  }else{
    sprintf(tty_str_buff_bottom,"%f",((float_number*)value)->Value());
  }
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(430,y_loc,510,y_loc+height);
  item_table[items].Behavior(behavior_input_bottom);
  item_table[items].Text(tty_str_buff_bottom);
  items++;

  member = ((cylinder*)node_value)->Reference(sym_om_height);
  value = ((node*)member)->Value();
  initialize_text_window(item_table+items);
  item_table[items].SetRect(520,y_loc,580,y_loc+height);
  item_table[items].Text((char*)"Height");
  items++;
  if (value->Type() == DAT_INTEGER){
    sprintf(tty_str_buff_height,"%d",((fixed_number*)value)->Value());
  }else{
    sprintf(tty_str_buff_height,"%f",((float_number*)value)->Value());
  }
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(590,y_loc,680,y_loc+height);
  item_table[items].Behavior(behavior_input_height);
  item_table[items].Text(tty_str_buff_height);
  items++;
  y_loc -= 40;
  member = ((cylinder*)node_value)->Reference(sym_om_division);
  value = ((node*)member)->Value();
  initialize_text_window(item_table+items);
  item_table[items].SetRect(360,y_loc,420,y_loc+height);
  item_table[items].Text((char*)"Divide");
  items++;
  sprintf(tty_str_buff_divide,"%d",((fixed_number*)value)->Value());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(430,y_loc,510,y_loc+height);
  item_table[items].Behavior(behavior_input_divide);
  item_table[items].Text(tty_str_buff_divide);
  items++;
}

void make_input_pyramid_object_wiget()
{
  header* node_value;
  header* member;
  header* value;
  int y_loc = 190,height = 30;
  node_value = selected_node->Value();
  member = ((cylinder*)node_value)->Reference(sym_om_bottom);
  value = ((node*)member)->Value();
  initialize_text_window(item_table+items);
  item_table[items].SetRect(360,y_loc,420,y_loc+height);
  item_table[items].Text((char*)"Bottom");
  items++;
  if (value->Type() == DAT_INTEGER) {
    sprintf(tty_str_buff_bottom,"%d",((fixed_number*)value)->Value());
  }else{
    sprintf(tty_str_buff_bottom,"%f",((float_number*)value)->Value());
  }
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(430,y_loc,510,y_loc+height);
  item_table[items].Behavior(behavior_input_bottom);
  item_table[items].Text(tty_str_buff_bottom);
  items++;
  member = ((cylinder*)node_value)->Reference(sym_om_height);
  value = ((node*)member)->Value();
  initialize_text_window(item_table+items);
  item_table[items].SetRect(520,y_loc,580,y_loc+height);
  item_table[items].Text((char*)"Height");
  items++;
  if (value->Type() == DAT_INTEGER){
    sprintf(tty_str_buff_height,"%d",((fixed_number*)value)->Value());
  }else{
    sprintf(tty_str_buff_height,"%f",((float_number*)value)->Value());
  }
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(590,y_loc,680,y_loc+height);
  item_table[items].Behavior(behavior_input_height);
  item_table[items].Text(tty_str_buff_height);
  items++;
}

void make_input_sphere_object_wiget()
{
  header* node_value = selected_node->Value();
  if (node_value == NULL) return;
  int y_loc = 190,height = 30;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(360,y_loc,420,y_loc+height);
  item_table[items].Text((char*)"Radius");
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(520,y_loc,590,y_loc+height);
  item_table[items].Text((char*)"Depth");
  items++;
  tty_str_buff_depth[0] = '\0';
  tty_str_buff_radius[0] = '\0';
  header* member = ((sphere*)node_value)->Reference(sym_om_radius);
  header* radius = ((node*)member)->Value();
  member = ((sphere*)node_value)->Reference(sym_om_depth);
  header* depth = ((node*)member)->Value();
  if (radius->Type() == DAT_INTEGER) {
    sprintf(tty_str_buff_radius,"%d",((fixed_number*)radius)->Value());
  }else{
    sprintf(tty_str_buff_radius,"%f",((float_number*)radius)->Value());
  }
  sprintf(tty_str_buff_depth,"%d",((fixed_number*)depth)->Value());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(420,y_loc,510,y_loc+height);
  item_table[items].Behavior(behavior_input_radius);
  item_table[items].Text(tty_str_buff_radius);
  items++;
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(600,y_loc,690,y_loc+height);
  item_table[items].Behavior(behavior_input_depth);
  item_table[items].Text(tty_str_buff_depth);
  items++;
}

void make_string_object_wiget()
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  tty_str_buff_loc_x[0] = '\0';
  sprintf(tty_str_buff_loc_x,"%s",((string*)node_value)->Value());
  int x_loc = 420, x_len = 180;
  int y_loc = 340,height = 30;
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,y_loc,x_loc+x_len,y_loc+height);
  item_table[items].Behavior(behavior_input_string);
  item_table[items].Text((char*)tty_str_buff_loc_x);
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,y_loc,390,y_loc+height);
  item_table[items].Text((char*)"String");
  items++;
}

void make_float_object_wiget()
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  tty_str_buff_loc_x[0] = '\0';
  sprintf(tty_str_buff_loc_x,"%g",((float_number*)node_value)->Value());
  int x_loc = 420,x_len = 90;
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_float);
  item_table[items].Text((char*)tty_str_buff_loc_x);
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,340,390,370);
  item_table[items].Text((char*)"Float");
  items++;
}

void make_integer_object_wiget()
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  tty_str_buff_loc_x[0] = '\0';
  sprintf(tty_str_buff_loc_x,"%d",((fixed_number*)node_value)->Value());
  int x_loc = 420, x_len = 90;
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_integer);
  item_table[items].Text((char*)tty_str_buff_loc_x);
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,340,390,370);
  item_table[items].Text((char*)"Integer");
  items++;
}

void make_location_object_wiget()
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  tty_str_buff_loc_x[0] = '\0'; tty_str_buff_loc_y[0] = '\0'; tty_str_buff_loc_z[0] = '\0';
  location* loc;
  loc = (location*)node_value;
  int x_loc = 420, x_len = 90, x_bet = 5;
  sprintf(tty_str_buff_loc_x,"%g",loc->X());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_x_location);
  item_table[items].Text((char*)tty_str_buff_loc_x);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_loc_y,"%g",loc->Y());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_y_location);
  item_table[items].Text((char*)tty_str_buff_loc_y);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_loc_z,"%g",loc->Z());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_z_location);
  item_table[items].Text((char*)tty_str_buff_loc_z);
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,340,390,370);
  item_table[items].Text((char*)"3D-arg");
  items++;
}


void make_light_object_wiget()
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  tty_str_buff_loc_x[0] = '\0'; tty_str_buff_loc_y[0] = '\0'; tty_str_buff_loc_z[0] = '\0';
  tty_str_buff_rot_x[0] = '\0'; tty_str_buff_rot_y[0] = '\0'; tty_str_buff_rot_z[0] = '\0';
  location* loc;
  location* rot;
  loc = (location*)((object*)node_value)->Location();
  rot = (location*)((object*)node_value)->Rotate();
  int x_loc = 420, x_len = 90, x_bet = 5;
  sprintf(tty_str_buff_loc_x,"%g",loc->X());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_x_location);
  item_table[items].Text((char*)tty_str_buff_loc_x);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_loc_y,"%g",loc->Y());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_y_location);
  item_table[items].Text((char*)tty_str_buff_loc_y);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_loc_z,"%g",loc->Z());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_z_location);
  item_table[items].Text((char*)tty_str_buff_loc_z);
  items++;
  x_loc = 420;
  sprintf(tty_str_buff_rot_x,"%g",((light*)node_value)->Red());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,300,x_loc+x_len,330);
  item_table[items].Behavior(behavior_input_red);
  item_table[items].Text((char*)tty_str_buff_rot_x);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_rot_y,"%g",((light*)node_value)->Green());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,300,x_loc+x_len,330);
  item_table[items].Behavior(behavior_input_green);
  item_table[items].Text((char*)tty_str_buff_rot_y);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_rot_z,"%g",((light*)node_value)->Blue());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,300,x_loc+x_len,330);
  item_table[items].Behavior(behavior_input_blue);
  item_table[items].Text((char*)tty_str_buff_rot_z);
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,340,390,370);
  item_table[items].Text((char*)"Location");
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,300,390,330);
  item_table[items].Text((char*)"Color");
  items++;
}

void make_material_object_wiget()
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  tty_str_buff_loc_x[0] = '\0'; tty_str_buff_loc_y[0] = '\0'; tty_str_buff_loc_z[0] = '\0';
  tty_str_buff_rot_x[0] = '\0'; tty_str_buff_rot_y[0] = '\0'; tty_str_buff_rot_z[0] = '\0';

  int x_loc = 420, x_len = 90, x_bet = 5;
  sprintf(tty_str_buff_loc_x,"%g",((material*)node_value)->Red());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_red);
  item_table[items].Text((char*)tty_str_buff_loc_x);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_loc_y,"%g",((material*)node_value)->Green());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_green);
  item_table[items].Text((char*)tty_str_buff_loc_y);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_loc_z,"%g",((material*)node_value)->Blue());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_blue);
  item_table[items].Text((char*)tty_str_buff_loc_z);
  items++;
  x_loc = 420;
  sprintf(tty_str_buff_rot_x,"%g",((material*)node_value)->SRed());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,300,x_loc+x_len,330);
  item_table[items].Behavior(behavior_input_sred);
  item_table[items].Text((char*)tty_str_buff_rot_x);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_rot_y,"%g",((material*)node_value)->SGreen());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,300,x_loc+x_len,330);
  item_table[items].Behavior(behavior_input_sgreen);
  item_table[items].Text((char*)tty_str_buff_rot_y);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_rot_z,"%g",((material*)node_value)->Blue());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,300,x_loc+x_len,330);
  item_table[items].Behavior(behavior_input_sblue);
  item_table[items].Text((char*)tty_str_buff_rot_z);
  items++;
  x_loc = 420;
  sprintf(tty_str_buff_depth,"%g",((material*)node_value)->Alpha());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,260,x_loc+x_len,290);
  item_table[items].Behavior(behavior_input_alpha);
  item_table[items].Text((char*)tty_str_buff_depth);
  items++;
  x_loc+=(x_len+x_bet)*2;
  sprintf(tty_str_buff_radius,"%g",((material*)node_value)->Shiness());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,260,x_loc+x_len,290);
  item_table[items].Behavior(behavior_input_shine);
  item_table[items].Text((char*)tty_str_buff_radius);
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,340,390,370);
  item_table[items].Text((char*)"Color");
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,300,390,330);
  item_table[items].Text((char*)"Speculer");
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,260,390,290);
  item_table[items].Text((char*)"Alpha");
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(520,260,590,290);
  item_table[items].Text((char*)"Shiness");
  items++;
}

void make_graphic_object_wiget()
{
  header* node_value;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  tty_str_buff_loc_x[0] = '\0'; tty_str_buff_loc_y[0] = '\0'; tty_str_buff_loc_z[0] = '\0';
  tty_str_buff_rot_x[0] = '\0'; tty_str_buff_rot_y[0] = '\0'; tty_str_buff_rot_z[0] = '\0';
  location *loc,*rot;
  loc = (location*)((object*)node_value)->Location();
  rot = (location*)((object*)node_value)->Rotate();
  int x_loc = 420, x_len = 90, x_bet = 5;
  sprintf(tty_str_buff_loc_x,"%g",loc->X());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_x_location);
  item_table[items].Text((char*)tty_str_buff_loc_x);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_loc_y,"%g",loc->Y());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_y_location);
  item_table[items].Text((char*)tty_str_buff_loc_y);
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_loc_z,"%g",loc->Z());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,340,x_loc+x_len,370);
  item_table[items].Behavior(behavior_input_z_location);
  item_table[items].Text((char*)tty_str_buff_loc_z);
  items++;
  x_loc = 420;
  sprintf(tty_str_buff_rot_x,"%g",rot->X());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,300,x_loc+x_len,330);
  item_table[items].Behavior(behavior_input_x_rotation);
  item_table[items].Text((char*)tty_str_buff_rot_x);
  graphic_obj_rot_tty_x = &item_table[items];
  items++;
  sprintf(tty_str_buff_rot_y,"%g",rot->Y());
  x_loc+=x_len+x_bet;
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,300,x_loc+x_len,330);
  item_table[items].Behavior(behavior_input_y_rotation);
  item_table[items].Text((char*)tty_str_buff_rot_y);
  graphic_obj_rot_tty_y = &item_table[items];
  items++;
  x_loc+=x_len+x_bet;
  sprintf(tty_str_buff_rot_z,"%g",rot->Z());
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(x_loc,300,x_loc+x_len,330);
  item_table[items].Behavior(behavior_input_z_rotation);
  item_table[items].Text((char*)tty_str_buff_rot_z);
  graphic_obj_rot_tty_z = &item_table[items];
  items++;
  x_loc = 420;
  int y_loc = 230,height = 60,width = 90;
  item_table[items].SetRect(x_loc,y_loc,x_loc+width,y_loc+height);
  initialize_jog_dial(item_table+items);
  item_table[items].Behavior(behavior_rot_x_rotation);
  item_table[items].Value(rot->X());
  graphic_obj_rot_dial_x = &item_table[items];
  items++;
  x_loc+=x_len+x_bet;
  item_table[items].SetRect(x_loc,y_loc,x_loc+width,y_loc+height);
  initialize_jog_dial(item_table+items);
  item_table[items].Behavior(behavior_rot_y_rotation);
  item_table[items].Value(rot->Y());
  graphic_obj_rot_dial_y = &item_table[items];
  items++;
  x_loc+=x_len+x_bet;
  item_table[items].SetRect(x_loc,y_loc,x_loc+width,y_loc+height);
  initialize_jog_dial(item_table+items);
  item_table[items].Behavior(behavior_rot_z_rotation);
  item_table[items].Value(rot->Z());
  graphic_obj_rot_dial_z = &item_table[items];
  items++;

  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,340,390,370);
  item_table[items].Text((char*)"Location");
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,300,390,330);
  item_table[items].Text((char*)"Rotation");
  items++;
}

void make_nurbs_primitive_wiget()
{
  header* node_value;
  int y_loc = 150,height = 30;
  node_value = selected_node->Value();
  initialize_text_window(item_table+items);
  item_table[items].SetRect(360,y_loc,420,y_loc+height);
  item_table[items].Text((char*)"Nurbs");
  items++;
  int x_loc = 420, x_len = 50;
  item_table[items].SetRect(x_loc,y_loc,x_loc+x_len,y_loc+height);
  item_table[items].Display(DisplayButton);
  item_table[items].Select(SelectButton);
  item_table[items].Behavior(behavior_input_nurbs);
  if (node_value->Type() == PR_LINE) {
    item_table[items].Text(((line*)node_value)->Nurbs());
  }else{
    item_table[items].Text(((mesh*)node_value)->Nurbs());
  }
  items++;
}

void make_primitive_wiget()
{
  header* node_value;
  int y_loc = 190,height = 30;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(370,y_loc,390,y_loc+height);
  item_table[items].Text((char*)"Antialias");
  items++;
  int x_loc = 420, x_len = 50;
  item_table[items].SetRect(x_loc,y_loc,x_loc+x_len,y_loc+height);
  item_table[items].Display(DisplayButton);
  item_table[items].Select(SelectButton);
  item_table[items].Behavior(behavior_input_alias);
  item_table[items].Text(((graphic_primitive*)node_value)->AliasState());
  items++;
  x_loc = 580;
  item_table[items].SetRect(x_loc,y_loc,x_loc+x_len,y_loc+height);
  item_table[items].Display(DisplayButton);
  item_table[items].Select(SelectButton);
  item_table[items].Behavior(behavior_input_smooth);
  item_table[items].Text(((graphic_primitive*)node_value)->SmoothState());
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(500,y_loc,570,y_loc+height);
  item_table[items].Text((char*)"Smooth");
  items++;
}

void behavior_sample_select(Item* item) 
{
  char str[80];
  int entry = item->CurrentEntry();
  node* np = node_select[entry];
  header* node_value;
  if (selected_node != NULL) {
    node_value = selected_node->Value();
    if (node_value != NULL) ((object*)node_value)->Scale(save_scale);
  }
  selected_node = np;
  node_value = np->Value();
  int wiget_count;
  for (wiget_count = NO_OF_PANEL_ITEM; wiget_count < items;wiget_count++) {
    DspWhite(&item_table[wiget_count]);
  }
  items = NO_OF_PANEL_ITEM;
  if (node_value == (header*)0) {
    display_button->Text("not object");
    return;
  }
  switch(node_value->Type()) {
  case MATERIAL_OBJ:
    make_material_object_wiget();
    break;
  case LIGHT_OBJ:
    make_light_object_wiget();
    break;
  case POL_BOX: case GROUP_OBJ:
    make_graphic_object_wiget();
    break;
  case POL_MESH: case  PR_LINE:
    make_graphic_object_wiget();
    make_primitive_wiget();
    make_nurbs_primitive_wiget();
    break;
  case PR_SEGMENT: case PR_DOT:
    make_graphic_object_wiget();
    make_primitive_wiget();
    break;
  case PR_TEXT:
    make_graphic_object_wiget(); 
    make_input_text_object_wiget();
    break;
  case POL_SPHERE:
    make_graphic_object_wiget(); 
    make_input_sphere_object_wiget();
    break;
  case POL_PIPE0: case POL_PIPE1: case POL_CYLINDER0: case POL_CYLINDER1:
  case POL_PILLAR0: case POL_PILLAR1:
    make_graphic_object_wiget();
    make_input_cylinder_object_wiget();
    break;
  case POL_CONE: case POL_CONIC: 
    make_graphic_object_wiget();
    make_input_conic_object_wiget();
    break;
/*
  case POL_PYRAMID:
    make_graphic_object_wiget();
    make_input_pyramid_object_wiget();
    break;
*/
  case DAT_INTEGER:
    make_integer_object_wiget();
    break;
  case DAT_LOCATION:
    make_location_object_wiget();
    break;
  case DAT_FLOAT:
    make_float_object_wiget();
    break;
  case DAT_STRING:
    make_string_object_wiget();
    break;
  default:
    break;
  }
  DrawStatus t;
  switch(node_value->Type()) {
  case PR_TEXT: case  PR_LINE: case PR_DOT: case PR_SEGMENT:
    t = ((object*)(node_value))->DrawState();
    if (t == ObjectDrawing) {
      display_button->Text("draw");
    } else  {
      display_button->Text("hide");
    }
    save_scale = ((object*)(node_value))->Scale();
    break;
  case GROUP_OBJ:
    t = ((object*)(node_value))->DrawState();
    if (t == ObjectDrawing) {
      display_button->Text("draw");
    } else  {
      display_button->Text("hide");
    }
    save_scale = ((object*)(node_value))->Scale();
    break;
  case POL_SPHERE: case POL_BOX: case POL_PIPE0: case POL_PIPE1: case POL_CONE:
  case POL_CYLINDER0: case POL_CYLINDER1: case POL_CONIC: case POL_PYRAMID:
  case POL_PILLAR0: case POL_PILLAR1: case POL_MESH:
    t = ((object*)(node_value))->DrawState();
    if (t == ObjectDrawing) {
      display_button->Text("draw");
    } else if (t == DrawingWireFrame) {
      display_button->Text("wire mode");
    } else {
      display_button->Text("hide");
    }
    save_scale = ((object*)(node_value))->Scale();
    break;
  default:
    display_button->Text("undrawable");
    break;
  }
  if (node_value == (header*)0) return;
  make_name(str,np);
  textwindow_child->Text(str);
  hslider_scale->Value(save_scale*10);
  sprintf(display_scale->Text(),"%6.3f",save_scale);
  if (node_value->Type() == GROUP_OBJ) {
    if (((group*)node_value)->NoOfObjects() == 0) {
      display_button->Text("(null group)");
      return;
    }
    button_child->Text(str);
    current_group = (group*)node_value;
    current_node = (node*)current_group->First();
    np = current_node;
    int c;
    for (c = 0;c < TEXT_ARRAY;c++) {
      if (np == NULL) break;
      header* wp = np->Value();
      node_select[c] = np;
      //make_name(&text_array[c][0],np);
      sprintf(text_array[c],"%s",np->Name());
      np = (node*)np->Next();
    }
    selector_child->CurrentEntry(0);
    selector_child->NoOfSelect(c);
    vslider_child->Total((current_group->NoOfObjects()));
    vslider_child->Value(0);
  }
}

void behavior_display_button(Item* item)
{
  header* node_value;
  if (selected_node == (node*)0) return;
  node_value = selected_node->Value();
  if (node_value == (header*)0) return;
  DrawStatus t;
  switch(node_value->Type()) {
  case PR_TEXT: case  PR_LINE: case PR_DOT: case PR_SEGMENT:
    t = ((object*)(node_value))->DrawState();
    t = (t == ObjectDrawing) ?  ObjectHidding : ObjectDrawing;
    ((object*)(node_value))->DrawState(t);
    if (t == ObjectDrawing) {
      item->Text("draw");
    } else  {
      item->Text("hide");
    }
    break;
  case GROUP_OBJ:
    t = ((object*)(node_value))->DrawState();
    t = (t == ObjectDrawing) ? ObjectHidding : ObjectDrawing;
    if (t == ObjectDrawing) {
      item->Text("draw");
    } else  {
      item->Text("hide");
    }
    ((object*)(node_value))->DrawState(t);
    break;
  case POL_SPHERE: case POL_BOX: case POL_PIPE0: case POL_PIPE1:
  case POL_CYLINDER0: case POL_CYLINDER1: case POL_CONE: case POL_CONIC:
  case POL_PYRAMID:  case POL_PILLAR0: case  POL_PILLAR1: case POL_MESH:
  case NODE_OBJ:
    t = ((object*)(node_value))->DrawState();
    t = (t == ObjectDrawing) ? DrawingWireFrame : (t == DrawingWireFrame) ?  ObjectHidding : ObjectDrawing;
    if (t == ObjectDrawing) {
      item->Text("draw");
    } else  if (t == DrawingWireFrame) {
      item->Text("wire mode");
    } else  {
      item->Text("hide");
    }
    ((object*)(node_value))->DrawState(t);
    break;
  default:
      item->Text("undrawable");
    break;
  }
} 


void initialize_panel_item () 
/* ȥѥͥν֤ɬפWidgetʤ֤Ԥʤ */
{
  tty_str_buff[0] = '\0';
  char str[100];
  node* np;
  np = (node*)(current_group->Parent());
  make_name(str,np);
  int c ;
  for (c = 0;c<TEXT_ARRAY;c++) {
    text_array[c] = new char[256];
  }
  items = 0;
  // display parent object name
  item_table[items].SetRect(35,360,35+SELECTWIDTH,385);
  item_table[items].Display(DisplayButton);
  item_table[items].Select(SelectButton);
  item_table[items].Behavior(behavior_sample_button);
  item_table[items].Text(str);
  items++;
  // select object name slide
  item_table[items].SetRect(10,230,30,355);
  item_table[items].Display(DisplayVSlider);
  item_table[items].Select(SelectVSlide);
  item_table[items].Behavior(behavior_sample_vslider);
  item_table[items].Total(current_group->NoOfObjects());
  item_table[items].Value(0);
  items++;
  // select object name
  item_table[items].SetRect(35,230,35+SELECTWIDTH,355);
  item_table[items].Display(DisplaySelect);
  item_table[items].Select(SelectSelect);
  item_table[items].Behavior(behavior_sample_select);
  item_table[items].TextArray(text_array);
  item_table[items].NoOfSelect(TEXT_ARRAY);
  item_table[items].CurrentEntry(0);
  items++;
  // display selected object name
  item_table[items].SetRect(35,200,35+SELECTWIDTH,225);
  item_table[items].Display(DisplayTextWindow);
  item_table[items].Select(SelectTextWindow);
  item_table[items].Behavior(behavior_sample_text_window);
  if (selected_node != (node*)0) {
    make_name(str,selected_node);
    item_table[items].Text(str);
  }else{
    item_table[items].Text("");
  }
  items++;
  // message to selected object (draw -> to be wireframe -> hide -> draw ...)
  item_table[items].SetRect(155,160,300,180);
  item_table[items].Display(DisplayButton);
  item_table[items].Select(SelectButton);
  item_table[items].Behavior(behavior_display_button);
  item_table[items].Text("");
  items++;
  // scale slider
  float sc;
  sc = ((object*)current_group)->Scale();
  item_table[items].SetRect(35,95,300,125);
  item_table[items].Display(DisplayHSlider);
  item_table[items].Select(SelectHSlide);
  item_table[items].Behavior(behavior_scale_vslider);
  item_table[items].Total(100);
  item_table[items].Value(10.0*sc);

  items++;
  item_table[items].SetRect(310,95,380,125);
  item_table[items].Display(DisplayTextWindow);
  item_table[items].Select(SelectTty);
  item_table[items].Behavior(behavior_sample_scale_window);
  sprintf(tty_str_buff_scale,"%6.3f",scale);
  item_table[items].Text(tty_str_buff_scale);
  items++;
  // Display title "Scale"
  initialize_text_window(item_table+items);
  item_table[items].SetRect(35,130,90,160);
  item_table[items].Text("Scale");
  items++;
  // Display title "Display State"
  initialize_text_window(item_table+items);
  item_table[items].SetRect(35,160,150,180);
  item_table[items].Text("Display State");
  items++;
  // Display input 
  initialize_input_text_window(item_table+items);
  item_table[items].SetRect(130,70,500,90);
  item_table[items].Behavior(behavior_sample_tty_window);
  item_table[items].Text((char*)tty_str_buff);
  items++;
  initialize_text_window(item_table+items);
  item_table[items].SetRect(35,70,120,90);
  item_table[items].Text("Message");
  items++;

  display_scale = &item_table[6];
  hslider_scale = &item_table[5];
  display_button = &item_table[4];
  textwindow_child = &item_table[3];
  selector_child = &item_table[2];
  vslider_child = &item_table[1];
  button_child = &item_table[0];
}

void dispatch_event()
/* ޥϥ٥ȤdispatchԤʤ */
{
  int c;
  for (c = 0;c<items;c++) {
    if ((item_table[c].IsSelected(cursor_x,cursor_y)) == TRUE) {
      item_table[c].Select(&item_table[c]);
      break;
    }
  }
}

void p_sp_event(long event,short val) 
/* ޥϥ٥Ȥν롼κǾ̥롼 */
/* event.c륤٥ */
{
  is_keybord_event = FALSE;
  long PanelXorigin,PanelYorigin;
  getorigin(&PanelXorigin, &PanelYorigin);
  switch(event) {
  case KEYBD:
    is_keybord_event = TRUE;
    char_letter = (int)val;
    //printf ("value %d\n",char_letter);
    dispatch_event();
    is_keybord_event = FALSE;
    break;
  case LEFTMOUSE:
    //cursor_x = getvaluator(CURSORX)-(int)PanelXorigin;
    //cursor_y = getvaluator(CURSORY)- (int)PanelYorigin;
    //printf ("(%d,%d)\n",cursor_x,cursor_y);
    left_mouse_state = val; /* UP or DOWN */
    dispatch_event();
    break;
  case MOUSEX:
    cursor_x = (int)val - (int)PanelXorigin;
    dispatch_event();
    break;
  case MOUSEY:
    cursor_y = (int)val- (int)PanelYorigin;
    dispatch_event();
    break;
  }
}
void drawPanel(long event,short val) 
/* ȥѥͥ롼 */
/* REDRAW٥Ȥʤɤǵư롣 */
{
  winset(pwind);
  long PanelXorigin,PanelYorigin;
  long height,width;
  getsize(&width,&height);
  getorigin(&PanelXorigin, &PanelYorigin);
/*
  unsigned long back;
  back = 0xffffa07f; 
  //back = 0xff000000; 
*/
  cpack(BACKGROUND_COLOR);
  clear();
  float x,y;
  x = (float)width;
  y = (float)height;
  int c;
  node* np;
  if ((current_node == (node*)0)||(current_group == (group*)0)) {
    current_group = root_obj;
    current_node = (node*)current_group->First();
  }
  np = current_node;
  for (c = 0;c<TEXT_ARRAY;c++) {
    if (np == NULL) break;
    header* wp = np->Value();
    node_select[c] = np;
    //make_name(&text_array[c][0],np);
    sprintf(text_array[c],"\"%s\"",np->Name());
    np = (node*)np->Next();
  }
  for (c = 0;c<items;c++) {
    item_table[c].Display(&item_table[c]);
  }
  color(BLACK);
  cmov2i(20,15);
#ifndef _DISABLE_GL_
  char str[80];
  sprintf(str,"Rotation (WX,WY,WZ,W) : (%10.5f %10.5f %10.5f %10.5f)",
	  rvec[0],rvec[1],rvec[2],rvec[3]);
  charstr(str);
  cmov2i(20,45);
  sprintf(str,"Location (X,Y,Z)      : (%10.5f %10.5f %10.5f)",
	  trans[0], trans[1], trans[2]);
  charstr(str);
#endif
  gflush();
  swapbuffers();
  cpack(BACKGROUND_COLOR);
  clear();
}

void panel_event_set() 
/* ȥѥͥΥ٥ȥ롼Ԥʤ */
{
  selected_node = (node*)0;
  qdevice(REDRAW);
  add_event(pwind, REDRAW, ANY, (void(*)(void*,int))drawPanel,0);
  pwind = winget();
  qdevice(KEYBD);
  qdevice(LEFTMOUSE);
  qdevice(MOUSEY);
  qdevice(MOUSEX);
  //qdevice(CURSORY);
  //qdevice(CURSORX);
  //tie(LEFTMOUSE,CURSORX,CURSORY);
  add_event(pwind,KEYBD,ANY,(void(*)(void*,int))p_sp_event,(void*)KEYBD);  
  add_event(pwind,LEFTMOUSE,DOWN,(void(*)(void*,int))p_sp_event,(void*)LEFTMOUSE);  
  add_event(pwind,LEFTMOUSE,UP,(void(*)(void*,int))p_sp_event,(void*)LEFTMOUSE);  
  add_event(pwind,MOUSEX,ANY,(void(*)(void*,int))p_sp_event,(void *)MOUSEX);  
  add_event(pwind,MOUSEY,ANY,(void(*)(void*,int))p_sp_event,(void *)MOUSEY);  
}

void close_panel()
/* ȥѥͥ뤬ĤνԤʤ*/
{
  if (selected_node != (node*)0) {
    header* node_value;
    node_value = selected_node->Value();
    ((object*)node_value)->Scale(save_scale);
    selected_node = (node*)0;
    current_group = save_group;
  }
  winclose(pwind);
}

void open_panel()
/* ȥѥͥ򳫤*/
{
  prefsize(700,400);
  is_node_scroll_bar = FALSE;
  save_group = current_group;
  current_group = root_obj;
  current_node = (node*)current_group->First();
  pwind = winopen("3dview controls");
  RGBmode();
  doublebuffer();
  gconfig();
  zbuffer(FALSE);
/*  mmode(MPROJECTION);
  ortho(-1,1,-1,1,-5,5);
  mmode(MVIEWING);
  perspective(400,1.0,0.1,4.0);*/
  long PanelXorigin,PanelYorigin;
  getorigin(&PanelXorigin, &PanelYorigin);
  cpack(0xffffffff);
  swapbuffers();
  cpack(0xffffffff);
  clear();
  initialize_panel_item ();
}

