/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <math.h>

void nvector(float *A,float *B,float *C,float *n)
{
/*
  C(0) = A(1) * B(2) - A(2) * B(1);
  C(1) = A(2) * B(0) - A(0) * B(2);
  C(2) = A(0) * B(1) - A(1) * B(0);
*/

  n[0] = (B[1]-A[1])*(C[2]-A[2]) - (B[2]-A[2])*(C[1]-A[1]);
  n[1] = (B[2]-A[2])*(C[0]-A[0]) - (B[0]-A[0])*(C[2]-A[2]);
  n[2] = (B[0]-A[0])*(C[1]-A[1]) - (B[1]-A[1])*(C[0]-A[0]);

  double Len2 = n[0]*n[0]+n[1]*n[1]+n[2]*n[2];
  n[0] = n[0]/sqrt(Len2);
  n[1] = n[1]/sqrt(Len2);
  n[2] = n[2]/sqrt(Len2);
}

