/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#ifndef _header_h_
#define _header_h_

#ifdef _UN_USE_YACC_
#include "messagetag.h"
#endif

#ifndef _objecttag_h_
#include "objecttag.h"
#endif

/* function defined  at object.c */
typedef enum {
  ObjectDrawing,
  DrawingWireFrame,
  ObjectHidding
} DrawStatus;

class header {
  header* next;
  header* prev;
 protected:
  ObjectTypeTag type;
  int ref_c;
  int sym_id;
 public:
  header();
  char* Name();
  void Split(int r = 1);
  virtual void Print();
  virtual void Close();
  inline int Ref();
  inline void Ref(int r);
  inline void SymmbolId(int t) ;
  inline void Type(ObjectTypeTag t) ;
  inline ObjectTypeTag Type();
  void Next(header* n);
  header* Next();
  void Previous(header* n);
  header* Previous();

  virtual void DrawState(DrawStatus t);
  virtual void Draw();

#ifdef _UN_USE_YACC_
#include "accept.h"
#include "reduce.h"
#endif
};

inline int header::Ref()
{
  return ref_c;
}

inline void header::Ref(int r)
{
  ref_c = r;
}

inline void header::Type(ObjectTypeTag t) 
{
  type = t;
}

inline ObjectTypeTag header::Type()
{
  return type;
}

inline void header::SymmbolId(int t)
{
  sym_id = t;
}

#endif /* _header_h_*/



