/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include "hash.h"


 wordTable::wordTable()
{
   Offset = 0;
   Next = 0;

}

int hash::hashFn(char* Word)
{
  int HashVal = 0;
  for(;*Word != '\0';Word++) {
    HashVal = HashVal*3 + (*Word-'0');
  }
  HashVal = (HashVal & 0x7fff) % HashMax;
  return HashVal;
}

hash::hash(int WMax,int HMax,int SMax) 
{
  HashMax   = HMax;
  WordMax   = WMax;
  StrgMax   = SMax;
  HashTable = new int      [HashMax];
  WordTable = new wordTable[WordMax];
  String    = new char     [StrgMax];
  WordIdNew = 1;
  OffsetNew = 0;
  init() ;
}

void hash::init() 
{
  int c;
  for (c = 0;c<HashMax;c++) {
    *(HashTable+c) = 0;
  }
}

hash::hash(void)
{
  
}
hash::~hash(void)
{
  delete HashTable;
  delete WordTable;
  delete String;
}

char* hash::idWord(int Id)
{
  return String + WordTable[Id].offset();
}

int  hash::wordId(char* Word)
{
  int   WordIdNow;
  int   WordId;
  int   HashVal;
  char* WordCmp;
  char  Cpy;
  HashVal   = hashFn(Word);
  WordIdNow = *(HashTable+HashVal);
  if((WordIdNow == 0)||(WordIdNow>WordIdNew)){
    if (WordIdNew >= WordMax) {
      fprintf(stderr, "Hash: Too much words!\n");
      return 0;
    }
    *(HashTable+HashVal) = WordIdNew;
  } else {
    do {
      WordId  = WordIdNow;
      WordCmp = String + WordTable[WordId].offset();
      if(0 == strcmp(Word,WordCmp)) return WordId;
    }while(0 !=  (WordIdNow = WordTable[WordId].next()));
    if (WordIdNew >= WordMax) {
      fprintf(stderr,"Hash: Too much words!\n");
      return 0;
    }
    WordTable[WordId].next(WordIdNew);
  }
  WordId = WordIdNew;
  WordTable[WordId].offset(OffsetNew);
  do {
    Cpy  = *(String    + OffsetNew)    =    *Word;
    if(++ OffsetNew  >= StrgMax) {
      fprintf(stderr,"Hash: Out of string area!\n");
      return 0;
    }
    Word++;
  } while(Cpy !='\0');
  WordIdNew++;
  return WordId;
}
