/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <malloc.h>
#ifndef _DISABLE_GL_
#include <gl.h>
#endif
#include "location.h"
#include "symbol.h"
#include "data.h"
#include "hash.h"
#include "exit.h"

extern char line_buffer[BUFSIZ];

int numerical2int(header* obj,char* err_msg_str)
// {}
// ͤ򼨤֥ȤCؤѴ
// {}
{
  if(obj == (header*)0) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,err_msg_str);
    error_exit();
  }
  ObjectTypeTag o_type = obj->Type();
  if (o_type == DAT_INTEGER) {
    return ((fixed_number*)obj)->Value();
  }else if (o_type == DAT_FLOAT){
    return (int)(((float_number*)obj)->Value());
  }
  fprintf(stderr,"%s\n",line_buffer);
  fprintf(stderr,err_msg_str);
  error_exit();
  return 0;
}

float numerical2float(header* obj,char* err_msg_str)
// {}
// ͤ򼨤֥ȤCμ¿ؤѴ
// {}
{
  if(obj == (header*)0) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,err_msg_str);
    error_exit();
  }
  ObjectTypeTag o_type = obj->Type();
  if (o_type == DAT_INTEGER) {
    return (float)(((fixed_number*)obj)->Value());
  }else if (o_type == DAT_FLOAT){
    return ((float_number*)obj)->Value();
  }
  fprintf(stderr,"%s\n",line_buffer);
  fprintf(stderr,err_msg_str);
  error_exit();
  return 0;
}

char* string2cstr(header* obj,char* err_msg_str)
//{}
//ƥʸ󥪥֥ȤCʸݥ󥿤֤
//{}
{
  if(obj == (header*)0) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,err_msg_str);
    error_exit();
  }
  if (obj->Type() == DAT_STRING) {
    return ((string*)obj)->Value();
  }
  fprintf(stderr,"%s\n",line_buffer);
  fprintf(stderr,err_msg_str);
  error_exit();
  return (char*)0;
}

 fixed_number::fixed_number()
//{}
// ֥Ȥιۻ
//{}
{
  type = DAT_INTEGER;
  sym_id = sym_integer;
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d  fixed_number::fixed_number()\n",(unsigned int) this,ref_c);
#endif
}

void fixed_number::Print()
// {}
// ƤɸϤ˽Ϥ롣
// {}
{
  printf ("%d",val);
}

void fixed_number::Value(int v)
// {}
// ¿ͤ򥻥åȤ롣
// {}
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void fixed_number::Value(int %d)\n",(unsigned int) this,ref_c,v);
#endif
  val = v;
}

int  fixed_number::Value()
// {}
// ¿֤ͤ
// {}
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d int fixed_number::Value()\n",(unsigned int) this,ref_c);
#endif
  return val;
}

 void fixed_number::Close()
// {}
// ֥ȤΥ
// ȥȤ0ˤʤä鼫Ȥ롣
// {}
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void fixed_number::Close()\n",(unsigned int) this,ref_c);
#endif
  ref_c--;
   if (ref_c == 0) {
     free(this);
   }  
}

 float_number::float_number()
//{}
// ¿֥Ȥιۻ
//{}
{
  type = DAT_FLOAT;
  sym_id = sym_float;
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d  float_number::float_number()\n",(unsigned int) this,ref_c);
#endif
}

void float_number::Value(double v)
// {}
// ¿ͤ򥻥åȤ롣
// {}
{
  val = v;
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void float_number::Value(double %f)\n",(unsigned int) this,ref_c,v);
#endif
}

void float_number::Print()
// {}
// ƤɸϤ˽Ϥ롣
// {}
{
  printf ("%f",val);
}

double float_number::Value()
// {}
// ¿֤ͤ
// {}
{
  return val;
}

 void float_number::Close()
// {}
// ¿֥ȤΥ
// ȥȤ0ˤʤä鼫Ȥ롣
// {}
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void float_number::Close()\n",(unsigned int) this,ref_c);
#endif
  ref_c--;
   if (ref_c == 0) {
     free(this);
   }  
}

 string::string()
//{}
// ʸ󥪥֥Ȥιۻ
//{}
{
  type = DAT_STRING;
  sym_id = sym_string;
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d string::string()\n",(unsigned int) this,ref_c);
#endif
}

int string::Id()
//{}
// ʸФhash_code֤
//{}
{
  return id;
}

void string::Id(int i)
// {}
// hash code줿ʸǼ롣
// ʸhash_codeǼΤϡʸӤӤǹԤʤᡢ
// ޤhash_tableʸ󥢥ɥ쥹ȤΤϡʸγǼΰ󤹤
// ᡣ
// {}
{
  id = i;
  val = hash_table.idWord(id);
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void string::Value(int %d(char* %s))\n",(unsigned int) this,ref_c,i,val);
#endif
}

void string::Print()
// {}
// ʸɸϤǽϤ롣
// {}
{
  printf("%s",val);
}

char* string::Value()
// hash_tableʸ󥢥ɥ쥹֤
{
  return val;
}

 void string::Close()
// ȥȤ0ˤʤä鼫Ȥ롣
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void string::Close()\n",(unsigned int) this,ref_c);
#endif
  ref_c--;
   if (ref_c == 0) {
     free(this);
   }  
}

 cons::cons() 
// {}
// cons cellιۻ
// {}
{
  type = DAT_LIST;
  sym_id = sym_list;
  car = (header*)0;
  cdr = (header*)0;
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d  cons::cons()\n",(unsigned int) this,ref_c);
#endif
}

void cons::Print() 
// {}
// ꥹɽǤΥǡ¤ɸϤءϤ롣
// {}
{
  cons* wp;
  putchar('[');
  wp = this;
  for (;;) {
    header* obj;
    obj = (header*)(wp->Car());
    if (obj == (header*)0) {
      printf("[]");
    }else {
      obj->Print();
    }
    wp = (cons*)(wp->Cdr());
    if (wp == (cons*)0) {
      break;
    }else{
      putchar(',');
    }
  }
  putchar(']');
}

 void cons::Close() 
// {}
// cons cellΥ
// ȥȤ0ˤʤä鼫Ȥ롣
// {}
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void cons::Close()\n",(unsigned int) this,ref_c);
#endif
  ref_c--;
   if (ref_c == 0) {
     if (car != (header*)0) {
#ifdef DEBUG
       fprintf(stderr,"void cons::Close() --> car(%x)\n",(unsigned int)this,car);
#endif
       car->Close();
     }
     if (cdr != (header*)0) {
#ifdef DEBUG
       fprintf(stderr,"void cons::Close() --> cdr(%x)\n",(unsigned int)this,cdr);
#endif
       cdr->Close();
     }
     free(this);
   }
}

header* cons::Car()
// {}
// cons cellcarΥ֥Ȥ֤
// {}
{
  return car;
}

header* cons::Cdr()
// {}
// cons cellcdrΥ֥Ȥ֤
// {}
{
  return cdr;
}

void cons::Car(header* t)
// {}
// cons cellcar˥֥Ȥ򥻥åȤ
// {}
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void cons::Car(header* %x)\n",(unsigned int) this,ref_c,(unsigned int)t);
  if (t != (header*)0) {
    fprintf(stderr,"%x is ",(unsigned int)t);
    t->Print();
  }
  fprintf(stderr,"\n");
#endif
  car = t;
}

void cons::Cdr(header* t)
// {}
// cons cellcdr˥֥Ȥ򥻥åȤ
// {}
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void cons::Cdr(header* %x)\n",(unsigned int) this,ref_c,(unsigned int)t);
  if (t != (header*)0) {
    fprintf(stderr,"%x is ",(unsigned int)t);
    t->Print();
  }
  fprintf(stderr,"\n");
#endif
  cdr = t;
}

header* make_location(header* wp)
//{}
// ¿3ĤΥǡ¤˼ޤȤ롣
//{}
{
  int cc;
  float xyz[3];
  for (cc = 0;cc<3;cc++) {
    if ((wp->Type()) == DAT_INTEGER) {
      xyz[cc] = (float)(((fixed_number*)wp)->Value());
    }else  if ((wp->Type()) == DAT_FLOAT) {
      xyz[cc] = ((float_number*)wp)->Value();
    }
    wp = wp->Next();
    //hp->Close();
  }
  location* ret;
  ret = new location[1];
  ret->X(xyz[0]);
  ret->Y(xyz[1]);
  ret->Z(xyz[2]);
  ret->Split();
  return (header*)ret;
}

int arg_length(header* wp)
//{}
// ο֤
//{}
{
  int cc;
  for (cc = 0;wp != NULL;wp = wp->Next(),cc++) {
  }
  return cc;
}
header* append_args(header* top,header* tail)
//{}
// Υ롣
//{}
{
  //fprintf(stderr," append arg %x %x \n",(unsigned int )top,(unsigned int )tail);
  if (top != NULL) {
    top->Next(tail);
  }
  return top;
}

header* insert_list(header* top,header* tail)
//{}
// ꥹȤƬǤ롣
//{}
{
  //printf("insert_list (%x %x)\n",(unsigned int)top,(unsigned int)tail);
  cons* cell;
  cell = new cons[1];
  if (top != NULL) {
    top->Split();
  }
  if (tail != NULL) {
    tail->Split();
  }
  cell->Car(top);
  cell->Cdr(tail);
  cell->Split();
  //printf("cell (%x)\n",(unsigned int)cell);
  return (header*)(cell);
}

header*  append_list(header* last,header* list)
//{}
// ꥹȤκǸǤɲä롣
//{}
{
  //printf("append_list (%x %x)\n",(unsigned int)top,(unsigned int)tail);
  cons* cell;
  if (list == NULL) {
    cell = new cons[1];
    cell->Car(last);
    cell->Cdr(list);
    cell->Split();
    return (header*)(cell);
  }
  cons* wp;
  for (wp = (cons*)list;(wp->Cdr())!= (header*)0;wp = (cons*)wp->Cdr());
  cell = new cons[1];
  cell->Car(last);
  cell->Cdr((header*)0);
  cell->Split();
  wp->Cdr(cell);
  return (header*)(list);
}
