/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <string.h>
#include "symbol.h"
#include "color_obj.h"
#include "boolean.h"
#include "exit.h"

extern char line_buffer[BUFSIZ];
extern int line_number;
static int color_id_count;
int current_color_id;

void initialize_material()
{
  color_id_count = 0;
  current_color_id = 0;
}

 material::material()
{
  type = MATERIAL_OBJ;
  color_id = ++color_id_count;
  shine = 10.0;
  alpha = 1.0;
  sym_id = sym_material;
}

int  material::IsEqualRgb(float r,float g,float b) 
{
  return ((r == tc_red)&&(tc_green == g)&&(tc_blue == b)) ? TRUE:FALSE;
}

 void material::Close()
{
//  fprintf(stderr,"material::Close()\n");
  ref_c--;
  if (ref_c == 0) {
    free(this);
  }
}
void material::RgbSet(float r,float g,float b) 
{
  tc_red = r;
  tc_green = g;
  tc_blue = b;
  float w_red = (tc_red/shine)*255;
  float w_green = (tc_green/shine)*255;
  float w_blue = (tc_blue/shine)*255;
  pr_red =  (unsigned short)(w_red);
  pr_green =  (unsigned short)(w_green);
  pr_blue =  (unsigned short)(w_blue);
//  printf("RgbSet(%d %d %d)\n",pr_red,pr_green,pr_blue);
}

void material::ColorID(int id) 
{
  color_id = id;
}

short int material::PrRed() 
{
  return pr_red;
}

short int material::PrGreen() 
{
  return pr_green;
}

short int material::PrBlue() 
{
  return pr_blue;
}

void material::Alpha(float a)
{
  alpha = a;
}

float material::Alpha()
{
  return alpha;
}

void material::Shiness(float a)
{
  shine = a;
  float w_red = (tc_red/shine)*255;
  float w_green = (tc_green/shine)*255;
  float w_blue = (tc_blue/shine)*255;
  pr_red =  (unsigned short)(w_red);
  pr_green =  (unsigned short)(w_green);
  pr_blue =  (unsigned short)(w_blue);
}

void material::Speculer(float a,float b,float c)
{
  speculer[0] = a;
  speculer[1] = b;
  speculer[2] = c;
}

int material::ColorID() 
{
  return color_id;
}

void material::Bind()
{
#ifndef _DISABLE_GL_
  static float  Material[17] = {
    AMBIENT,   0.0,  0.0,  0.0,
    DIFFUSE,   0.0,  0.0,  0.0,
    SPECULAR,  9.0,  9.0,  9.0,
    SHININESS, 30.0,
    ALPHA, 0.5,LMNULL
  };

  if (tc_red >shine) {
    fprintf(stderr,"Warning: \nBind red greater than shine %d\n",line_number);
  }
  if (tc_green >shine) {
    fprintf(stderr,"Warning: \nBind green greater than shine %d\n",line_number);
  }
  if (tc_blue >shine) {
    fprintf(stderr,"Warning: \nBind blue greater than shine %d\n",line_number);
  }
  Material[1] = tc_red/shine;
  Material[2] = tc_green/shine;
  Material[3] = tc_blue/shine;
  if (alpha < 1.0) {
    Material[5] = 0;
    Material[6] = 0;
    Material[7] = 0;
  }else {
    Material[5] = tc_red;
    Material[6] = tc_green;
    Material[7] = tc_blue;
  }
  Material[9] = speculer[0];
  Material[10] = speculer[1];
  Material[11] = speculer[2];
  Material[13] = shine;
  Material[15] = alpha;
  lmdef(DEFMATERIAL,color_id,0,Material);
#endif
}

void draw_color_bind(material* col)
{
#ifndef _DISABLE_GL_
  int color_id;
  color_id = col->ColorID();
  //if (current_color_id == color_id) return;
  current_color_id = color_id;
  lmbind(MATERIAL, col->ColorID());
  lmbind(BACKMATERIAL, col->ColorID());
  if ((col->Alpha())<1) {
    unsigned long word;
    blendfunction(BF_SA,BF_MSC);
    word = (unsigned long)((col->Alpha()*255)/255);
    word <<= 8;
    word += col->PrBlue();
    word <<= 8;
    word += col->PrGreen();
    word <<= 8;
    word += col->PrRed();
    cpack(word);
  } else {
    unsigned long word;
    blendfunction(BF_ONE,BF_ZERO);
    word = (unsigned long)(255);
    word <<= 8;
    word += col->PrBlue();
    word <<= 8;
    word += col->PrGreen();
    word <<= 8;
    word += col->PrRed();
    cpack(word);
  }
#endif
}

void check_material_and_bind(header* obj,char* errmsgstr)
// objޥƥꥢ륪֥ȤǤ뤫Ƚ̤
// ǤʤbindǤʤʤfatalåɽ
// ƽλ
{
  if (obj == (header*)0) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,errmsgstr);
    error_exit();
  }
  if (obj->Type() == MATERIAL_OBJ){
    draw_color_bind((material*)obj);
  }else{
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,errmsgstr);
    error_exit();
  }
}
