/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -*-C++-*- */

#include "box.h"
#include "node.h"
#include "data.h"
#include "symbol.h"
#include "hash.h"
#include "exit.h"

extern char line_buffer[BUFSIZ];

char* errmsg_box_material_invalid = "Fatal : \nbox member material invalid object\n";

 box::box()
//{}
//Ȣ֥Ȥιۻ
//{}
{
  type = POL_BOX;
  sym_id = sym_box;
  dx = dy = dz = 0;
}

void box::From(location* l) 
//{}
//Ȣ֥Ȥλꤹ롣
//{}
{
  Move(l);
}
void box::To(location* l) 
//{}
//Ȣ֥Ȥνꤹ롣
//{}
{
  if(object_location->X() > l->X())
    {
      dx = object_location->X()- l->X();
      object_location->X(l->X());
    }
  else
    {
      dx = l->X() - object_location->X();
    }
  if(object_location->Y() > l->Y())
    {
      dy = object_location->Y()- l->Y();
      object_location->Y(l->Y());
    }
  else
    {
      dy = l->Y() - object_location->Y();
    }
  if(object_location->Z() > l->Z())
    {
      dz = object_location->Z()- l->Z();
      object_location->Z(l->Z());
    }
  else
    {
      dz = l->Z() - object_location->Z();
    }
}

 void box::Close()
//{}
// ȢΥԤʤ
// ȥȤ0ˤʤäˡΰ롣
// ⤷ޤ¾黲ȤƤСȥȤ
// 1餹
//{}
{
  ref_c--;
  if (ref_c == 0) {
    color->Close();
    free(this);
  }
}

void box::Draw()
//{}
// Ȣ֥Ȥؿ
//{}
{
#ifndef _DISABLE_GL_
  if (dstate == ObjectHidding) return;
  if (scale == 0) return; 
  check_material_and_bind(color->Value(),errmsg_box_material_invalid);
  float v[3], n[3];
  PushScale();
  PushTranslation();
  PushRotation();
  v[0] = 0;      v[1] = 0;      v[2] = 0;
  if (dstate == DrawingWireFrame) {
    bgnline();
    v3f(v);
    v[2] = dz; v3f(v);
    v[1] = dy; v3f(v);
    v[2] = 0;  v3f(v);
    v[1] = 0;  v3f(v);
    v[0] = dx; v3f(v);
    v[2] = dz; v3f(v);
    v[1] = dy; v3f(v);
    v[1] = dy; v[2] = 0;v3f(v);
    v[1] = 0;  v3f(v);
    endline();
    bgnline();
    v[0] = 0; v[2] = dz; v3f(v);
    v[0] = dx; v3f(v);
    endline();
    bgnline();
    v[0] = 0; v[1] = dy; v[2] = 0; v3f(v);
    v[0] = dx; v3f(v);
    endline();
    bgnline();
    v[0] = 0; v[1] = dy; v[2] = dz; v3f(v);
    v[0] = dx; v3f(v);
      endline();
  }else {
    backface(FALSE);
    n[0] = (dx>0?-1:1); n[1] = 0; n[2] = 0;
    bgnpolygon();
    n3f(n);
    v[0]=0;
    v[1]=0;
    v[2]=0;
    v3f(v);
    v[2]=dz;
    v3f(v);
    v[1]=dy;
    v3f(v);
    v[2]=0;
    v3f(v);
    endpolygon();
    n[0] = 0; n[1] = 0; n[2] =(dz>0?-1:1);
    bgnpolygon();
    n3f(n);
    v3f(v);
    v[0]=dx;
    v3f(v);
    v[1]=0;
    v3f(v);
    v[0]=0;
    v3f(v);
    endpolygon();
    n[0] = 0; n[1] =(dy>0?-1:1); n[2] = 0;
    bgnpolygon();
    n3f(n);
    v3f(v);
    v[0]=dx;
    v3f(v);
    v[2]=dz;
    v3f(v);
    v[0]=0;
    v3f(v);
    endpolygon();
    n[0] = 0; n[1] = 0; n[2] = (dz>0?1:-1);
    bgnpolygon();
    n3f(n);
    v3f(v);
    v[0]=dx;
    v3f(v);
    v[1]=dy;
    v3f(v);
    v[0]=0;
    v3f(v);
    endpolygon();
    n[0] = 0; n[1] = (dy>0?1:-1); n[2] = 0;
    bgnpolygon();
    n3f(n);
    v3f(v);
    v[0]=dx;
    v3f(v);
    v[2]=0;
    v3f(v);
    v[0]=0;
    v3f(v);
    endpolygon();
    n[0] = (dx>0?1:-1); n[1] = 0; n[2] = 0;
    bgnpolygon();
    n3f(n);
    v[0]=dx;
    v3f(v);
    v[2]=dz;
    v3f(v);
    v[1]=0;
    v3f(v);
    v[2]=0;
    v3f(v);
    endpolygon();
  }
  PopRotation();
  PopTranslation();
  PopScale();
#endif
}

void box::Scale(double s)
{
  scale = s;
}
