/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* */
/* -*-C++-*- */
#ifdef _UN_USE_YACC_
#include <math.h>
#include "group.h"
#include "sphere.h"
#include "cylinder.h"
#include "primitive.h"
#include "box.h"
#include "color_obj.h"
#include "light.h"
#include "text.h"
#include "data.h"
#include "hash.h"
#include "symbol.h"
#include "messagetag.h"
#include "message.h"
#include "gorth.h"
#include "function.h"
#include "parser.h"

/* ᥽åɼ̻Ҥåΰο֤ */
/* ⤷Υ֥ȤΥåȤŬǤʤ-1֤ */

PAccept(header)
{
  /* Not initialize or literal object */
  return -1;
}

PAccept(location) 
{
  switch (mid) {
  case METHOD_VALUE:
    return (2|1);
  default:
    return -1;
  }
}
PAccept(cons) 
{
  switch (mid) {
  case METHOD_ELEMENT:
    return (2|1);
  case METHOD_INSERT:
    return 1;
  case METHOD_CAR:
  case METHOD_CDR:
    return 0;
  default:
    break;
  }
  return -1;
}
PAccept(graphic_orth)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
     if (mid == METHOD_TRANSFORM) return 6;
   }
  return -1;
}
 
PAccept(material)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch(mid) {
    case METHOD_BIND:
      return 0;
    case METHOD_ALPHA: case METHOD_SHINES: case METHOD_SPECULER: case METHOD_COLOR:
      return 1;
    default:
      break;
    }
  }
  return -1;
}

PAccept(light)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch(mid) {
    case METHOD_BIND:
      return 0;
    case METHOD_COLOR: case METHOD_MOVE:
      return 1;
    default:
      break;
    }
  }
  return -1;
}

PAccept(node)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch (mid) {
    case METHOD_POP: case METHOD_UP: case METHOD_SYNC:
      return 0; 
    case METHOD_INTO: case METHOD_PUSH: case METHOD_IS: case METHOD_COPY:
      return 1;
    case METHOD_DELETE:
      if (value_object == NULL) {
	return -1;
      }
      return 0;
    default:
      if (value_object == NULL) {
	return -1;
      }
      return (value_object->Accept(lex_code,mid));
    }
  }
  return -1;
}

PAccept(group)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch (mid){
    case METHOD_DRAW_ALL: case METHOD_HIDE_ALL:  case METHOD_WIRE_ALL:
    case METHOD_DRAW:     case METHOD_HIDE:      case METHOD_WIRE:
    case METHOD_ROTATION: case METHOD_LOCATION:
      return 0;
    case METHOD_MOVE:     case METHOD_ROTATE:
    case METHOD_SCALE:
      return 1;
    default:
      break;
    }
  }
  return -1;
}

PAccept(sphere)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch (mid){
    case METHOD_DRAW:     case METHOD_HIDE:       case METHOD_WIRE:
    case METHOD_ROTATION: case METHOD_LOCATION:
      return 0;
    case METHOD_MOVE:     case METHOD_ROTATE:
    case METHOD_SCALE:
      return 1;
    default:
      break;
    }
  }
  return -1;
}
PAccept(dot)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch (mid){
    case METHOD_DRAW:     case METHOD_HIDE:       case METHOD_WIRE:
    case METHOD_ROTATION: case METHOD_LOCATION:
      return 0;
    case METHOD_ANTIALIASES:    case METHOD_SMOOTHS:
    case METHOD_MOVE:     case METHOD_ROTATE:
    case METHOD_SCALE:
      return 1;
    default:
      break;
    }
  }
  return -1;
}

PAccept(segmant)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch (mid){
    case METHOD_DRAW:     case METHOD_HIDE:       case METHOD_WIRE:
    case METHOD_ROTATION: case METHOD_LOCATION:
      return 0;
    case METHOD_FROM:     case METHOD_TO:
    case METHOD_MOVE:     case METHOD_ROTATE:
    case METHOD_SCALE:
      return 1;
    case METHOD_ANTIALIASES:    case METHOD_SMOOTHS:
      return 1;
    default:
      break;
    }
  }
  return -1;
}

PAccept(mesh)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch (mid){
    case METHOD_DRAW:     case METHOD_HIDE:       case METHOD_WIRE:
    case METHOD_ROTATION: case METHOD_LOCATION:
      return 0;
    case METHOD_MOVE:    case METHOD_ROTATE:
    case METHOD_SCALE:
    case METHOD_SMOOTHS:  case METHOD_NURBS:       case METHOD_ANTIALIASES:
      return 1;
    default:
      break;
    }
  }
  return -1;
}

PAccept(line)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch (mid){
    case METHOD_DRAW:     case METHOD_HIDE:       case METHOD_WIRE:
    case METHOD_ROTATION: case METHOD_LOCATION:
      return 0;
    case METHOD_MOVE:     case METHOD_ROTATE:
    case METHOD_SCALE:    case METHOD_ANTIALIASES:  case METHOD_SMOOTHS:
    case METHOD_NURBS:
      return 1;
    default:
      break;
    }
  }
  return -1;
}

PAccept(text)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch (mid){
    case METHOD_DRAW:     case METHOD_HIDE:       case METHOD_WIRE:
    case METHOD_ROTATION: case METHOD_LOCATION:
      return 0;
    case METHOD_MOVE:     case METHOD_ROTATE:
    case METHOD_SCALE:
      return 1;
    default:
      break;
    }
  }
  return -1;
}

PAccept(box)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch (mid){
    case METHOD_DRAW:     case METHOD_HIDE:       case METHOD_WIRE:
    case METHOD_ROTATION: case METHOD_LOCATION:
      return 0;
    case METHOD_FROM:     case METHOD_TO:
    case METHOD_MOVE:     case METHOD_ROTATE:
    case METHOD_SCALE:
      return 1;
    default:
      break;
    }
  }
  return -1;
}

PAccept(cylinder)
{
  if ((lex_code == METHOD_NAME)||(lex_code == METHOD_ONLY_NAME)) {
    switch (mid){
    case METHOD_DRAW:     case METHOD_HIDE:       case METHOD_WIRE:
    case METHOD_ROTATION: case METHOD_LOCATION:
      return 0;
    case METHOD_MOVE:     case METHOD_ROTATE:
    case METHOD_SCALE:
      return 1;
    case METHOD_FROM:     case METHOD_TO:
      switch (type){
      case POL_CYLINDER0: case POL_PIPE0:         case POL_PILLAR0: 
      case POL_CONE:      case POL_CONIC:       case POL_PYRAMID:
	return 1;
      default:
	return -1;
      }
      break;
    default:
      break;
    }
  }
  return -1;
}

#endif /*_UN_USE_YACC_*/

