/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -*- Mode:C++ -*-                                 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <string.h>
#include <bstring.h>
#include <fcntl.h>
extern "C" {
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netdb.h>
};
#ifndef _DISABLE_GL_
#include <gl/gl.h>
#include <gl/device.h>
#include <gl/sphere.h>
#endif

#include "object.h"
#include "boolean.h"
#include "exit.h"

#define DEFAULT_SOCKET_PORT 5000

#ifndef _DISABLE_GL_
extern float rvecs[4];
#else
extern const char* sys_name;
#endif
extern lex_initialize();
extern int file_discript;
extern int is_read_eof;
extern int term_dummy;
extern int yyparse();
extern int file_discript;
extern int is_read_eof;
extern char* buffer_top;
extern char* buffer_bottom;
extern int line_number;
extern const char *ver;
extern const char *date;

struct sockaddr_in inet_client;
struct sockaddr_in server;
int nameleng;
int is_on_socket;
unsigned long server_address;
unsigned int server_port;
int is_realtime_mode;
int is_load_file;
int is_inet_domain;
int is_data_gram;
int is_unix_domain;
char* file_name;
static char ret[BUFSIZ];
int is_sync;

/* for -geometry */
int is_w_pos_set;
int wlx;
int wly;
int wrx;
int wry;

char* strapp (char* s1,const char* s2) 
{
  for (;*s2 != '\0';s1++,s2++) {
    *s1 = *s2;
  }
  *s1 = '\0';
  return s1;
}

unsigned long getinetaddrbyname(char* s)
     //{}
     // ۥ̾饤󥿡ͥåȥɥ쥹֤
     //{}
{
#ifdef DEBUG
  fprintf(stderr,"unsigned long getinetaddrbyname(char* %s)\n",s);
#endif
  char str[BUFSIZ];  
  char strbuff[BUFSIZ];  
  struct hostent* ep;
  if((ep = gethostbyname(s)) == NULL){
    herror((char*)ep);
    exit(1);
  }
  memset(str,0,BUFSIZ);
  char* sp;
  sprintf(strbuff,"%d\0",(ep->h_addr_list[0][0]));
  sp = strapp(str,strbuff);
  for (int c = 1;c < (ep->h_length);c++) {
    sprintf(strbuff,".%d\0",(ep->h_addr_list[0][c]));
    sp = strapp(sp,strbuff);
  }
  return inet_addr(str);
}

int user_main(int argc,char** argv)
     // {}
     // ޥɥ饤β
     // {}
{
#ifdef DEBUG
  fprintf(stderr,"int user_main(int %d,char** %x)\n",argc,(unsigned int)argv);
#endif

  is_sync = FALSE;
  is_on_socket = FALSE;	
  is_inet_domain = FALSE;
  is_unix_domain = FALSE;
  is_data_gram = FALSE;
  is_realtime_mode = FALSE;
  is_load_file = FALSE;

  /* for -geometry */
  is_w_pos_set = FALSE;

  server_port = DEFAULT_SOCKET_PORT+1;
  char *wp = getenv("HOST");
  server_address = getinetaddrbyname(wp);
  for (int cc = 1;cc < argc;cc++) {
#ifndef _DISABLE_GL_
    if (!strcmp(argv[cc],"-wlocate")) {
    cc++;
    wlx = atoi(argv[cc]);cc++;
    wly = atoi(argv[cc]);cc++;
    wrx = atoi(argv[cc]);cc++;
    wry = atoi(argv[cc]);
    is_w_pos_set = TRUE;
    }else 
#endif
    if (!strcmp(argv[cc],"-xyzw")) {
#ifndef _DISABLE_GL_
      cc++;
      rvecs[0] = atof(argv[cc]);
      cc++;
      rvecs[1] = atof(argv[cc]);
      cc++;
      rvecs[2] = atof(argv[cc]);
      cc++;
      rvecs[3] = atof(argv[cc]);
#endif
    }else if (!strcmp(argv[cc],"-help")) {
#ifndef _DISABLE_GL_
      fprintf(stderr,"3D-view Ver%s\n%s\n",ver,date);
      fprintf(stderr,"option :\n");
      fprintf(stderr," -help : print this.\n");
      fprintf(stderr," -ver  : print version only.\n");
      fprintf(stderr," -RT   : always synchronize mode.\n");
      fprintf(stderr," -Inet : using socket transmission at Inet domain.\n");
      fprintf(stderr," -SPort number : server socket port number.\n");
      fprintf(stderr," -xyzw x y z   : set initial rotate\n");
      exit(0);
#else
      extern void usage(void);
      usage();
#endif
    }else if (!strcmp(argv[cc],"-ver")) {
#ifndef _DISABLE_GL_
      fprintf(stderr,"3D-view Ver%s\n%s\n",ver,date);
      exit(0);
#else
      fprintf(stderr,"%s Ver%s\n%s\n",sys_name,ver,date);
      exit(0);
#endif
    }else if (!strcmp(argv[cc],"-SPort")) {
#ifndef _DISABLE_GL_
      cc++;
      server_port = (unsigned int)atoi(argv[cc]);
    }else if (!strcmp(argv[cc],"-Inet")) {
      is_inet_domain = TRUE;
      /*}else if (!strcmp(argv[cc],"-DG")) {*/
      /*is_data_gram = TRUE;*/
      /*Data Gram ̿ξ硢ǸΥ쥳ɤɤळȤǤʤ*/
      /* Τǡ̿ϡ3dviewˤϼʤ*/
    }else if (!strcmp(argv[cc],"-Unix")) {
      //is_unix_domain = TRUE;
    }else if (!strcmp(argv[cc],"-RT")) {
      is_realtime_mode = TRUE;
    } else {
      is_load_file = TRUE;
      file_name = argv[cc];
    }
#else
    }else if (!strcmp(argv[cc],"-3D")) {
      cc++;
      is_load_file = TRUE;
      file_name = argv[cc];
    } else {
      /* Protein-Talk⤷PDBե뤬ꤵ줿 */
    }
#endif
  }
  return 0;
}

char* find_file(const char* env,const char* name)
     //{}
     // եθʴĶѿPATHǥ쥯ȥ롣
     //{}
{
#ifdef DEBUG
  fprintf(stderr,"char* find_file(const char* %s,const char* %s)\n",env,name);
#endif

  int colon=0;
  for(int i=0; i<strlen(env); ++i){
    if(env[i] == ':') colon++;
  }
  char* ret;
  ret = new char[128];

  sprintf(ret,"%s/%s",strcpy(ret,strtok((char*)env,":")),name);
  if (access(ret,R_OK) == 0) return ret;

  /* Ȥˤʤä */
  for(i=0;i<colon;++i){
    sprintf(ret,"%s/%s",strcpy(ret,strtok(NULL,":")),name);
    if (access(ret,R_OK) == 0) return ret;
  }
  return (char*)0;
}

int open_socket()
     //{}
     // åȤ򥪡ץ󤹤롣
     //{}
{
#ifdef DEBUG
  fprintf(stderr,"int open_socket()\n");
#endif
  if (is_load_file) {
#ifdef DEBUG
    fprintf(stderr," open file\n");
#endif
    char* pathenv = getenv("PATH");
    char* load_file;
    if ((load_file = find_file(pathenv,file_name)) == (char*)0) {
      fprintf(stderr,"parameter file %s not found \n",load_file);
      error_exit ();
    }
    int s = open (load_file,O_RDONLY);; 
#ifdef DEBUG
    fprintf(stderr,"return %d\n",s);
#endif
    return s;
  }
  if (is_inet_domain) {
#ifdef SOCKET_DEBUG
    fprintf(stderr,"open_socket\n");
#endif
    int s;
    int ns;
    int sock_mode = SOCK_STREAM;
    if (is_data_gram)sock_mode = SOCK_DGRAM;
    if ((s = socket(PF_INET,sock_mode,0))<0) {
      fprintf(stderr,"Fatal:\nSyscall error send\n");
      error_exit ();
    }
#ifdef SOCKET_DEBUG
    fprintf(stderr,"socket passed\n");
#endif
    server.sin_family = PF_INET;
    server.sin_port = htons(server_port);
    server.sin_addr.s_addr = htonl(server_address);
    bzero(server.sin_zero,8);
    if (bind(s,(struct sockaddr*)&server,sizeof(server))<0) {
      fprintf(stderr,"Fatal : \nSyscall fatal bind\n");
      error_exit ();
    }
#ifdef SOCKET_DEBUG
    fprintf(stderr,"bind passed\n");
#endif
    if (is_data_gram) {
#ifdef DEBUG
      fprintf(stderr,"return %d\n",s);
#endif
      is_on_socket = TRUE;
      return s;
    }
    if (listen(s,5)<0) {
      fprintf(stderr,"Fatal : \nSyscall fatal listen\n");
      error_exit ();
    }
#ifdef SOCKET_DEBUG
    fprintf(stderr,"listen passed\n");
#endif
    nameleng = sizeof(inet_client);
    if ((ns = accept(s,(struct sockaddr*)&inet_client,&nameleng))<0) {
      fprintf(stderr,"Fatal : \nSyscall fatal accept\n");
      error_exit ();
    }
    close(s);
#ifdef SOCKET_DEBUG
    fprintf(stderr,"accept passed\n");
    fprintf(stderr,"return_value %d\n",ns);
#endif
    is_on_socket = TRUE;
    return ns;
  }
#ifdef DEBUG
  fprintf(stderr,"return 0\n");
#endif
  return 0;
}

void load_initial_file()
     //{}
     // .3dviewɤ߹ࡣ
     //{}
{
#ifdef DEBUG
  fprintf(stderr,"void load_initial_file()\n");
#endif
  line_number = 1;
  char* pathenv = getenv("PATH");
  /* fprintf(stderr, "path: [%s]\n", pathenv); */
  char* load_file;
  if ((load_file = find_file(pathenv,".3dview")) == (char*)0) {
    fprintf(stderr,"parameter file .3dview not found \n");
    error_exit ();
  }
  int fd;
  if ((fd = open (load_file,O_RDONLY))) {
    lex_initialize();
    file_discript = fd;
    while((!is_read_eof)) {
      yyparse();
    }
  }
  line_number = 1;
  file_discript  = open_socket() ;
  is_read_eof = FALSE;
  term_dummy = FALSE;
}

void interpriter() 
     //{}
     // stdin,file,socketΤ줫ɤࡣ
     // ⤷-RTꤵƤʤ顢ʸ¹Ԥ٤ɽ롼פȴ롣
     //{}
{
#ifdef DEBUG
  fprintf(stderr,"void interpriter() \n");
#endif
  if (is_read_eof)
    return;
  fd_set fdsel;
  struct timeval wt;
  wt.tv_sec  = 0L; 
  wt.tv_usec = 0L;
  int yy_ans;
  if (((buffer_top+1) == buffer_bottom)||((buffer_top-1023) == buffer_bottom)) {
    FD_ZERO(&fdsel);
    FD_SET(file_discript,&fdsel);
    select(FD_SETSIZE,&fdsel,(fd_set*)0,(fd_set*)0,&wt);
    if (FD_ISSET(file_discript,&fdsel)) {
      if (is_realtime_mode) { /* -RT */
#ifdef DEBUG
	fprintf(stderr,"int yyparse()\n");
#endif
	yy_ans = yyparse();
      }else{
	int nb;
	nb = 0;
	ioctl(file_discript,FIONREAD,&nb);
	if (nb > 0) {
#ifdef DEBUG
	  fprintf(stderr,"able to read%d\n",nb);
	  fprintf(stderr,"int yyparse()\n");
#endif	
	  yy_ans = yyparse();
	  if (buffer_top == buffer_bottom)return;
	  if (((buffer_top+1) == buffer_bottom)||((buffer_top-1023) == buffer_bottom)) return;
	}
	for (;;) {
#ifdef DEBUG
	  fprintf(stderr,"int yyparse()\n");
#endif	
	  yy_ans = yyparse();
	  if (buffer_top == buffer_bottom)break;
	  if (((buffer_top+1) == buffer_bottom)||((buffer_top-1023) == buffer_bottom)) break;
	  if (is_sync){
	    is_sync = FALSE;
	    break;
	  }
	}
      }
    }
  } else {
    if (is_realtime_mode) {
#ifdef DEBUG
      fprintf(stderr,"int yyparse()\n");
#endif
      yy_ans = yyparse();
    }else{
      for (;;) {
#ifdef DEBUG
	fprintf(stderr,"int yyparse()\n");
#endif
	yy_ans = yyparse();
	if (buffer_top == buffer_bottom)break;
	if (((buffer_top+1) == buffer_bottom)||((buffer_top-1023) == buffer_bottom)) break;
	if (is_sync){
	  is_sync = FALSE;
	  break;
	}
      }
    }
  }
}





