;lerror.scm
;SLaTeX v. 2.2
;Display and error routines
;(c) Dorai Sitaram, Rice U., 1991, 1994

(module SLaTeX.)

(local *return* *tab* error exit-scheme)

;;#\newline and #\space are r4rs
;;#\return and #\tab aren't

(define *return* (integer->char 13))
(define *tab* (integer->char 9))

(extract-if (chez elk schemetoc scm)
  (define error
    (lambda (error-type . error-values)
      (display "Error: ")
      (display error-type)
      (display ": ") (newline)
      (for-each (lambda (x) (write x) (newline)) error-values)
      ((global$ error) #f ""))))

(extract-if-not (chez elk schemetoc scm)
  (define error
    (lambda (error-type error-value)
      (display "Error: ")
      (display error-type)
      (display ": ") (newline)
      (for-each (lambda (x) (write x) (newline)) error-values)
      ((global$ error) ""))))

(extract-if (cl)
  (if (not (fboundp 'exit))
      (define exit-scheme
	(if (fboundp 'bye) bye
	  (lambda ()
	    (display "You may exit CL now!")
	    (newline)
	    (barf))))))

(extract-if (cscheme)
  (define exit-scheme %exit))

(extract-if (scm)
  (define exit-scheme quit))

(extract-if (chez elk pcsge schemetoc umbscheme)
  (define exit-scheme exit))

(extract-if (other)
  (define exit-scheme
    (lambda ()
      (display "Exit Scheme!")
      (newline)
      (barf))))
