;fileproc.ss
;SLaTeX Version 2.2
;File-manipulation routines used by SLaTeX
;(c) Dorai Sitaram, Rice U., 1991, 1994

(module SLaTeX.)

(local file-exists? delete-file force-output)

;file-exists?

(extract-if (cl)
    (define file-exists? probe-file))

(extract-if (chez cscheme elk pcsge scm)
    (define file-exists? (global$ file-exists?)))

(extract-if-not (chez cl cscheme elk pcsge scm)
    (define file-exists? (lambda (f) #t))) ;assume file exists

;delete-file

(extract-if (chez cl cscheme pcsge scm)
  (define delete-file (global$ delete-file)))

(extract-if (schemetoc umbscheme)
  (define delete-file
    (lambda (f)
      (call-with-output-file f
	(lambda (p) 'file-deleted)))))

(extract-if-not (chez cl cscheme pcsge schemetoc scm umbscheme)
  (define delete-file (lambda (f) 'assume-file-deleted)))

;force-output

;the DOS version of C Scheme has flush-output, the Unix version doesn't

(extract-if (scm cl)
  (define force-output (global$ force-output)))

(extract-if (cscheme)
  (define force-output
    (if (environment-bound? user-initial-environment 'flush-output)
	flush-output
	(lambda z 'assume-output-forced))))

(extract-if (elk)
  (define force-output flush-output-port))

(extract-if (chez)
  (define force-output flush-output))

(extract-if-not (chez cl cscheme elk scm)
  (define force-output (lambda z 'assume-output-forced)))
