;batconfg.scm
;Configures SLaTeX batfile/shellscript (Scheme version)
;(c) Dorai Sitaram, Rice U., 1991, 1994

(define *dialect* 'forward)
(define *op-sys* 'forward)
(define *scheme-pathname* 'forward)
(define *slatex-pathname* 'forward)
(define *texinputs* 'forward)
(define *accepts-echo* 'forward)
(define *accepts-cmdline-file* 'forward)
(define *accepts-initfile* 'forward)
(define *system-procedure* 'forward)

(call-with-input-file "config.dat"
  (lambda (ip)
    (set! *dialect* (read ip))
    (set! *op-sys* (read ip))
    (set! *scheme-pathname* (read ip))
    (set! *slatex-pathname* (read ip))
    (set! *texinputs* (read ip))
    (set! *accepts-echo* (read ip))
    (set! *accepts-cmdline-file* (read ip))
    (set! *accepts-initfile* (read ip))
    (set! *system-procedure* (read ip))
  ))

(if (not (memq *op-sys* '(dos unix other)))
    (set! *op-sys* 'other))

(define *file-deleter*
  (if (eq? *op-sys* 'dos) "del" "rm"))

(newline)
(display "Beginning configuring batfile/shellscript")
(display  " -- wait...")
(newline)

(define *echo-delim*
  (cond ((eq? *op-sys* 'dos) "")
        (else "'")))

(define *arg-mark*
  (cond ((eq? *op-sys* 'dos) "%")
        (else "$")))

(define *call-for-bat*
  (cond ((eq? *op-sys* 'dos) "call ")
	(else "")))

(define bat-file (if (eq? *op-sys* 'dos) "slatex.bat" "slatex"))

(if (memq *dialect* '(chez cscheme scm))
    (if (file-exists? bat-file)
	(delete-file bat-file)))

(call-with-output-file bat-file
  (lambda (op)
    (if (eq? *op-sys* 'dos)
        (begin (display "@echo off" op)
          (newline op)))

    (cond ((and *accepts-echo* (eq? *op-sys* 'unix))
	;dos echos can't handle longish s-exps
           (display "echo '(load " op)
           (write *slatex-pathname* op)
           (display ")" op)
           (display "(set! SLaTeX.*texinputs* " op)
           (write *texinputs* op)
           (display ")" op)
           (display "(SLaTeX.process-main-tex-file \"'$1'\")" op)
           (display "|" op)
           (display *scheme-pathname* op)
           (newline op))
	  (*accepts-cmdline-file*
            (display "echo " op)
            (display *echo-delim* op)
            (display "(load " op)
            (write *slatex-pathname* op)
            (display ")" op)
            (display *echo-delim* op)
            (display " >slatex.jnk" op)
            (newline op)

            (display "echo " op)
            (display *echo-delim* op)
            (display "(set! SLaTeX.*texinputs* " op)
            (write *texinputs* op)
            (display ")" op)
            (display *echo-delim* op)
            (display " >>slatex.jnk" op)
            (newline op)

            (display "echo " op)
            (display *echo-delim* op)
            (display "(SLaTeX.process-main-tex-file \"" op)
            (display *echo-delim* op)
            (display *arg-mark* op)
            (display 1 op)
            (display *echo-delim* op)
            (display "\")" op)
            (display *echo-delim* op)
            (display " >>slatex.jnk" op)
            (newline op)

            (display "echo " op)
            (display *echo-delim* op)
            (display "(SLaTeX.exit-scheme)" op)
            (display *echo-delim* op)
            (display " >>slatex.jnk" op)
            (newline op)

            (display *call-for-bat* op)
            (display *scheme-pathname* op)
            (display " slatex.jnk" op)
            (newline op)

            (display *file-deleter* op)
            (display " slatex.jnk" op)
            (newline op))
	  (*accepts-initfile*
            (display "echo " op)
            (display *echo-delim* op)
            (display "(load " op)
            (write *slatex-pathname* op)
            (display ")" op)
            (display *echo-delim* op)
            (display " > "  op)
            (display *accepts-initfile*)
            (newline op)

            (display "echo " op)
            (display *echo-delim* op)
            (display "(set! SLaTeX.*texinputs* " op)
            (write *texinputs* op)
            (display ")" op)
            (display *echo-delim* op)
            (display " >> " op)
            (display *accepts-initfile* op)
            (newline op)

            (display "echo " op)
            (display *echo-delim* op)
            (display "(SLaTeX.process-main-tex-file \"" op)
            (display *echo-delim* op)
            (display *arg-mark* op)
            (display 1 op)
            (display *arg-mark* op)
            (display "\")" op)
            (display *echo-delim* op)
            (display " >> " op)
            (display *accepts-initfile* op)
            (newline op)

            (display "echo " op)
            (display *echo-delim* op)
            (display "(SLaTeX.exit-scheme)" op)
            (display *echo-delim* op)
            (display " >> " op)
            (display *accepts-initfile* op)
            (newline op)

            (display *call-for-bat* op)
            (display *scheme-pathname* op)
            (newline op)

            (display *file-deleter* op)
            (display " " op)
            (display *accepts-initfile* op)
            (newline op))
	  (else
            (newline)
            (display "Your Scheme/system interface isn't ")
            (display "very cooperative -- use callsla.scm")
            (newline)))

    (cond ((eq? *op-sys* 'dos)
           (display "if exist pltexchk.jnk goto one" op)
           (newline op)
	   (display "goto two" op)
           (newline op)
	   (display ":one" op)
           (newline op)
           (display "call tex %1" op)
           (newline op)
           (display "del pltexchk.jnk" op)
           (newline op)
           (display "goto end" op)
           (newline op)
           (display ":two" op)
           (newline op)
           (display "call latex %1" op)
           (newline op)
           (display ":end" op)
           (newline op))
	  (else
            (display "if test -f pltexchk.jnk" op)
            (newline op)
            (display "then tex $1; rm pltexchk.jnk" op)
            (newline op)
            (display "else latex $1" op)
            (newline op)
            (display "fi" op)
            (newline op)))))

(if (memq *dialect* '(chez cscheme pcsge scm))
    (if (file-exists? "callsla.scm")
	(delete-file "callsla.scm")))

(call-with-output-file "callsla.scm"
  (lambda (p)
    (display "(define call-slatex" p)
    (display "(let ((slatex-not-loaded? #t))" p)
    (display "(lambda (tex-file)" p)
    (display "(if slatex-not-loaded?" p)
    (display "(begin (display \"Loading slatex...\")" p)
    (display "(load " p)
    (write *slatex-pathname* p)
    (display ")" p)
    (display "(display 'done) (newline)" p)
    (display "(set! SLaTeX.*texinputs* " p)
    (write *texinputs* p)
    (display ")" p)
    (display "(set! slatex-not-loaded? #f)))" p)
    (display "(SLaTeX.process-main-tex-file tex-file)" p)
    (display "(newline)" p)
    (if *system-procedure*
        (begin
          (display "(system (string-append " p)
          (display "(if SLaTeX.*latex?* \"latex \" \"tex \")" p)
          (display "tex-file" p)
          (display "))" p))
        (begin
          (display "(display \"Call (la)tex on \")" p)
          (display "(display tex-file)" p)
          (display "(newline)" p)))
    (display "#t)))" p)))

(newline)
(display "Finished configuring batfile/shellscript")
(newline)
(if (eq? *op-sys* 'unix)
    (begin
      (display "Type (chmod +x slatex) on Unix command line")
      (newline)))
