/*
 * cr-prim.c -- Implementation of coroutine primitives
 *
 * (C) m.b (Matthias Blume); HUB; Sep 1993 PU/CS
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) cr-prim.c (C) M.Blume, Princeton University, 2.2"
 */

# ident "@(#)cr-prim.c	(C) M.Blume, Princeton University, 2.2"

# include <assert.h>
# include <stdio.h>

# include "storage.h"
# include "Corout.h"
# include "Cont.h"
# include "Procedure.h"
# include "except.h"

# include "type.h"

# include "builtins.tab"

/* Primitive No. 4 */
unsigned ScmVMCoroutine (unsigned argcnt)
{
  fatal ("internal error (ScmVMCoroutine called)");
}

unsigned ScmVMCoroutineC (void)
{
  /* ``transfer'' to main coroutine */
  void *val = PEEK ();
  ScmDirtyModeCache (-1);
  ScmCC = ScmMainCorout->state;
  ScmCurrentCorout->state = ScmMainCorout->state = NULL;
  ScmCurrentCorout = ScmMainCorout;
  SET_TOP (val);
  return 0;
}

unsigned ScmPrimitiveCrCreate (unsigned argcnt)
{
  void *tmp;

  tmp = PEEK ();
  if (ScmTypeOf (tmp) != ScmType (Procedure))
    error ("arg to cr-create is not a compiled lambda: %w", tmp);
  tmp = ScmNewCorout (tmp);
  SET_TOP (tmp);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveCrTransfer (unsigned argcnt)
{
  void *vcr, *val;
  ScmCorout *cr;

  vcr = POP ();
  val = PEEK ();
  if (ScmTypeOf (vcr) != ScmType (Corout))
    error ("bad coroutine arg to primitive cr-transfer: %w", vcr);
  cr = vcr;
  if (cr->state == NULL)
    error ("coroutine arg to primitive cr-transfer is invalid: %w", cr);
  assert (cr != ScmCurrentCorout);
  ScmDirtyModeCache (-1);
  ScmCurrentCorout->state = ScmCC; /* store old state */
  ScmCC = cr->state;		/* set new state */
  cr->state = NULL;		/* invalidate coroutine */
  ScmCurrentCorout = cr;	/* make coroutine valid */
  SET_TOP (val);
  return 0;
}

unsigned ScmPrimitiveCrSelf (unsigned argcnt)
{
  Push (ScmCurrentCorout);
  return 0;
}
