/*
 * String.c -- Implementation of Scheme Strings
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) String.c (C) M.Blume, Princeton University, 2.5"
 */

# ident "@(#)String.c	(C) M.Blume, Princeton University, 2.5"

# include <stdio.h>
# include <ctype.h>
# include <string.h>

# include "storext.h"
# include "String.h"
# include "identifier.h"
# include "type.h"
# include "except.h"

static MEM_cnt measure (void *vstrg)
{
  return MEM_UNITS (sizeof (ScmString) + ((ScmString *)vstrg)->length - 1);
}

static void dumper (void *vstring, FILE *file)
{
  ScmString *string = (ScmString *) vstring;
  unsigned i;

  MEM_dump_ul (string->length, file);
  for (i = 0; i < string->length; i++)
    putc (string->array[i], file);
}

static void *excavator (FILE *file)
{
  ScmString *string;
  unsigned i, c;
  unsigned length;

  length = MEM_restore_ul (file);
  SCM_VNEW (string, String, length, char);
  string->length = length;
  for (i = 0; i < length; i++)
    if ((c = getc (file)) == EOF)
      fatal ("bad dump file format (String)");
    else
      string->array[i] = c;
  return string;
}
 
static
void write_this (void *vstring, putc_proc pp, void *cd)
{
  ScmString *string = vstring;
  unsigned i;
  int c;

  (* pp) ('\"', cd);
  for (i = 0; i < string->length; i++)
    switch (c = (unsigned char) string->array[i]) {
    case '\t':
      (* pp) ('\\', cd);
      (* pp) ('t', cd);
      break;
    case '\n':
      (* pp) ('\\', cd);
      (* pp) ('n', cd);
      break;
    case '\r':
      (* pp) ('\\', cd);
      (* pp) ('r', cd);
      break;
    case '\b':
      (* pp) ('\\', cd);
      (* pp) ('b', cd);
      break;
    case '\a':
      (* pp) ('\\', cd);
      (* pp) ('a', cd);
      break;
    case '\v':
      (* pp) ('\\', cd);
      (* pp) ('v', cd);
      break;
    case '\\':
      (* pp) ('\\', cd);
      (* pp) ('\\', cd);
      break;
    case '\"':
      (* pp) ('\\', cd);
      (* pp) ('\"', cd);
      break;
    default:
      if (isprint (c))
	(* pp) (c, cd);
      else {
	char buf[16];
	sprintf (buf, "\\%03o", (unsigned char)c);
	putc_string (buf, pp, cd);
      }
      break;
    }
  (* pp) ('\"', cd);
}

static
void display (void *vstring, putc_proc pp, void *cd)
{
  ScmString *string = vstring;
  unsigned i;

  for (i = 0; i < string->length; i++)
    (* pp) (string->array[i], cd);
}

static
int equal (void *vself, void *vother)
{
  ScmString *self, *other;

  if (ScmTypeOf (vother) != ScmType (String))
    return 0;
  self = vself;
  other = vother;
  if (self->length != other->length)
    return 0;
  return memcmp (self->array, other->array, self->length) == 0;
}

MEM_VECTOR (String,
	    0, measure,
	    MEM_NULL_iterator, dumper, excavator, MEM_NULL_revisor,
	    MEM_NULL_task, MEM_NULL_task, MEM_NULL_task,
	    EXT (SCM_NO_NUMBER,
		 cannot_cvt_real, display, write_this, equal, equal));
