/*
 * Port.h -- Declarations for Scheme ports
 *
 * (C) m.b (Matthias Blume); May 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) Port.h (C) M.Blume, Princeton University, 2.4"
 */

# ifndef PORT_H_
# define PORT_H_

# include "storage.h"

typedef struct ScmPort ScmPort;
DCL_MEM_TYPE (Port);

extern int ScmPortAllowsInput (ScmPort *port);
extern int ScmPortAllowsOutput (ScmPort *port);

extern FILE *ScmPortToStreamPtr (ScmPort *port);

/*
 * Create ordinary file ports using <stdio.h>
 *  the arguments are:
 *   - name -> name of file to be opened
 *   - b    -> (0 -> text file, 1 -> binary file)
 *   - udt  -> (0 -> no update, 1 -> update)
 */
extern ScmPort *ScmOpenInputFile  (const char *name, int b, int udt);
extern ScmPort *ScmOpenOutputFile (const char *name, int b, int udt);
extern ScmPort *ScmOpenAppendFile (const char *name, int b, int udt);

extern ScmPort *ScmOpenTemporaryFile (void);

/*
 * Create generic input port.  The arguments are thunks for
 *   read, read-char, peek-char, char-ready?, and close-input-port.
 */
extern ScmPort *ScmOpenInputGeneric
  (void *, void *, void *, void *, void *);

/*
 * Create generic output port.  The arguments are
 *   - a procedure for write (1 arg)
 *   - a procedure for display (1 arg)
 *   - a procedure for write-char (1 arg)
 *   - a procedure for newline (0 arg)
 *   - a procedure for flush (0 arg)
 *   - a procedure for close-output-port (0 arg)
 */
extern ScmPort *ScmOpenOutputGeneric
  (void *, void *, void *, void *, void *, void *);

extern ScmPort *ScmStdinPort;
extern ScmPort *ScmStdoutPort;
extern ScmPort *ScmStderrPort;

/*
 * The following procedures leave their result on top of the stack...
 */
extern unsigned ScmPortRead       (ScmPort *port);
extern unsigned ScmPortReadChar   (ScmPort *port);
extern unsigned ScmPortPeekChar   (ScmPort *port);
extern unsigned ScmPortCharReadyP (ScmPort *port);

extern unsigned ScmPortWrite      (ScmPort *port, void *obj);
extern unsigned ScmPortDisplay    (ScmPort *port, void *obj);
extern unsigned ScmPortWriteChar  (ScmPort *port, void *obj);
extern unsigned ScmPortNewline    (ScmPort *port);
extern unsigned ScmPortFlush      (ScmPort *port);

extern unsigned ScmPortClose      (ScmPort *port);

/*
 * Seek and Tell is defined for file ports only:
 *  whence == #t  ->  SEEK_SET
 *  whence == #f  ->  SEEK_END
 *  else          ->  SEEK_CUR
 */
extern long ScmPortSeekAndTell (ScmPort *port, long offset, void *whence);

# endif
