/*
 * Numeric.h -- Declarations for Scheme's numeric data types
 *
 * (C) m.b (Matthias Blume); May 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) Numeric.h (C) M.Blume, Princeton University, 2.4"
 */

# ifndef NUMERIC_H_
# define NUMERIC_H_

# include "storage.h"

typedef struct ScmFixnum ScmFixnum;
DCL_MEM_TYPE (Fixnum);

typedef struct ScmFraction ScmFraction;
DCL_MEM_TYPE (Fraction);

typedef struct ScmReal ScmReal;
DCL_MEM_TYPE (Real);

typedef struct ScmComplex ScmComplex;
DCL_MEM_TYPE (Complex);

extern long ScmNumberToLong (void *, const char *);
extern unsigned long ScmNumberToULong (void *, const char *);
extern void *ScmLongToNumber (long);

extern unsigned int ScmNumberToUShort (void *, const char *);
/* get only the last ``big digit'' (or less) of a non-negative number */

extern int ScmNumberIsEven (void *, const char *);
extern void *ScmAtan2 (void *, void *);

/* string (need not be NUL-terminated), length, default-base */
extern void *ScmParseNumberString (const char *s, int l, int b);

extern void ScmQuotRem (void *x, void *y, void **q, void **r, const char *s);
/* q == NULL -> no quotient, r == NULL -> no remainder */

extern void *ScmNewRealComplex (double re, double im);

extern char *ScmUnparseNumber (void *x, int base);
/* returns a pointer to static memory */

# endif
