/*
 * Cell.c -- Implementation of Scheme Value Cells
 *
 * (C) m.b (Matthias Blume); Jan 1993 PU/CS
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) Cell.c (C) M.Blume, Princeton University, 2.3"
 */

# ident "@(#)Cell.c		(C) M.Blume, Princeton University, 2.3"

# include <stdio.h>

# include "storext.h"
# include "Cell.h"
# include "identifier.h"
# include "type.h"

static void iterator (void *vcell, MEM_visitor proc, void *cd)
{
  ScmCell *cell = vcell;

  (*proc) ((void *)&cell->item, cd);
}

static void display (void *vcell, putc_proc pp, void *cd)
{
  ScmCell *cell = vcell;

  (* pp) ('#', cd);
  (* pp) ('<', cd);
  display_object (cell->item, pp, cd);
  (* pp) ('>', cd);
}

MEM_VECTOR (Cell,
	    MEM_UNITS (sizeof (ScmCell)), MEM_NULL_measure,
	    iterator, MEM_NULL_dumper, MEM_NULL_excavator, MEM_NULL_revisor,
	    MEM_NULL_task, MEM_NULL_task, MEM_NULL_task,
	    EXT (SCM_NO_NUMBER,
		 cannot_cvt_real, display, display, NULL_eq, NULL_eq));
