@part[STRUCTURE, root "TMAN.MSS"]	@Comment{-*-System:TMAN-*-}
@chap[Structures]


A structure corresponds to what is called a record in some other
languages: a data structure with a fixed set of named fields or slots,
known in @tau[] as @i[components].  For example, one might want an
@qu"employee" structure, with slots for the employee's name, age, and
salary.  A structure, then, is an organized set of @i[locations], places
to store things.
@index[Structures]

@dc{ Compare with use of @tc[LAMBDA] and @tc[OBJECT]. }


@section[Terminology]

Every structure has an associated an object called a @iixs[structure
type] (sometimes abbreviated @iix[stype], pronounced @qu"ess type").
Structure types are created by the procedure @tc[MAKE-STYPE] (see below)
and by the special form @tc[DEFINE-STRUCTURE-TYPE]

Given a structure type @i[S], one can access several things of interest:

@begin[Description]
Constructor@\a procedure that will create uninitialized structures of
  type @i[S] (e.g., the structure for a particular employee).

Predicator@\a procedure (a type predicate) that returns true if its
  argument is a structure of type @i[S].

Component selectors@\procedures that access the various components of
  structures of type @i[S] (one selector per component).

Handler@\the mechanism for specifying how a set of generic operations
  will behave when applied to structures of type @i[S].
@end[Description]

@dc{ mention the master copy also. }

@section[Defining structure types]

The @tc[DEFINE-STRUCTURE-TYPE] macro @dc{?}
is a convenient way to define a new structure type and its
associated constructor, predicator, and component selectors.
@tc[DEFINE-STRUCTURE-TYPE] is a macro defined in terms of @tc[MAKE-STYPE] and
the other low-level routines described in the next section.  One may
want to define one's own interface to these routines, one that
initializes the components when a new instance is constructed, for
example.

@AnEquivE[Tfn="DEFINE-STRUCTURE-TYPE",Efn="DEFSTRUCT"]
@AnEquivE[Tfn="DEFINE-STRUCTURE-TYPE",Efn="DEFVST"]
@AnEquivE[Tfn="DEFINE-STRUCTURE-TYPE",Efn="RECORD-TYPE"]
@info[NOTES="Special form"]
@desc[(DEFINE-STRUCTURE-TYPE @i[typename . componentnames]) @yl[] @i[stype]]
Creates a structure type (using @tc[MAKE-STYPE]),
and defines a number of variables:
@begin[Itemize]
@i[typename]@tc[-STYPE] is defined to be the structure type.

@tc[MAKE-]@i[typename] is defined to be the constructor.

@i[typename]@tc[?] is defined to be the predicator.

@i[typename]@tc[-]@i[componentname] is defined to be a component selector, for
each of the @i[componentnames].
@end[Itemize]
For example,
@begin[ProgramExample]
(DEFINE-STRUCTURE-TYPE EMPLOYEE NAME AGE SALARY)
@end[ProgramExample]
defines
@begin[Itemize]
@tc[EMPLOYEE-STYPE], a variable whose value is
the structure type whose name is @tc[EMPLOYEE].

@tc[(MAKE-EMPLOYEE)], a procedure that creates uninitialized
@tc[EMPLOYEE]-structures.

@tc[(EMPLOYEE? @i[object])], a type predicate.

@tc[(EMPLOYEE-NAME @i[employee])
@*(EMPLOYEE-AGE @i[employee])
@*(EMPLOYEE-SALARY @i[employee])], selectors that access the components of
@tc[EMPLOYEE]-structures.

@end[Itemize]
@EndDesc[DEFINE-STRUCTURE-TYPE]

@section[Manipulating structure types]

@desc[(MAKE-STYPE @i[typename componentnames]) @yl[] @i[stype]]
Returns a new structure type.  The @i[typename], which should be a
symbol, is used for printing and identification purposes only.
@i[Componentnames] should be a list of symbols.  The @i[componentnames]
correspond to the components that instances of the structure will have.

For example:
@begin[ProgramExample]
(MAKE-STYPE 'EMPLOYEE '(NAME AGE SALARY))  @ev[]  #{Stype EMPLOYEE}
@end[ProgramExample]
This creates a structure type, identified as @tc[EMPLOYEE],
whose instances have components @tc[NAME], @tc[AGE], and @tc[SALARY].
The object returned, a structure type, is appropriate as an argument to other
routines described in this section.
@EndDesc[MAKE-STYPE]

@desc[(STYPE-ID @i[stype]) @yl[] @i[typename]]
Returns the type identifier for @i[stype].
@EndDesc[STYPE-ID]

@desc[(STYPE-CONSTRUCTOR @i[stype]) @yl[] @i[procedure]]
Given a structure type @i[stype], returns the procedure which will
instantiate (i.e., create instances of) the structure type.  The
constructor procedure takes no arguments and creates a structure with
uninitialized components.

Note that the constructor procedure is created at the time the structure type
is created, not at the time that @tc[STYPE-CONSTRUCTOR] is called.
@begin[ProgramExample]
((STYPE-CONSTRUCTOR @i[stype]))  @ce[]  (COPY-STRUCTURE (STYPE-MASTER @i[stype]))
@end[ProgramExample]
@EndDesc[STYPE-CONSTRUCTOR]

@desc[(STYPE-MASTER @i[stype]) @yl[] @i[structure]]
Returns the @qu"master copy" from which all structures created by the
structure type's constructor-procedure are made.
This can be convenient for establishing default values for components in
newly created structures.  The way to do this is by storing into the
master copy the desired default values; these values will be copied
into all new instances of the structure type.  For example,
@ProgramExample[
(SET (EMPLOYEE-SALARY (STYPE-MASTER EMPLOYEE-STYPE)) 12000)
(EMPLOYEE-SALARY (MAKE-EMPLOYEE))  @ev[]  12000
]
@EndDesc[STYPE-MASTER]

@desc[(STYPE-PREDICATOR @i[stype]) @yl[] @i[procedure]]
Given a structure type @i[stype], returns the procedure (a type predicate)
which will predicate
membership in the structure type.  This procedure takes one
argument and returns true if that argument is an instance of the structure type.
@dc{(i.e., was created using the structure type's @tc[STYPE-CONSTRUCTOR]).}

Note that the predicator procedure is created at the time the structure type
is created, not at the time that @tc[STYPE-PREDICATOR] is called.
@EndDesc[STYPE-PREDICATOR]

@desc[(STYPE-SELECTOR @i[stype componentname]) @yl[] @i[procedure]]
Given a structure type @i[stype], returns the procedure which will
select the component of the structure type's instances identified by
@i[componentname].  The selector procedure takes one argument, which
must be a structure whose structure type is @i[stype], and returns the
appropriate component of the instance.

Such selector procedures support @tc[SETTER] operations, which is to say
that one may alter components of structures by using @tc[SET] or related
special forms.

The effect of selecting a structure component that has not been
previously set, or initialized from the master structure
(see @tc[STYPE-MASTER], above), is undefined.

Note that the selector procedures are created at the time the structure type
is created, not at the time that @tc[STYPE-SELECTOR] is invoked.
@EndDesc[STYPE-SELECTOR]

@desc[(STYPE-SELECTORS @i[stype]) @yl[] @i[list of procedures]]
Given a structure type @i[stype], returns a list of its selector procedures.
@EndDesc[STYPE-SELECTORS]

@desc[(SELECTOR-ID @i[selector]) @yl[] @i[identifier]]
Given a selector procedure, e.g., as returned by @tc[STYPE-SELECTOR],
returns its corresponding componentname.
@EndDesc[SELECTOR-ID]

@info[NOTES="Settable"]
@desc[(STYPE-HANDLER @i[stype]) @yl[] @i[handler]]
Given a structure type @i[stype], accesses the handler to be used
for generic operations applied to instances of the structure type.
For a newly created structure type, this handler handles
no operations, but one may set the handler to be any handler at all.
@dc{ Give example. }
@EndDesc[STYPE-HANDLER]

@section[Manipulating structures]

The primary means for manipulating structures is to call
their selector procedures and their setters.  For example, in the context
of the examples above, if @tc[EMPLOYEE-23] is an @tc[EMPLOYEE]-structure,
then @tc[EMPLOYEE-23]'s @tc[NAME] component may be retrieved
by evaluating
@ProgramExample[
(EMPLOYEE-NAME EMPLOYEE-23)
]
and this value may be set by evaluating
@ProgramExample[
(SET (EMPLOYEE-NAME EMPLOYEE-23) 'FRED)
]

This works because the selector procedures for @tc[EMPLOYEE-STYPE]
handle the generic operation called @tc[SETTER].
Structures may also be manipulated using other generic operations.
@dc{ as explained in the next section?? }

@info[Notes="Type predicate"]
@desc[(STRUCTURE? @i[object]) @yl[] @i[boolean]]
Returns true if @i[object] is a structure.
@EndDesc[STRUCTURE?]

@desc[(COPY-STRUCTURE @i[structure]) @yl[] @i[structure]]
Makes a copy of @i[structure].  The value returned is a new object
of the same structure type as @i[structure] whose components
are the same (in the @tc[EQ?] sense) as @i[structure]'s.
@EndDesc[COPY-STRUCTURE]

@desc[(COPY-STRUCTURE! @i[destination source]) @yl[] @i[structure]]
Copies the components of @i[source] into @i[destination], which
is returned.
@i[Source] and @i[destination] must be structures of the same type.
@EndDesc[COPY-STRUCTURE!]
