(eq? 1 (car '(1 2)))
(equal? '(2) (cdr '(1 2)))
(not (eq? '(2) (cdr '(1 2))))
(eq? 3 (caddr '(1 2 3 4)))

(equal? '(1 . 2) (cons 1 2))
(define a '(1 2))
(define b (copy a))
(set-car! a 2)
(set-cdr! a '(1))
(equal? (reverse a) b)
(equal? '(1) (last-pair a))
(eq? 2 (list-ref b 1))
(eq? 1 (nth 1 b))
(equal? '(2 3 4) (member 2 '(1 2 3 4)))
(eq? 2 (length a))
(delq! 1 a)
(equal? '(2) a)
(set! c '((1 2) (3 4)))
(equal? (transpose (transpose c)) c)

(null? ())
(not (eqv? 1 1.0))
(not (eq? 1 1.0))
(cdr (assq 2 '((1 . false) (2 . true) (3 . false))))

(atom? 'foo)
(boolean? true)
(not (boolean? 3))
(boolean? false)
(number? 5)
(rational? 5/3)
(string? "Abc")
(function? function?)
(char? #\a)
(not (char? 5))
(not (integer? 5.0))
(real? 5.0)
(pair? (cons 1 2))
(not (pair? ()))
(symbol? 'foo)
(not (symbol? 3))
(syntactic-extension? 'let)
(constant? 'pi)
(not (constant? 3))
(not (constant? 'a))
(complex? #C(1 2))
(not (real? #C(1 2)))

(add1 0)
(sub1 3)
(+ 1 2)
(* 2 2)
(- 8 3)
(factorial 3)
(/ 21 3)
(quotient 25 3)
(abs -9)
(minus -10)
(floor 11.8)
(ceiling 11.8)
(truncate 12.3)
(round 12.6)
(remainder 29 15)
(sqrt 225)
(numerator 16/17)
(denominator 16/17)
(real-part (make-rectangular 18 19))
(imag-part (make-rectangular 18 19))
(magnitude (make-polar 20 21))
(* 10 (angle (make-polar 20 2.1)))

(not (zero? 4))
(even? 4)
(odd? 3)
(not (odd? 4))
(positive? 5)
(negative? -5)
(not (<0 7))
(< 1 2)
(> 2 1)
(= 3 3.0)

(char=? #\a #\a)
(not (char=? #\a #\b))
(char-ci=? #\a #\A)
(char-alphabetic? #\a)
(char-numeric? #\3)
(char-upper-case? #\A)
(char-lower-case? #\a)
(eqv? #\a (char-downcase #\A))
(eqv? #\A (char-upcase #\a))

(string=? "a b c" "a b c")
(string-ci=? "a b c" "A b C")
(string>? "abc" "aac")
(= 3 (string-length "abc"))
(char=? #\a (string-ref "cba" 2))

(set! a (list->vector '(1 2 3 4 5 6 7 8 9)))
(vector? a)
(equal? (vector->list a) '(1 2 3 4 5 6 7 8 9))
(= 3 (vector-ref a 2))
(vector-set! a 2 10)
(= 10 (vector-ref a 2))
(= 9 (vector-length a))
(vector-fill! a 1)
(= 1 (vector-ref a 6))
(vector-ref (make-vector 5 t) 3)

(string->symbol "ABC")
(ascii->symbol 68)
(symbol->string 'EFG)
(= 67 (symbol->ascii 'C))
(= 67 (char->integer #\C))
(eq? #\C (integer->char 67))
(equal? '(#\a #\b #\c) (string->list "abc"))
(string=? "abc" (list->string '(#\a #\b #\c)))

(eof-object? eof)
(file-exists? "prim.ss")
