;(eval-when (compile) (proclaim '(optimize (speed 3) (safety 0) (space 2))))

(proclaim '(special core-ids fal temp temp1 host-macs tagged-id))
(proclaim '(special ellipsis))

(setq core-ids '(#!if #!lambda #! set!))

(defun identity (x) x)

(defun ormap (f l)
      (if (consp l)
	  (or (funcall f (car l)) (ormap f (cdr l)))))

(defun mapcar/atom (f l)
      (if (consp l)
	  (cons (funcall f (car l)) (mapcar/atom f (cdr l)))
	  l))

(eval-when (compile load)
(defmacro transform? (l)
	`(eq (car ,l) '&transform))

(defun st-lookup (id)
      (if (consp id)
	  (and (transform? id) id)
	  (get id 'beta-transform)))

(defmacro host-mac? (l)
	`(memq ,l host-macs))

(defmacro syntax? (l)
	`(and (symbolp ,l)
	      (st-lookup ,l)))

;case built into CL--macro still needs work, anyway
;(defmacro case (*pattern*)
;	(list 'let
;	     (list (list '*tag* (cadr *pattern*)))
;	     (cons 'cond
;		(mapcar (function
;			   (lambda (^00005)
;			      (cons
;				 (cond ((not (atom (car ^00005)))
;					(list 'memq '*tag*
;					   (list 'quote (car ^00005))))
;				       ((eq 'else (car ^00005)) t)
;				       (t (list 'eq
;					     (list 'quote (car ^00005))
;					     '*tag*)))
;				 (cdr ^00005))))
;		   (cddr *pattern*)))))

(defun runner (expander e body)
      (newnames
	 (funcall expander
	    (copy-no-constant-no-quote
		  (vsm-help
		        '((*pr &ms . apply) (*re))
			'((((*pr &ms . result))) nil)
			nil
			(list (list (tag-frees e nil)))
			body)))
	 nil))

(defun expand-type (f type e)
      (cond
	 ((host-mac? type) (funcall f (host-mac-dispatch e)))
	 ((eq type '#!lambda)
	  `(#!lambda ,(copy-tree (cadr e)) . ,(mapcar f (cddr e))))
	 ((eq type '#!if)
	  `(#!if . ,(mapcar f (cdr e))))
	 ((eq type '#!set!)
	  `(#!set! ,(cadr e) . ,(mapcar f (cddr e))))
	 ((eq type 'quote) e)
	 (t (cons type (mapcar/atom f (cdr e))))))

(defun walk/s-exp! (f l extra)
      (if (consp l)
	  (walk/box! f l extra)))

(defun walk/box! (f l extra)
      (rplaca l (funcall f (car l) extra))
      (let ((temp (cdr l))) 
	 (cond 
	    ((null temp) nil)
	    ((consp temp) (walk/box! f temp extra))
	    (t (rplacd l (funcall f temp extra))))))

(defun tag (id)
      (let ((p (make-symbol (concatenate 'string (symbol-name id) "-BETA"))))
	 (setf (get p 'istagged) id)
	 (setq fal (cons (cons id p) fal))
	 p))

(defun tag-frees (e keys)
      (case (scheme-type-of e)	 
	 (identifier
	    (cond 
	       ((memq e keys)	  e)
	       ((memq e core-ids) e)
	       ((eq e 'quote)	  e)
	       ((host-mac? e)	  e)
	       (t		  (let ((p (assq e fal)))
				    (if p
					(cdr p)
					(if (and (tagged? e)
						 (setq temp (untag* e)))
					    temp
					    (tag e)))))))
	 (combination
	    (cond ((atom (car e))
		   (let ((tform (syntax? (car e))))
		      (if tform
			  (walk/s-exp! 'tag-frees
				       (cdr e)
				       (append (cadr tform) keys))
			  (walk/s-exp! 'tag-frees e keys))))
		  ((transform? (car e))
		   (walk/s-exp! 
		      'tag-frees
		      (cdr e)
		      (append (cadar e) keys)))
		  (t (walk/s-exp! 'tag-frees e keys)))
	    e)
	 (constant e)
	 (t (walk/s-exp! 'tag-frees (cdr e) keys)
	       e)))
	  
(defun scheme-type-of (e)
      (cond
	 ((atom e)		(cond ((numberp e)	 'constant)
				      ((characterp e)    'constant)
				      ((memq e '(t nil)) 'constant)
				      ((stringp e)	 'constant)
				      (t		 'identifier)))
	 ((memq (car e) core-ids) (car e))
	 ((eq (car e) 'quote)	'quoted-exp)
	 ((proc? e)		'constant)
	 (t			'combination)))

(defun lexpand (e)
      (if (or (atom e) (proc? e))
	  e
	  (let	((temp (car e)))
		(cond
		     ((atom temp)
		      (let ((temp1 (syntax? temp)))
			 (if temp1
			     (runner  'lexpand2
				      (copy-no-constant e)
				      (caddr temp1))
			     (expand-type 'lexpand temp e))))
		     ((transform? (car e)) (runner
					      'lexpand2
					      (copy-no-constant e)
					      (caddar e)))
		     (t (mapcar/atom 'lexpand e))))))

(defun lexpand-no-copy (e)
      (if (or (atom e) (proc? e))
	  e
	  (let	((temp (car e)))
		(cond
		     ((atom temp)
		      (let ((temp1 (syntax? temp)))
			 (if temp1
			     (runner 'lexpand2 e (caddr temp1))
			     (expand-type 'lexpand-no-copy temp e))))
		     ((transform? (car e)) (runner 'lexpand2 e (caddar e)))
		     (t (mapcar/atom 'lexpand-no-copy e))))))
	  
(defun lexpand2 (e)
      (if (or (atom e) (proc? e))
	  e
	  (let	((temp (car e)))
		(cond
		     ((atom temp)
		      (if (st-lookup temp)
			  (beta-expand2 e)
			  (expand-type 'lexpand2 temp e)))
		     ((transform? (car e)) (beta-expand2 e))
		     (t (mapcar/atom 'lexpand2 e))))))

(defun newnames (e r)
      (case (scheme-type-of e)
	 (identifier (let ((pair (assq e r)))
			(if pair
			    (cdr pair)
			    (let ((i (get e 'istagged)))
				 (if i i e)))))
	 (constant e)	 
	 (quoted-exp
	    (if (atom (cdr e))
		(rplacd e (intern* (cdr e)))
		(rplaca (cdr e) (intern* (cadr e))))
	    e)
	 (#!lambda
	    (let ((c1 (cdr e)))		
	       (let ((args (let ((a (car c1)))
			      (cond ((null a) a)
				    ((atom a) (cons a nil))
				    (t	      (legal-args a nil))))))
		  (prog (temp args*)
			(setq args* args)
			loop (if (null args*)
				 (return nil))
			     (setq temp (assq (car args*) r))
			     (if temp
				 (setq r (delq temp r)))
			     (setq args* (cdr args*))
			     (go loop))
		  (let ((newrib (getused args (cdr c1))))
		     (rplaca c1 (newnames (car c1) newrib))
		     (walk/s-exp! 
			'newnames
			(cdr c1)
			(append newrib r))
		     e))))
	 (t 
	    (walk/s-exp! 'newnames e r)
	    e)))
	  
(defun legal-args (l ans)
      (let ((temp (cdr l))
	    (ans (cons (car l) ans)))
	 (cond ((null temp)	ans)
	       ((consp temp)	(legal-args temp ans))
	       (t		(cons temp ans)))))

(defun getused (bvl body)
      (cond ((null bvl) nil)
	    ((let ((pair (assq (car bvl) fal)))
		(and pair (conflicting0 (car bvl) body)))
	     ; is (car bvl) something that got tagged
	     ;    and does the tagged form appear in the body?
	     (cons (cons (car bvl) (gensym "^"))
		   (getused (cdr bvl) body)))
	    (t (getused (cdr bvl) body))))

(defun conflicting0 (tagged-id* body)
      (setq tagged-id tagged-id*)
      (ormap 'conflicting1 body))

(defun conflicting1 (e)
      (case (scheme-type-of e)
	 (constant nil)
	 (identifier (let ((temp (tagged? e)))
			(if temp
			    (eq tagged-id temp))))
	 (quoted-exp nil)
	 (#!lambda (let ((args (let ((a (cadr e)))
				  (cond
				     ((null a)	a)
				     ((consp a) (legal-args a nil))
				     (t		(cons a nil))))))
		      (or (ormap 'conflicting1 args)
			  (ormap 'conflicting1 (cddr e)))))
	 (#!if (ormap 'conflicting1 (cdr e)))
	 (#!set! (ormap 'conflicting1 (cdr e)))
	 (t (ormap 'conflicting1 e))))

;(def quote-conflicting
;   (lambda (s)
;      (cond
;	 ((eq (scheme-type-of s) 'constant) nil)
;	 ((consp s) 
;	  (cond
;	     ((memq s boxes) nil)
;	     (t (setq boxes (cons s boxes))
;		(or (quote-conflicting (car s))
;		    (quote-conflicting (cdr s))))))
;	 (t (let ((temp (tagged? s)))
;	       (cond (temp (eq temp tagged-id))
;		     (t nil)))))))	  
;
;(def conflicting1
;   (lambda (tagged-id body) ; tagged-id is untagged form of a tagged ident
;      (cond ((null body) nil)
;	    ((consp body)
;	     (case
;	     (cond ((eq (car body) 'quote)
;		    (prog2 (setq boxes nil)
;			   (quote-conflicting (cadr body))
;			   (setq boxes nil)))
;		   (t (or (conflicting1 tagged-id (car body))
;			  (conflicting1 tagged-id (cdr body))))))
;	    ((setq temp (tagged? body)) (eq temp tagged-id))))))

(defun tagged? (id)
	(get id 'istagged))
(defun untag* (id)
  (let ((p (get id 'istagged)))
    (if p (untag* p) id)))

(defun expand-once (e)
      (cond ((setq temp (st-lookup (car e)))
	     (setq fal nil)
	     (let ((ans (runner
			   'identity
			   (copy-no-constant e)
			   (caddr temp))))
		(setq fal nil)
		ans))
	    ((host-mac? (car e)) (host-mac-dispatch e))
	    (t (raise (list 'SE%expand '|expand-once:|
			 '|car of expression is not a syntactic extension: |
			 (car e))))))

(defun beta-expand (e)
      (setq fal nil)
      (let ((ans (lexpand e)))
	 (setq fal nil)
	 ans))

(defun beta-expand2 (e)
      (let ((current-fal fal))
	 (setq fal nil)
	 (let ((ans (lexpand-no-copy e)))
	    (setq fal current-fal)
	    ans)))

(defun add-to-syntax-table (keywords transform)
      (let ((type (global-namespacetype (car keywords))))
	 (cond ((or (null type)
		    (eq type 'syntactic-extension)
		    (eq type 'special-form))
		(setf (get (car keywords) 'beta-transform)
		      (cons '&transform
			    (cons keywords (cons transform nil))))
		(car keywords))
	       (t (raise
		     (list 'SE%add-to-syntax-table '|add-to-syntax-table:|
			(concatenate 'string (symbol-name (car keywords))
					     " already defined as a")
			type))))))

(defun mkmac-match? (a k p)
      (cond ((eq (car a) (car p)) (mm? a k p))
	    ((and (transform? (car a)) (eq (caadr (car a)) (car p)))
	     (mm? (cdr a) k (cdr p)))
	    (t nil)))

(defun mm? (a k p)
  (cond ((null p)
         (null a))
        
        ((atom p)
         (if (atom a)
             (if (memq p k)
                 (eq a p)
                 t)
             (not (memq p k))))
        
        ((null a)
         (and (consp (cdr p))
              (eq (cadr p) ellipsis)))
        
        ((atom a)
         nil)
        
        ((null (cdr p))
         (and (null (cdr a))
              (mm? (car a) k (car p))))
        
        ((null (cddr p))
         (if (eq ellipsis (cadr p))
             (andmap3 'mm? a k (car p))
             (and (mm? (car a) k (car p))
                  (mm? (cdr a) k (cdr p)))))
        
        ((eq ellipsis (cadr p))
         (if (atom (caddr p))
             (if (memq (caddr p) k)
                 (let ((v (memq (caddr p) a)))
                   (and v
                        (mm? v k (cddr p))
                        (andmap3 'mm? (upto a v) k (car p))))
                 (raise (list 'SE%mkmac '|Improper terminator for ellipsis:|
                              (caddr p))))
             (if (memq (caaddr p) k)
                 (let ((v (member (caaddr p) a
                                  :test '(lambda (a b)
                                           (and (consp b)
						(eq a (car b)))))))
                   (and v
                        (mm? v k (cddr p))
                        (andmap3 'mm? (upto a v) k (car p))))
                 (raise (list 'SE%mkmac '|Improper terminator for ellipsis:|
                              (caddr p))))))
        
        (t
         (and (mm? (car a) k (car p))
              (mm? (cdr a) k (cdr p))))))

(defun andmap3 (f a b c)
  (if a
      (and (funcall f (car a) b c)
           (andmap3 f (cdr a) b c))
      t))

(defun upto (l obj)
  (if (atom l)
      l
      (if (eq (car l) obj)
          ()
          (cons (car l) (upto (cdr l) obj)))))


;(defun mm? (a k p)
;      (cond
;	 ((and (null p) (null a)) t)
;	 ((null p)                nil)
;	 ((atom p)                (if (atom a)
;				      (if (memq p k)
;					  (eq a p)
;					  t)
;				      (not (memq p k))))
;	 ((null a)                (cond ((null (cdr p)) nil)
;					((eq (cadr p) ellipsis) t)
;					(t nil)))
;	 ((atom a)                nil)
;	 ((null (cdr p))          (and (null (cdr a))
;				       (mm? (car a) k (car p))))
;	 ((null (cddr p))         (if (eq ellipsis (cadr p))
;				      t
;				      (and (mm? (car a) k (car p))
;					   (mm? (cdr a) k (cdr p)))))
;	 ((eq ellipsis (cadr p))  (let ((v (memq (caddr p) a)))
;				       (if v (mm? v k (cddr p)))))
;	 (t                       (and (mm? (car a) k (car p))
;				       (mm? (cdr a) k (cdr p))))))

(defun intern* (x)
      (cond
	 ((eq (scheme-type-of x) 'constant) x)
	 ((consp x) 
	  (rplaca x (intern* (car x)))
	  (rplacd x (intern* (cdr x)))
	  x)
	 ((setq temp (get x 'istagged)) temp) ; (intern* temp) ?
	 (t x)))

(defun copying-intern* (x)
      (cond
	 ((eq (scheme-type-of x) 'constant) x)
	 ((consp x) (cons (copying-intern* (car x))
			  (copying-intern* (cdr x))))
	 ((setq temp (get x 'istagged)) temp) ; (intern* temp) ?
	 (t x)))

(defun copy-no-constant (l)
      (gbc 2) 			
      (copy-no-constant* l))

(defun copy-no-constant* (l)
      (if (or (atom l) (eq (scheme-type-of l) 'constant))
	  l
	  (cons (copy-no-constant* (car l))
		(copy-no-constant* (cdr l)))))

(defun copy-no-constant-no-quote (l)
      (gbc 2)
      (copy-no-constant-no-quote* l))

(defun copy-no-constant-no-quote* (l)
      (if (atom l)
	  l
	  (let ((type (scheme-type-of l)))
	       (if (memq type '(constant quoted-exp))
		   l
		   (cons (copy-no-constant-no-quote* (car l))
			 (copy-no-constant-no-quote* (cdr l)))))))
)
