; the Scheme top level read-eval-print loop,
; the Scheme file loader,
; and instructions to load the standard macros, functions, and patches
; nothing defined in std.s may be used in this file---so no macros!

; all the hand S-coded definitions are at the head of top.l and std.s

(begin
  (#!set! standard-input (lisp-eval 'keyboard))
  (#!set! standard-output output-port)
  (#!set! scheme-directory (lisp-eval 'scheme-directory))
  (#!set! save-defining-form (#!lambda (x) x))
  (#!set! scheme-top-level ; for booting
    (#!lambda (v)
      (display v)
      (newline)
      (print "--> ")
      ((#!lambda (x)
	 (#!if (eq? x 'dump!)
	       (begin (#!set! scheme-top-level schemerc-top-level)
		      (remove-from-namespace 'schemerc-top-level)
		      (remove-from-namespace 'pure-load)
		      (lisp-eval '(syscall 10 'savedlisp)) ; unlink
		      (gc)
		      (print "beginning dump of 'savedlisp'")
		      (newline)
		      (lisp-eval '(dumplisp)))
	       (execute
		 (lisp-eval
		   (cons 'purcopy*
		     (cons (cons 'quote (cons (compile x) nil)) nil))))))
       (read))))
  
  (#!set! schemerc-top-level
    ((#!lambda (loop)
       (#!set! loop
	 (#!lambda (v)
	   (display v)
	   (newline)
	   (print scheme-prompt)
	   (execute
	     (compile
	       (save-defining-form (read))))))
       (#!lambda (v)
	 ((#!lambda (home)
	    (let ((msgfile (concat scheme-directory "scheme.msg")))
	      (#!if (file-exists? msgfile) (load msgfile) nil))
	    (#!set! scheme-top-level loop)
	    (#!set! global-scheme-top-level loop)
	    (declare-constant 'global-scheme-top-level)
	    (#!if home
	      ((#!lambda (schemerc)
		 (#!if (file-exists? schemerc) (load schemerc) nil))
	       (concat home
		 (#!if (eq? (lisp-eval 'host-system) 'unix)
		       "/.schemerc"
		       (#!if (eq? (lisp-eval 'host-system) 'vms)
			     "schemerc."
			     nil))))
	      nil)
	    '------------------)
	  (lisp-eval
	    '(getenv
	       (cond ((eq host-system 'unix) 'HOME)
		     ((eq host-system 'vms) 'SYS$LOGIN)))))))
     '*))
  
  (#!set! load
    (#!lambda (filename)
      (((#!lambda (loop)
	  (#!lambda (input-port)
	    (#!if input-port
	      (begin 
		(#!set! loop
		  (#!lambda (form)
		    (#!if (eq? form (lisp-eval '(eof)))
			  (begin (close input-port) t)
			  (begin
			    (execute
			      (compile
				(save-defining-form form)))
			    (loop (read/port input-port))))))
		(loop (read/port input-port)))
	      (begin (newline)
		     (print "[Unable to load file ")
		     (print filename)
		     (print "]")
		     (reset)))))
	'*)
       (open filename 'read))))
  
  (#!set! pure-load  ; used during booting---does not save defining-forms
    (#!lambda (filename)
      (((#!lambda (loop)
	  (#!lambda (input-port)
	    (#!if input-port
	      (begin
		(#!set! loop
		  (#!lambda (form)
		    (#!if (eq? form (lisp-eval '(eof)))
			  (begin (close input-port) t)
			  (begin
			    (execute (compile form))
			    (loop (read/port input-port))))))
		(loop (read/port input-port)))
	      (begin (newline)
		     (print "[Unable to load file ")
		     (print filename)
		     (print "]")
		     (reset)))))
	'*)
       (open filename 'read))))
  
  (print "[scheme-load std.s]") (newline)
  (pure-load (concat scheme-directory "std.s"))
  
  (print "[scheme-load patches.s]") (newline)
  (pure-load (concat scheme-directory "patches.s")))
  
