(eval-when (compile load) (setsyntax 35 'vcharacter)) ;#

(declare (special namespacetypes scheme-directory))
(declare (special pi nat-log-base))
(declare (special **fnv** host-macs procedure-tags))
(declare (special scheme-id-declared-semantics application-declared-semantics
                literal-declare-semantics ))

(eval-when (load compile)
   (setq namespacetypes '(system-function scheme-primitive beta-transform
			    scheme-constant constant-primitive
			    constant-system-function)))

(def if
   (macro (l)
	  (cond ((eq (length l) 3) `(cond (,(cadr l) ,(caddr l))))
		((eq (length l) 4) `(cond (,(cadr l) ,(caddr l))
					  (t ,(cadddr l)))))))

(def purcopy*
   (lambda (s)
      (cond
	 [(atom s)  s]
	 [(purep s) s]
	 [t (let ([x (purcopy (cons nil nil))])
	       (rplaca x (purcopy* (car s)))
	       (rplacd x (purcopy* (cdr s))))])))

(def find-all-of-type
   (macro (l)
	  `(sort (mapcan '(lambda (a)
			     (cond ((get a ,(cadr l)) (cons a nil))))
		    (oblist))
		 'alphalessp)))

(def create
   (macro (l)
	  (let ((enable-tag
		   (intern (implode 
			      (append (explode (caddr l))
				 (explode '-note))))))
	       `(def ,(cadr l)
		      (lambda (id value)
			 (cond
			    ((atom id)
			     (let ((current (global-namespacetype id)))
				  (if current
				     (cond ((eq current ',(caddr l))
					    (cond
					       ((scheme-fluid ',enable-tag)
						(princ "[Redefining ")
						(print id)
						(princ "]")
						(terpri))))
					   (t (princ "[")
					      (princ id)
					      (princ " already defined as a ")
					      (princ current)
					      (princ "]")
					      (terpri)
					      (lisp-debug)
					      (reset))))
				  ,(cond
				      ((eq (caddr l) 'scheme-primitive)
				       '(putprop id
					   (cond
					      ((atom value)
					       (cadr (getl value
							'(scheme-primitive
							  constant-primitive))))
					      (t (purcopy* value)))
					   'scheme-primitive))
				      (t `(putprop id value ',(caddr l))))
				  id))
			    (t (raise
				  (list 'SE%create 0 t '|First argument must evaluate to an atom| id)))))))))

(create create-system-function system-function)

(create create-scheme-primitive scheme-primitive)

(def global-binding
  (lambda (id)
    (cond ((atom id)
	   (prog (gb-location)
		 (cond ((setq gb-location (getl id namespacetypes))
			(return (cadr gb-location)))
		       ((setq gb-location
			  (assq id (cdr (lookupinbase 'base-environment))))
			(return (cdr gb-location)))
		       ((setq gb-location (get id 'beta-transform))
			(return (caddr gb-location)))
		       (t (raise
			    (list 'SE%global 0 t 'global-binding:
			      '|Unbound identifier:| id))))))
	  (t (raise
	       (list 'SE%global 0 t 'global-binding:
		 '|Argument must evaluate to an atom:| id))))))

(def global-namespacetype
   (lambda (id)
      (cond ((atom id)
	     (prog (gb-location)
		   (cond ((syntactic-extension? id)
			  (return 'syntactic-extension))
			 ((memq id '(quote #!lambda #!if #!set!))
			  (return 'special-form))
			 ((setq gb-location (getl id namespacetypes))
			  (return
			     (let ((name (car gb-location)))
				(cond ((eq name 'constant-primitive)
				       'constant)
				      ((eq name 'scheme-constant) 'constant)
				      ((eq name 'constant-system-function)
				       'constant)
				      (t name)))))
			 ((setq gb-location (baselocation id))
			  (return 'base-identifier))
			 (t (return nil)))))
	    (t (raise
		  (list 'SE%global 0 t 'global-namespace-type:
		     '|Argument must evaluate to an atom:| id))))))

(def syntactic-extension?
   (lambda (id)
      (and (symbolp id)
	   (not (null (or (get id 'beta-transform)
			  (memq id host-macs)))))))

(def scheme-constant?
   (lambda (id)
      (and (symbolp id)
	   (not (null (getl id '(scheme-constant constant-primitive
				   constant-system-function)))))))

; function-alias allows aliasing of existing Scheme primitives and Lisp funs

(def function-alias
   (lambda (newname oldname)
      (cond ((and (atom newname) (atom oldname))
	     (prog (type)
		   (setq type (car (getl oldname namespacetypes)))
		   (cond ((eq type 'scheme-primitive)
			  (create-scheme-primitive newname oldname))
			 ((eq type 'constant-primitive)
			  (create-scheme-primitive newname oldname)
			  (declare-constant newname))
			 ((eq type 'beta-transform)
			  (raise (list 'SE%global 0 t
				    'function-alias:
				    oldname
				    '|is defined as a syntactic extension|)))
			 (t (create-system-function newname oldname)))
		   (return newname)))
	    (t (raise (list 'SE%global 0 t 'function-alias:
			 '|Both arguments must evaluate to atoms|))))))

; import makes arbitrary Franz Lisp functions available to Scheme

(def import
   (lambda (lispfunction)
      (cond ((atom lispfunction)
	     (function-alias lispfunction lispfunction))
	    (t (raise (list 'SE%global 0 t 'import:
			 '|Illegal identifier:| lispfunction))))))

(def system-functions
   (lambda () (sort (append (find-all-of-type 'system-function)
		            (find-all-of-type 'constant-system-function))
		    'alphalessp)))

(def scheme-primitives
   (lambda () (sort (append (find-all-of-type 'scheme-primitive)
		            (find-all-of-type 'constant-primitive))
		    'alphalessp)))

(def symbols-bound-to-constants
   (lambda () (sort (append (find-all-of-type 'scheme-constant)
		            (find-all-of-type 'constant-primitive)
			    (find-all-of-type 'constant-system-function))
		    'alphalessp)))

(def beta-transforms
   (lambda () (sort (append host-macs (find-all-of-type 'beta-transform))
		    'alphalessp)))

(def top-level-assigned-identifiers
   (lambda ()
      (sort (append (scheme-primitives)
	       (system-functions)
	       (find-all-of-type 'scheme-constant)
	       (base-identifiers))
	    'alphalessp)))

(def remove-from-namespace
   (lambda (name)
      (cond ((atom name)
	     (let ((type (car (getl name namespacetypes))))
		(cond (type (remprop name type))
		      ((memq name host-macs)
		       (setq host-macs (delq name host-macs)))
		      (t (removefrombase name)))
		(rplacd (baselocation 'defined-forms)
		   (delete (assq name (lookupinbase 'defined-forms))
		      (lookupinbase 'defined-forms))))
	     name)
	    (t (princ "[Argument must evaluate to an atom]")
	       (terpri)
	       (reset)
	       (lisp-debug)))))

(setq scheme-id-declared-semantics nil)
(setq application-declared-semantics nil)

(def set-lexical-semantics
   (lambda (f) (setq scheme-id-declared-semantics f)))

(def set-application-semantics
   (lambda (f) (setq application-declared-semantics f)))

(def set-literal-semantics
   (lambda (f) (setq literal-declared-semantics f)))

(def symbol->ascii
   (lambda (sym)
      (getcharn sym 1)))

(def ascii->symbol
   (lambda (num)
      (implode (list num))))

(status ignore-eof t)

(setsyntax 123 195) ;left brace
(setsyntax 125 196) ;right brace
(setsyntax 91 195)  ;left bracket
(setsyntax 93 196)  ;right bracket
(setsyntax 35 2)    ; #
(setsyntax 92 2)    ;backslash

(setq pi (times 2 (asin 1)))
(setq nat-log-base (exp 1))
;You get the factorial of a number
;by calling (fact n).  If you want the value of the gamma function, 
;you can call (gamma n).  The relationship between the two is 
;(gamma n) = (fact (sub1 n)).

(declare (special gamma-list))

(def <=
   (macro (l) `(or (lessp .,(cdr l)) (= .,(cdr l)))))

(def trfact
   (lambda (y)
      (trfact-help y 1.0)))

(def trfact-help
   (lambda (y result)
      (if (<= y 1) result
	  (trfact-help (sub1 y) (times y result)))))

(setq gamma-list
   (list 1.0e-16
      1.4e-15
      -5.4e-15
      -2.06e-14
      5.1e-13
      -3.6968e-12
      7.7823e-12
      1.043427e-10
      -1.1812746e-9
      5.0020075e-9
      6.116095e-9
      -2.056338417e-7
      1.1330272320e-6
      -1.2504934821e-6
      -0.0000201348547807
      0.0001280502823882
      -0.0002152416741149
      -0.0011651675918591
      0.0072189432466630
      -0.0096219715278770
      -0.0421977345555443
      0.1665386113822915
      -0.0420026350340952
      -0.6558780715202538
      0.5772156649015329
      1.0))

(def recip
   (lambda (y)
      (recip-help y gamma-list 0.0)))

(def recip-help
   (lambda (y v result)
      (cond ((null v) result)
	    (t (recip-help y (cdr v) (plus (times result y) (car v)))))))

(def gamma
   (lambda (x)
      (cond
	 [(and (zerop (diff x (fix x))) (plusp x)) (trfact (sub1 (fix x)))]
	 [(zerop (diff x (fix x))) 'undefined]
	 [t (let ([y (abs x)])
	       (let ([z (diff y (fix y))])
		  (let ([w (minus z)])
		     (cond
			[(and (greaterp x 1)(<= z .5))
			 (quotient (trfact (sub1 x)) (recip z))]
			[(greaterp x 1)
			 (quotient (times (trfact (sub1 x)) z)
			    (recip (sub1 z)))]
			[(and (plusp x) (<= z .5))
			 (quotient 1.0 (times (recip z) z))]
			[(plusp x) 
			 (quotient 1.0 (recip (sub1 z)))]
			[(and (lessp x -1) (<= z .5))
			 (quotient (expt -1.0 (fix y)) 
			    (times (trfact y) (times (recip w) z)))]
			[(lessp x -1) 
			 (quotient (expt -1.0 (fix (add1 y)))
			    (times (times (trfact y) w)
				   (times (recip (add1 w))(add1 w))))]
			[(<= z .5)
			 (quotient 1.0 (times (recip w) w))]
			[t (quotient 1.0
			      (times (recip (add1 w))
				     (times w (add1 w))))]))))])))
	   
(def fact
   (lambda (x)
      (cond ((and (fixp x) (not (minusp x)))
	     (prog (a)
		   (setq a 1)
		   loop (cond ((zerop x) (return a)))
		   (setq a (times a x))
		   (setq x (sub1 x))
		   (go loop)))
	    (t (gamma (add1 x))))))

;This version of factorial is accurate to at least 15 figures for x between
;1 and 2, and it uses the formula that (fact n) = (* n (fact (sub1 n))) to
;get its values for larger x.  It works for all values, positive and negative
;as long as we are not at a negative integer, where factorial is undefined.
;Happy Scheming!


(def transpose
   (lambda (lst)
      (let ((l (make-same-length (reverse lst))))
	   (do ((tl nil (do ((x l (cdr x))
			     (y nil (prog2 nil 
				       (cons (caar x) y)
				       (rplaca x (cdar x)))))
			    ((null x) (cons y tl)))))
	       ((null (car l)) (nreverse tl))))))

(def make-same-length
     (lambda (ll)
       (cond [(null ll) nil]
	     [t (let ([n (apply 'min (mapcar 'length ll))])
		   (cond [(zerop n) (mapcar (function (lambda (l) nil)) ll)]
			 [t (mapcar
			     (function
			       (lambda (l)
				  (progn (trim-to-length (1- n) l) l)))
			     ll)]))])))

(def trim-to-length
   (lambda (n l)
     (cond [(zerop n) (rplacd l nil)]
	   [t (trim-to-length (1- n) (cdr l))])))

(def make-printable
  (lambda (name)
    (rplacd (baselocation 'unprintables)
      (delete (assq name (lookupinbase 'unprintables))
	(lookupinbase 'unprintables)))
    name))

(def make-unprintable
  (lambda (name printname)
    (cond [(null printname)
	   (raise (list 'SE%print 0 t 'make-unprintable:
		    '|unspecified unprintable-symbol|))]
	  [(assq name (lookupinbase 'unprintables)) name]
	  [t (rplacd (baselocation 'unprintables)
	       (nconc (lookupinbase 'unprintables)
		      (list (cons name printname))))
	     name])))

(def reify
   (lambda (e)
      (if (not (and (dtpr e) (atom (car e))))
	  nil
	  (let ((tag (car e)))
	     (cond
		((eq '&cont tag) `(continuation ,(cont-lex-env e) 
				     ,(cont-flu-env e) 
				     ,(next-frame e)))
		((eq '&closure tag) `(closure ,(clo-number-of-args e) 
					,(clo-formals e) 
					,(clo-lex-env e)))
		((eq '&rest-closure tag)
		 `(closure ,(clo-number-of-args e)
		     ,(let ([x (clo-formals e)])
			 (cond
			    [(null (cdr x)) (car x)]
			    [t (let ([y (copy (cdr x))])
				  (rplacd (last y) (car x))
				  y)]))
		     ,(clo-lex-env e)))
		((eq '&transform tag)
		 `(beta-transform ,(keywords-list e) ,(transform-function e)))
		((eq '&sys tag) `(closure 0 x (&lexical-env nil)))
		((eq '&engine tag) `(engine 3 (x y z) 
				       ,(continuation-of-engine e)))
		((eq '&state tag) `(state 0 () ,(continuation-of-engine e)))
		((eq '&port  tag) (file-name-of-port e))
		((eq '&fluid-env tag) `(fluid-environment
					  ,(fl-id e)
					  ,(fl-val e)
					  ,(next-fluid-env e)))
		((eq '&lexical-env tag) `(lexical-environment
					    ,(lex-ids e)
					    ,(lex-vals e)
					    ,(next-lexical-env e)))
		(t nil))))))
	     
(def cont-lex-env
   (lambda (e)
      (let ((cont (cdr e)))
           (let ((frame (car cont)))
	        `(&lexical-env ,(caddr frame))))))

(def cont-flu-env
   (lambda (e)
      (let ((cont (cdr e)))
	   (let ((frame (car cont)))
		`(&fluid-env ,(cdddr frame))))))

(def next-frame
   (lambda (e)
      (let ((cont (cdr e)))
	   (if (null (cdr cont))
	       nil
	       `(&cont ,(cdr cont))))))

(def clo-number-of-args
   (lambda (e)
      (let ((obj (cdr e)))
	   (car (car obj)))))

(def clo-formals
   (lambda (e)
      (let ((obj (cdr e)))
	   (cadr (car obj)))))

(def clo-lex-env
   (lambda (e)
      (let ((obj (cdr e)))
	   `(&lexical-env ,(cdr obj)))))

(def continuation-of-engine
   (lambda (e)
      (let ((obj (cdr e)))
	   `(&cont ,(car obj)))))

(def file-name-of-port
   (lambda (e)
      (let ((obj (cdr e)))
	   (car obj))))

(def fl-id
   (lambda (e)
      (let ((obj (cadr e)))
	   (car (car obj)))))

(def fl-val
   (lambda (e)
      (let ((obj (cadr e)))
	   (cdr (car obj)))))

(def next-fluid-env
   (lambda (e)
      (let ((obj (cadr e)))
	   (if (null (cdr obj))
	       nil
	       `(&fluid-env ,(cdr obj))))))

(def lex-ids
   (lambda (e)
      (let ((obj (cadr e)))
	   (cdr (car obj)))))

(def lex-vals
   (lambda (e)
      (let ((obj (cadr e)))
	   (car (car obj)))))

(def next-lexical-env
   (lambda (e)
      (let ((obj (cadr e)))
	   (if (null (cdr obj))
	       nil
	       `(&lexical-env ,(cdr obj))))))

(def keywords-list
   (lambda (e) (cadr e)))

(def transform-function
   (lambda (e) (caddr e)))

(def eqv
   (lambda (a1 a2)
      (cond ((eq a1 a2) t)
	    ((and (numberp a1) (numberp a2)) (= a1 a2))
	    (t nil))))

(def memv
   (lambda (a l)
      (cond ((null l) nil)
	    ((eqv a (car l)) l)
	    (t (memv a (cdr l))))))

(def assv
   (lambda (a l)
      (cond ((null l) nil)
	    ((eqv a (caar l)) (car l))
	    (t (assv a (cdr l))))))

(setq procedure-tags 
   '(&closure &sys &cont &engine &rest-closure &transform &vector &state))

(def proc?
   (lambda (a)
      (and (dtpr a)
	   (memq (car a) procedure-tags)
	   t)))
