
; Clobber some internal Lucid functions to make Pseudoscheme run
; better.  This will probably break in some future Lucid release, but
; it works in 4.0.1 on a sparc.

(in-package "SCHI")

(defvar *original-top-level-read*
  #'lucid::top-level-read)

(defun lucid::top-level-read (&optional (input-stream *debug-io*)
					(eof-error-p t)
					eof-value)
  (if (eq *package* scheme-package)
      (let* ((*readtable* scheme-readtable)
	     (form (funcall *original-top-level-read*
			    input-stream eof-error-p eof-value)))
	(if (or (keywordp form) (numberp form) (eq form eof-value))
	    form
	    (setq - `(scheme-form ,form))))
      (funcall *original-top-level-read*
	       input-stream eof-error-p eof-value)))

(defvar *original-debugger-top-level-read*
  #'lucid::debugger-top-level-read)

(defun lucid::debugger-top-level-read (&optional (input-stream *debug-io*)
						 (eof-error-p t)
						 eof-value)
  (if (eq *package* scheme-package)
      (let* ((*readtable* scheme-readtable)
	     (form (funcall *original-debugger-top-level-read*
			    input-stream eof-error-p eof-value)))
	(if (or (keywordp form) (numberp form) (eq form eof-value))
	    form
	    (setq - `(scheme-form ,form))))
      (funcall *original-debugger-top-level-read*
	       input-stream eof-error-p eof-value)))
